/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.entity;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.valhelsia.valhelsia_furniture.common.block.SeatableBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModEntities;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends Entity {
    private EjectType ejectType = EjectType.NORTH;

    public SeatEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SeatEntity(BlockPos pos, double ridingOffset, Level level, EjectType ejectType) {
        super((EntityType)ModEntities.SEAT.get(), level);
        this.ejectType = ejectType;
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + ridingOffset, (double)pos.getZ() + 0.5);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            BlockPos pos = this.blockPosition();
            if (this.getPassengers().isEmpty() || this.level().isEmptyBlock(pos)) {
                this.discard();
                this.level().updateNeighbourForOutputSignal(pos, this.level().getBlockState(pos).getBlock());
            }
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        return false;
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            this.getPassengers().forEach(Entity::stopRiding);
        }
        super.remove(reason);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity livingEntity) {
        BlockPos pos = this.blockPosition();
        if (this.getSeatableBlock(this.level(), pos).isEmpty()) {
            return super.getDismountLocationForPassenger(livingEntity);
        }
        int[][] offsets = DismountHelper.offsetsForDirection((Direction)this.ejectType.getPreferredDirection(this.level().getBlockState(pos), livingEntity).getCounterClockWise());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.getDismountPoses()) {
            AABB aabb = livingEntity.getLocalBoundsForPose(pose);
            for (int[] offset : offsets) {
                mutableBlockPos.set(pos.getX() + offset[0], pos.getY(), pos.getZ() + offset[1]);
                double floorHeight = this.level().getBlockFloorHeight((BlockPos)mutableBlockPos);
                if (!DismountHelper.isBlockFloorValid((double)floorHeight)) continue;
                Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)mutableBlockPos, (double)floorHeight);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)livingEntity, (AABB)aabb.move(vec3))) continue;
                livingEntity.setPose(pose);
                return vec3;
            }
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    private Optional<SeatableBlock> getSeatableBlock(Level level, BlockPos pos) {
        Optional<SeatableBlock> optional;
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof SeatableBlock) {
            SeatableBlock seatableBlock = (SeatableBlock)block;
            optional = Optional.of(seatableBlock);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.ejectType = input.read("eject_type", EjectType.CODEC).orElse(EjectType.NORTH);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.store("eject_type", EjectType.CODEC, (Object)this.ejectType);
    }

    public static enum EjectType implements StringRepresentable
    {
        NORTH("north", (state, livingEntity) -> Direction.NORTH),
        BLOCK_HORIZONTAL_FACING("block_horizontal_facing", (state, livingEntity) -> (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)),
        ENTITY_HEAD_ROTATION("entity_head_rotation", (state, livingEntity) -> Direction.fromYRot((double)livingEntity.yHeadRot));

        static final Codec<EjectType> CODEC;
        private final String name;
        private final BiFunction<BlockState, LivingEntity, Direction> preferredDirection;

        private EjectType(String name, BiFunction<BlockState, LivingEntity, Direction> preferredDirection) {
            this.name = name;
            this.preferredDirection = preferredDirection;
        }

        public String getName() {
            return this.name;
        }

        public Direction getPreferredDirection(BlockState state, LivingEntity livingEntity) {
            return this.preferredDirection.apply(state, livingEntity);
        }

        public static EjectType fromName(String name) {
            return Arrays.stream(EjectType.values()).filter(ejectType -> ejectType.getName().equals(name)).findFirst().orElse(NORTH);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EjectType::values);
        }
    }
}

