/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends class_2248
implements class_3737,
FurnitureBlock {
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    private static final class_2746 ROTATED = ModBlockStateProperties.ROTATED;
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final EnumMap<class_2350, class_2746> PROPERTY_BY_DIRECTION = (EnumMap)class_156.method_654(new EnumMap(class_2350.class), map -> {
        map.put(class_2350.field_11043, NORTH);
        map.put(class_2350.field_11034, EAST);
        map.put(class_2350.field_11035, SOUTH);
        map.put(class_2350.field_11039, WEST);
    });
    private static final class_265 TOP_SHAPE = class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<class_2350, class_265> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    private static final Map<class_2350, class_265> ONE_LEG_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((class_265)class_259.method_1084((class_265)TOP_SHAPE, (class_265)class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)));
    private static final class_265 SHAPE = class_259.method_17786((class_265)TOP_SHAPE, (class_265[])new class_265[]{class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), class_2248.method_9541((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), class_2248.method_9541((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), class_2248.method_9541((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private final class_4719 woodType;

    public TableBlock(class_4719 woodType, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ROTATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.woodType = woodType;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        ArrayList<class_2350> connectedDirections = new ArrayList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10166() == class_2350.class_2351.field_11052 || !((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            connectedDirections.add(direction);
        }
        if (connectedDirections.size() >= 3 || connectedDirections.size() == 2 && connectedDirections.getFirst() == ((class_2350)connectedDirections.get(1)).method_10153()) {
            return TOP_SHAPE;
        }
        if (connectedDirections.size() == 1) {
            return TWO_LEGS_SHAPES.get(connectedDirections.getFirst());
        }
        if (connectedDirections.size() == 2) {
            boolean flag = ((class_2350)connectedDirections.getFirst()).method_10170() == connectedDirections.get(1);
            return flag ? ONE_LEG_SHAPES.get(connectedDirections.getFirst()) : ONE_LEG_SHAPES.get(connectedDirections.get(1));
        }
        return SHAPE;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        class_2338 pos;
        class_1937 level = context.method_8045();
        boolean waterlogged = level.method_8316(pos = context.method_8037()).method_15772() == class_3612.field_15910;
        boolean rotated = context.method_8042().method_10166() == class_2350.class_2351.field_11048;
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATED, (Comparable)Boolean.valueOf(rotated))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        level.method_64310(pos, (class_2248)this, 1);
        return state;
    }

    private int getTableLength(class_1937 level, class_2338 pos, class_2350 direction) {
        return this.getTableLengthInDirection(level, pos, direction) + this.getTableLengthInDirection(level, pos, direction.method_10153());
    }

    private int getTableLengthInDirection(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2680 state;
        int i = 1;
        while ((state = level.method_8320(pos.method_10079(direction, i))).method_26204() instanceof TableBlock && ((Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10153()))).booleanValue()) {
            ++i;
        }
        return i;
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        List<class_2350> directions = class_2350.class_2353.field_11062.method_29716().filter(direction -> (Boolean)state.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction)) == false).toList();
        for (class_2350 direction2 : directions) {
            int tableLengthNeighbor;
            int tableLengthCurrent;
            class_2338 offsetPos = pos.method_10093(direction2);
            class_2680 offsetState = level.method_8320(offsetPos);
            if (!(offsetState.method_26204() instanceof TableBlock) || (tableLengthCurrent = this.getTableLength((class_1937)level, pos, direction2.method_10170())) != (tableLengthNeighbor = this.getTableLength((class_1937)level, offsetPos, direction2.method_10170()))) continue;
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(true)));
            level.method_64310(pos, (class_2248)this, 1);
            break;
        }
    }

    public boolean method_9526(@NotNull class_2680 state) {
        return true;
    }

    @NotNull
    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 tickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return state;
        }
        class_2746 property = PROPERTY_BY_DIRECTION.get(direction);
        class_2746 oppositeProperty = PROPERTY_BY_DIRECTION.get(direction.method_10153());
        boolean isAlreadyConnected = (Boolean)state.method_11654((class_2769)property);
        boolean isNeighborTable = neighborState.method_26204() instanceof TableBlock;
        boolean isNeighborConnected = isNeighborTable && (Boolean)neighborState.method_11654((class_2769)oppositeProperty) != false;
        state = (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(isNeighborConnected));
        if (isAlreadyConnected && isNeighborConnected) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()), (Comparable)((Boolean)neighborState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10170()))))).method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160()), (Comparable)((Boolean)neighborState.method_11654((class_2769)PROPERTY_BY_DIRECTION.get(direction.method_10160()))));
        }
        return state;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 state, @NotNull class_2470 rotation) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.method_11654((class_2769)entry.getValue())).booleanValue()) {
                directions.add(rotation.method_10503(entry.getKey()));
            }
            state = (class_2680)state.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (class_2350 direction : directions) {
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
        ArrayList<class_2350> directions = new ArrayList<class_2350>();
        for (Map.Entry<class_2350, class_2746> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (((Boolean)state.method_11654((class_2769)entry.getValue())).booleanValue()) {
                directions.add(mirror.method_10343(entry.getKey()));
            }
            state = (class_2680)state.method_11657((class_2769)entry.getValue(), (Comparable)Boolean.valueOf(false));
        }
        for (class_2350 direction : directions) {
            state = (class_2680)state.method_11657((class_2769)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{NORTH, EAST, SOUTH, WEST, ROTATED, WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public FurnitureBlock.Type getType() {
        return FurnitureBlock.Type.TABLE;
    }
}

