/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.entity;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.valhelsia.valhelsia_furniture.common.block.SeatableBlock;
import net.valhelsia.valhelsia_furniture.core.registry.ModEntities;
import org.jetbrains.annotations.NotNull;

public class SeatEntity
extends class_1297 {
    private EjectType ejectType = EjectType.NORTH;

    public SeatEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public SeatEntity(class_2338 pos, double ridingOffset, class_1937 level, EjectType ejectType) {
        super((class_1299)ModEntities.SEAT.get(), level);
        this.ejectType = ejectType;
        this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + ridingOffset, (double)pos.method_10260() + 0.5);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_73183().method_8608()) {
            class_2338 pos = this.method_24515();
            if (this.method_5685().isEmpty() || this.method_73183().method_22347(pos)) {
                this.method_31472();
                this.method_73183().method_8455(pos, this.method_73183().method_8320(pos).method_26204());
            }
        }
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        return false;
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        if (reason == class_1297.class_5529.field_26999) {
            this.method_5685().forEach(class_1297::method_5848);
        }
        super.method_5650(reason);
    }

    @NotNull
    public class_243 method_24829(@NotNull class_1309 livingEntity) {
        class_2338 pos = this.method_24515();
        if (this.getSeatableBlock(this.method_73183(), pos).isEmpty()) {
            return super.method_24829(livingEntity);
        }
        int[][] offsets = class_5275.method_27934((class_2350)this.ejectType.getPreferredDirection(this.method_73183().method_8320(pos), livingEntity).method_10160());
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_4050 pose : livingEntity.method_24831()) {
            class_238 aabb = livingEntity.method_24833(pose);
            for (int[] offset : offsets) {
                mutableBlockPos.method_10103(pos.method_10263() + offset[0], pos.method_10264(), pos.method_10260() + offset[1]);
                double floorHeight = this.method_73183().method_30347((class_2338)mutableBlockPos);
                if (!class_5275.method_27932((double)floorHeight)) continue;
                class_243 vec3 = class_243.method_26410((class_2382)mutableBlockPos, (double)floorHeight);
                if (!class_5275.method_27933((class_1941)this.method_73183(), (class_1309)livingEntity, (class_238)aabb.method_997(vec3))) continue;
                livingEntity.method_18380(pose);
                return vec3;
            }
        }
        return super.method_24829(livingEntity);
    }

    private Optional<SeatableBlock> getSeatableBlock(class_1937 level, class_2338 pos) {
        Optional<SeatableBlock> optional;
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof SeatableBlock) {
            SeatableBlock seatableBlock = (SeatableBlock)class_22482;
            optional = Optional.of(seatableBlock);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_11368 input) {
        this.ejectType = input.method_71426("eject_type", EjectType.CODEC).orElse(EjectType.NORTH);
    }

    protected void method_5652(class_11372 output) {
        output.method_71468("eject_type", EjectType.CODEC, (Object)this.ejectType);
    }

    public static enum EjectType implements class_3542
    {
        NORTH("north", (state, livingEntity) -> class_2350.field_11043),
        BLOCK_HORIZONTAL_FACING("block_horizontal_facing", (state, livingEntity) -> (class_2350)state.method_11654((class_2769)class_2741.field_12481)),
        ENTITY_HEAD_ROTATION("entity_head_rotation", (state, livingEntity) -> class_2350.method_10150((double)livingEntity.field_6241));

        static final Codec<EjectType> CODEC;
        private final String name;
        private final BiFunction<class_2680, class_1309, class_2350> preferredDirection;

        private EjectType(String name, BiFunction<class_2680, class_1309, class_2350> preferredDirection) {
            this.name = name;
            this.preferredDirection = preferredDirection;
        }

        public String getName() {
            return this.name;
        }

        public class_2350 getPreferredDirection(class_2680 state, class_1309 livingEntity) {
            return this.preferredDirection.apply(state, livingEntity);
        }

        public static EjectType fromName(String name) {
            return Arrays.stream(EjectType.values()).filter(ejectType -> ejectType.getName().equals(name)).findFirst().orElse(NORTH);
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(EjectType::values);
        }
    }
}

