/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.normal.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.normal.entity.ThumbnailEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class ThumbnailRenderer
extends HumanoidMobRenderer<ThumbnailEntity, HumanoidRenderState, HumanoidModel<HumanoidRenderState>> {
    private ThumbnailEntity entity = null;

    public ThumbnailRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER)), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new RenderLayer<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"normal:textures/entities/transparent.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, HumanoidRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                ((HumanoidModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<HumanoidRenderState, HumanoidModel<HumanoidRenderState>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"normal:textures/entities/cfcf2cc9d9156d8a23da173f62f230c6d80cdace.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, HumanoidRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((HumanoidModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public HumanoidRenderState createRenderState() {
        return new HumanoidRenderState();
    }

    public void extractRenderState(ThumbnailEntity entity, HumanoidRenderState state, float partialTicks) {
        super.extractRenderState((Mob)entity, state, partialTicks);
        this.entity = entity;
    }

    public ResourceLocation getTextureLocation(HumanoidRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("normal:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"normal:textures/entities/cfcf2cc9d9156d8a23da173f62f230c6d80cdace.png");
    }
}

