/*
 * Decompiled with CFR 0.152.
 */
package de.beqare.teamChatPrefix;

import de.beqare.teamChatPrefix.Updater;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TeamChatPrefix
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private String chatFormat;
    private boolean useTeamColor;
    private ChatColor defaultColor;
    private boolean enabled;
    private boolean showTeamNameInConsole;
    private Updater updater;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("tcp")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("tcp")).setTabCompleter((TabCompleter)this);
        this.getLogger().info("TeamChatPrefix v" + this.getDescription().getVersion() + " has been enabled");
        this.updater = new Updater(this, "teamchatprefix");
        this.updater.checkForUpdates();
    }

    private void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        config.addDefault("enabled", (Object)true);
        config.addDefault("format", (Object)"%teamcolor%%prefix%%playername%%suffix%\u00a78 \u00bb \u00a77%message%");
        config.addDefault("use-team-color", (Object)true);
        config.addDefault("default-color", (Object)"WHITE");
        config.addDefault("show-team-name-in-console", (Object)false);
        config.addDefault("update-checker.enabled", (Object)true);
        config.addDefault("update-checker.interval-minutes", (Object)60);
        config.options().copyDefaults(true);
        this.saveConfig();
        try {
            this.enabled = config.getBoolean("enabled");
            this.chatFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(config.getString("format"), "Format cannot be null"));
            this.useTeamColor = config.getBoolean("use-team-color");
            this.showTeamNameInConsole = config.getBoolean("show-team-name-in-console");
            String colorString = config.getString("default-color", "WHITE");
            this.defaultColor = this.parseChatColor(colorString);
            if (this.defaultColor == null) {
                this.getLogger().warning("Invalid default-color in config: " + colorString + ". Using WHITE as fallback.");
                this.defaultColor = ChatColor.WHITE;
            }
            this.getLogger().info("Configuration loaded successfully");
            if (!this.enabled) {
                this.getLogger().info("Plugin is currently disabled in config");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error loading configuration: " + e.getMessage(), e);
            this.enabled = true;
            this.chatFormat = "%teamcolor%%prefix%%playername%%suffix%\u00a78 \u00bb \u00a77%message%";
            this.useTeamColor = true;
            this.defaultColor = ChatColor.WHITE;
            this.showTeamNameInConsole = false;
        }
    }

    private ChatColor parseChatColor(String colorString) {
        if (colorString == null || colorString.isEmpty()) {
            return ChatColor.WHITE;
        }
        String cleanColor = colorString.replace("\u00a7", "").replace("&", "");
        try {
            return ChatColor.valueOf((String)cleanColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (cleanColor.length() == 1) {
                return ChatColor.getByChar((char)cleanColor.charAt(0));
            }
            return null;
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, Command cmd, @NotNull String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("tcp")) {
            return false;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "version": {
                return this.handleVersion(sender);
            }
            case "status": {
                return this.handleStatus(sender);
            }
            case "toggle": {
                return this.handleToggle(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("teamchatprefix.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload the config!");
            return true;
        }
        try {
            this.loadConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "TeamChatPrefix config reloaded successfully!");
            this.getLogger().info("Configuration reloaded by " + sender.getName());
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Error while reloading config: " + e.getMessage());
            this.getLogger().log(Level.SEVERE, "Error reloading config: " + e.getMessage(), e);
        }
        return true;
    }

    private boolean handleVersion(CommandSender sender) {
        String current = this.getDescription().getVersion();
        String latest = this.updater.getLatestVersion();
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TeamChatPrefix Version Information:");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Current: " + String.valueOf(ChatColor.AQUA) + current);
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Author: " + String.valueOf(ChatColor.GREEN) + "beqare");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Source: " + String.valueOf(ChatColor.UNDERLINE) + "https://github.com/beqare/TeamChatPrefix");
        if (latest != null) {
            if (latest.equals(current)) {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Status: " + String.valueOf(ChatColor.GREEN) + "Up to date \u2705");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Latest: " + String.valueOf(ChatColor.RED) + latest + " (update available!)");
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Download: " + String.valueOf(ChatColor.UNDERLINE) + "https://modrinth.com/plugin/teamchatprefix");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + " \u2022 Could not fetch latest version information");
        }
        return true;
    }

    private boolean handleStatus(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TeamChatPrefix Status:");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Enabled: " + (this.enabled ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Use Team Color: " + (this.useTeamColor ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Default Color: " + String.valueOf(this.defaultColor) + this.defaultColor.name());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + " \u2022 Current Format: " + String.valueOf(ChatColor.RESET) + this.chatFormat);
        return true;
    }

    private boolean handleToggle(CommandSender sender) {
        if (!sender.hasPermission("teamchatprefix.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle the plugin!");
            return true;
        }
        this.enabled = !this.enabled;
        this.getConfig().set("enabled", (Object)this.enabled);
        this.saveConfig();
        String status = this.enabled ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TeamChatPrefix has been " + status + String.valueOf(ChatColor.YELLOW) + "!");
        this.getLogger().info("Plugin " + (this.enabled ? "enabled" : "disabled") + " by " + sender.getName());
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "TeamChatPrefix Commands:");
        if (sender.hasPermission("teamchatprefix.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/tcp reload " + String.valueOf(ChatColor.GRAY) + "- Reload the configuration");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/tcp toggle " + String.valueOf(ChatColor.GRAY) + "- Toggle plugin on/off");
        }
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/tcp version " + String.valueOf(ChatColor.GRAY) + "- Show version information");
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "/tcp status " + String.valueOf(ChatColor.GRAY) + "- Show current status");
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("version");
            commands.add("status");
            if (sender.hasPermission("teamchatprefix.reload")) {
                commands.add("reload");
                commands.add("toggle");
            }
            for (String cmd : commands) {
                if (!cmd.startsWith(partial)) continue;
                completions.add(cmd);
            }
        }
        return completions;
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        Team team = player.getScoreboard().getEntryTeam(player.getName());
        String teamName = team != null ? team.getName() : "";
        String prefix = team != null ? team.getPrefix() : "";
        String suffix = team != null ? team.getSuffix() : "";
        ChatColor color = this.useTeamColor && team != null && team.getColor() != null ? team.getColor() : this.defaultColor;
        String formattedMessage = this.chatFormat.replace("%playername%", player.getDisplayName()).replace("%team%", teamName).replace("%prefix%", prefix).replace("%suffix%", suffix).replace("%teamcolor%", color.toString()).replace("%message%", event.getMessage());
        event.setFormat(ChatColor.translateAlternateColorCodes((char)'&', (String)formattedMessage));
        if (this.showTeamNameInConsole && team != null) {
            this.getLogger().info("[" + teamName + "] " + player.getName() + ": " + event.getMessage());
        }
    }

    public void onDisable() {
        this.getLogger().info("TeamChatPrefix v" + this.getDescription().getVersion() + " has been disabled");
    }
}

