/*
 * Decompiled with CFR 0.152.
 */
package de.beqare.teamChatPrefix;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Updater {
    private final JavaPlugin plugin;
    private final String projectSlug;
    private String latestVersion = null;
    private boolean updateAvailable = false;

    public Updater(JavaPlugin plugin, String projectSlug) {
        this.plugin = plugin;
        this.projectSlug = projectSlug;
    }

    public void checkForUpdates() {
        if (!this.plugin.getConfig().getBoolean("update-checker.enabled", true)) {
            this.plugin.getLogger().info("Update checker is disabled in config");
            return;
        }
        int interval = this.plugin.getConfig().getInt("update-checker.interval-minutes", 60);
        new BukkitRunnable(){

            public void run() {
                Updater.this.fetchUpdateData();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 100L, (long)(interval * 60) * 20L);
        this.fetchUpdateData();
    }

    private void fetchUpdateData() {
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectSlug + "/version");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "TeamChatPrefix/" + this.plugin.getDescription().getVersion());
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                this.plugin.getLogger().warning("Update check failed: HTTP " + responseCode);
                return;
            }
            JsonArray versions = JsonParser.parseReader((Reader)new InputStreamReader(conn.getInputStream())).getAsJsonArray();
            if (!versions.isEmpty()) {
                JsonElement latest = versions.get(0);
                this.latestVersion = latest.getAsJsonObject().get("version_number").getAsString();
                String currentVersion = this.plugin.getDescription().getVersion();
                if (!this.latestVersion.equals(currentVersion)) {
                    this.updateAvailable = true;
                    this.plugin.getLogger().warning("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                    this.plugin.getLogger().warning("\u2551           UPDATE AVAILABLE!           \u2551");
                    this.plugin.getLogger().warning("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
                    this.plugin.getLogger().warning("\u2551 Plugin: TeamChatPrefix                \u2551");
                    this.plugin.getLogger().warning("\u2551 Current: " + currentVersion + "                      \u2551");
                    this.plugin.getLogger().warning("\u2551 Latest:  " + this.latestVersion + "                      \u2551");
                    this.plugin.getLogger().warning("\u2551                                        \u2551");
                    this.plugin.getLogger().warning("\u2551 Download: https://modrinth.com/plugin/\u2551");
                    this.plugin.getLogger().warning("\u2551             " + this.projectSlug + "                \u2551");
                    this.plugin.getLogger().warning("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                } else {
                    this.plugin.getLogger().info("TeamChatPrefix is up to date (" + currentVersion + ")");
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
        }
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }
}

