/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.NeoForgeTradeCyclingClientMod;
import de.maxhenkel.tradecycling.TradeCyclingMod;
import de.maxhenkel.tradecycling.net.CycleTradesPacket;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="trade_cycling")
public class NeoForgeTradeCyclingMod
extends TradeCyclingMod {
    private NeoForgeTradeCyclingClientMod clientMod;

    public NeoForgeTradeCyclingMod(IEventBus eventBus) {
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::onRegisterPayloadHandler);
        if (FMLEnvironment.getDist().isClient()) {
            this.clientMod = new NeoForgeTradeCyclingClientMod(eventBus);
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.init();
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("trade_cycling").optional();
        registrar.playToServer(CycleTradesPacket.CYCLE_TRADES, CycleTradesPacket.CODEC, (payload, context) -> {
            Player patt0$temp;
            if (context.flow().equals((Object)PacketFlow.SERVERBOUND) && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                context.enqueueWork(() -> NeoForgeTradeCyclingMod.onCycleTrades(player));
            }
        });
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

