/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.config.TradeCyclingClientConfig;
import de.maxhenkel.tradecycling.gui.CycleTradesButton;
import de.maxhenkel.tradecycling.mixin.AbstractContainerScreenAccessor;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.MerchantMenu;

public abstract class TradeCyclingClientMod {
    public static TradeCyclingClientConfig CONFIG;
    public static final KeyMapping CYCLE_TRADES_KEY;

    public void clientInit() {
        this.registerKeyBindings();
    }

    public abstract void sendCycleTradesPacket();

    public abstract TradeCyclingClientConfig createClientConfig();

    public void registerKeyBindings() {
    }

    public <T extends GuiEventListener & Renderable> void onOpenScreen(Screen screen, Consumer<T> eventConsumer) {
        if (!(screen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen merchantScreen = (MerchantScreen)screen;
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return;
        }
        AbstractContainerScreenAccessor s = (AbstractContainerScreenAccessor)screen;
        TradeCyclingClientConfig.CycleTradesButtonLocation loc = CONFIG.getCycleTradesButtonLocation();
        if (loc.equals((Object)TradeCyclingClientConfig.CycleTradesButtonLocation.NONE)) {
            return;
        }
        eventConsumer.accept(new CycleTradesButton(switch (loc) {
            default -> s.getLeftPos() + 107;
            case TradeCyclingClientConfig.CycleTradesButtonLocation.TOP_RIGHT -> s.getLeftPos() + 250;
        }, s.getTopPos() + 8, b -> this.sendCycleTradesPacket(), merchantScreen));
    }

    public void onCycleKeyPressed(KeyEvent event, int action) {
        if (!CYCLE_TRADES_KEY.matches(event) || action != 1) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Screen currentScreen = mc.screen;
        if (!(currentScreen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen screen = (MerchantScreen)currentScreen;
        if (!((MerchantMenu)screen.getMenu()).showProgressBar() || ((MerchantMenu)screen.getMenu()).getTraderXp() > 0) {
            return;
        }
        this.sendCycleTradesPacket();
        mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    static {
        CYCLE_TRADES_KEY = new KeyMapping("key.trade_cycling.cycle_trades", 67, KeyMapping.Category.INVENTORY);
    }
}

