/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.ForgeTradeCyclingMod;
import de.maxhenkel.tradecycling.TradeCyclingClientMod;
import de.maxhenkel.tradecycling.config.ForgeTradeCyclingClientConfig;
import de.maxhenkel.tradecycling.config.TradeCyclingClientConfig;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeTradeCyclingClientMod
extends TradeCyclingClientMod {
    protected FMLJavaModLoadingContext context;

    public ForgeTradeCyclingClientMod(FMLJavaModLoadingContext context) {
        this.context = context;
        FMLClientSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::clientSetup);
        RegisterKeyMappingsEvent.BUS.addListener(this::onRegisterKeyBinds);
        ScreenEvent.Init.Post.BUS.addListener(this::onInitScreen);
        InputEvent.Key.BUS.addListener(this::onKeyInput);
        CONFIG = this.createClientConfig();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.clientInit();
    }

    @Override
    public void sendCycleTradesPacket() {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            ForgeTradeCyclingMod.CYCLE_TRADES_CHANNEL.send((Object)new FriendlyByteBuf(Unpooled.buffer()), connection.getConnection());
        }
    }

    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        event.register(CYCLE_TRADES_KEY);
    }

    @Override
    public TradeCyclingClientConfig createClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ForgeTradeCyclingClientConfig config = new ForgeTradeCyclingClientConfig(builder);
        this.context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)builder.build());
        return config;
    }

    public void onInitScreen(ScreenEvent.Init.Post event) {
        this.onOpenScreen(event.getScreen(), x$0 -> event.addListener((GuiEventListener)x$0));
    }

    public void onKeyInput(InputEvent.Key event) {
        this.onCycleKeyPressed(new KeyEvent(event.getKey(), event.getScanCode(), event.getModifiers()), event.getAction());
    }
}

