/*
 * Decompiled with CFR 0.152.
 */
package nofrills.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_243;
import net.minecraft.class_437;
import nofrills.Main;
import nofrills.config.Config;
import nofrills.features.general.PartyCommands;
import nofrills.features.general.PearlRefill;
import nofrills.features.hunting.ShardTracker;
import nofrills.hud.HudEditorScreen;
import nofrills.hud.clickgui.ClickGui;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class NoFrillsCommand {
    private static final LiteralArgumentBuilder<FabricClientCommandSource> queueCommandBuilder = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"queue").executes(context -> 1);
    public static final ModCommand[] commands = new ModCommand[]{new ModCommand("settings", "Opens the settings GUI.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"settings").executes(context -> {
        Utils.setScreen((class_437)new ClickGui());
        return 1;
    })).then(ClientCommandManager.literal((String)"load").executes(context -> {
        Config.load();
        Utils.info("\u00a7aLoaded latest settings from the configuration file.");
        return 1;
    }))).then(ClientCommandManager.literal((String)"save").executes(context -> {
        Config.save();
        Utils.info("\u00a7aSaved your current settings to the configuration file.");
        return 1;
    })))), new ModCommand("partyCommands", "Allows you to manage the player whitelist and blacklist for the Party Commands feature.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"partyCommands").executes(context -> {
        Utils.info("\u00a7f\u00a7lWhitelist and blacklist\u00a77: You can manage either list with the \u00a7f\"/nf partyCommands whitelist/blacklist\" \u00a77command. Whitelisted players always have their commands processed automatically (unless disabled), and blacklisted players always have their commands rejected.\n\n\u00a7f\u00a7lHow each command mode works\u00a77:\n- Automatic: Automatically process the command.\n- Manual: Adds a button in chat which must be clicked to process the command.\n- Ignore: Rejects the command from any non-whitelisted players.\n- Disabled: The command is fully disabled.");
        return 1;
    })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"whitelist").executes(context -> {
        Utils.info("\u00a77List of options: add, remove, get, clear");
        return 1;
    })).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").executes(context -> {
        Utils.info("\u00a77You must provide the name of the player that you want to add.");
        return 1;
    })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(context -> {
        String name = Utils.toLower(StringArgumentType.getString((CommandContext)context, (String)"playerName"));
        if (PartyCommands.isOnList(name, "whitelist")) {
            Utils.infoFormat("\u00a77{} is already in the party whitelist.", name);
        } else if (PartyCommands.isOnList(name, "blacklist")) {
            Utils.infoFormat("\u00a77{} is already in the party blacklist.", name);
        } else {
            PartyCommands.addToList(name, "whitelist");
            Utils.infoFormat("\u00a7aAdded {} to the party commands whitelist.", name);
        }
        return 1;
    })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(context -> {
        Utils.info("\u00a77You must provide the name of the player that you want to remove.");
        return 1;
    })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(context -> {
        String name = Utils.toLower(StringArgumentType.getString((CommandContext)context, (String)"playerName"));
        if (!PartyCommands.isOnList(name, "whitelist")) {
            Utils.infoFormat("\u00a77{} is not in the party whitelist.", name);
        } else if (PartyCommands.isOnList(name, "blacklist")) {
            Utils.infoFormat("\u00a77{} is already in the party blacklist.", name);
        } else {
            PartyCommands.removeFromList(name, "whitelist");
            Utils.infoFormat("\u00a7aRemoved {} to the party commands whitelist.", name);
        }
        return 1;
    })))).then(ClientCommandManager.literal((String)"get").executes(context -> {
        if (PartyCommands.isListEmpty("whitelist")) {
            Utils.info("\u00a77Your party whitelist is currently empty.");
        } else {
            StringBuilder players = new StringBuilder();
            for (JsonElement player : PartyCommands.lists.value().get("whitelist").getAsJsonArray()) {
                players.append(player.getAsString()).append(" ");
            }
            Utils.infoFormat("\u00a7aList of all whitelisted players: \u00a77{}", players.toString().trim().replaceAll(" ", ", "));
        }
        return 1;
    }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
        if (PartyCommands.isListEmpty("whitelist")) {
            Utils.info("\u00a77Your party whitelist is currently empty.");
        } else {
            PartyCommands.lists.value().add("whitelist", (JsonElement)new JsonArray());
            Utils.info("\u00a7aSuccessfully cleared the party commands whitelist.");
        }
        return 1;
    })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"blacklist").executes(context -> {
        Utils.info("\u00a77List of options: add, remove, get, clear");
        return 1;
    })).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").executes(context -> {
        Utils.info("\u00a77You must provide the name of the player that you want to add.");
        return 1;
    })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(context -> {
        String name = Utils.toLower(StringArgumentType.getString((CommandContext)context, (String)"playerName"));
        if (PartyCommands.isOnList(name, "blacklist")) {
            Utils.infoFormat("\u00a77{} is already in the party blacklist.", name);
        } else if (PartyCommands.isOnList(name, "whitelist")) {
            Utils.infoFormat("\u00a77{} is already in the party whitelist.", name);
        } else {
            PartyCommands.addToList(name, "blacklist");
            Utils.infoFormat("\u00a7aSuccessfully added {} to the party commands blacklist.", name);
        }
        return 1;
    })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(context -> {
        Utils.info("\u00a77You must provide the name of the player that you want to remove.");
        return 1;
    })).then(ClientCommandManager.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(context -> {
        String name = Utils.toLower(StringArgumentType.getString((CommandContext)context, (String)"playerName"));
        if (!PartyCommands.isOnList(name, "blacklist")) {
            Utils.infoFormat("\u00a77{} is not in the party blacklist.", name);
        } else if (PartyCommands.isOnList(name, "whitelist")) {
            Utils.infoFormat("\u00a77{} is in the party whitelist, not blacklist.", name);
        } else {
            PartyCommands.removeFromList(name, "blacklist");
            Utils.infoFormat("\u00a7aSuccessfully removed {} from the party commands blacklist.", name);
        }
        return 1;
    })))).then(ClientCommandManager.literal((String)"get").executes(context -> {
        if (PartyCommands.isListEmpty("blacklist")) {
            Utils.info("\u00a77Your party blacklist is currently empty.");
        } else {
            StringBuilder players = new StringBuilder();
            for (JsonElement player : PartyCommands.lists.value().get("blacklist").getAsJsonArray()) {
                players.append(player.getAsString()).append(" ");
            }
            Utils.infoFormat("\u00a7aList of all blacklisted players: \u00a77{}", players.toString().trim().replaceAll(" ", ", "));
        }
        return 1;
    }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
        if (PartyCommands.isListEmpty("blacklist")) {
            Utils.info("\u00a77Your party blacklist is currently empty.");
        } else {
            PartyCommands.lists.value().add("blacklist", (JsonElement)new JsonArray());
            Utils.info("\u00a7aSuccessfully cleared the party commands blacklist.");
        }
        return 1;
    }))))), new ModCommand("checkUpdate", "Manually checks if a new release version of the mod is available.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"checkUpdate").executes(context -> {
        Utils.info("\u00a77Checking for updates...");
        Utils.checkUpdate(true);
        return 1;
    }))), new ModCommand("sendCoords", "Easily send your coordinates in the chat, with the option to choose the format. Uses Patcher format by default.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sendCoords").executes(context -> {
        Utils.sendMessage(Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
        return 1;
    })).then(ClientCommandManager.literal((String)"patcher").executes(context -> {
        Utils.sendMessage(Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
        return 1;
    }))).then(ClientCommandManager.literal((String)"simple").executes(context -> {
        Utils.sendMessage(Utils.getCoordsFormatted("{} {} {}"));
        return 1;
    }))).then(ClientCommandManager.literal((String)"location").executes(context -> {
        Utils.sendMessage(Utils.format("{} [ {} ]", Utils.getCoordsFormatted("x: {}, y: {}, z: {}"), SkyblockData.getLocation()));
        return 1;
    })))), new ModCommand("copyCoords", "Alternative to the sendCoords command, which copies your coordinates to your clipboard instead of sending them in the chat.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copyCoords").executes(context -> {
        Main.mc.field_1774.method_1455(Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
        return 1;
    })).then(ClientCommandManager.literal((String)"patcher").executes(context -> {
        Main.mc.field_1774.method_1455(Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
        return 1;
    }))).then(ClientCommandManager.literal((String)"simple").executes(context -> {
        Main.mc.field_1774.method_1455(Utils.getCoordsFormatted("{} {} {}"));
        return 1;
    }))).then(ClientCommandManager.literal((String)"location").executes(context -> {
        Main.mc.field_1774.method_1455(Utils.format("{} [ {} ]", Utils.getCoordsFormatted("x: {}, y: {}, z: {}"), SkyblockData.getLocation()));
        return 1;
    })))), new ModCommand("queue", "Command that lets you queue for any Dungeon floor/Kuudra tier.", queueCommandBuilder), new ModCommand("getPearls", "Refills your Ender Pearls (up to 16) directly from your sacks.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"getPearls").executes(context -> {
        PearlRefill.getPearls();
        return 1;
    }))), new ModCommand("ping", "Checks your current ping.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ping").executes(context -> {
        Utils.info("\u00a77Pinging...");
        SkyblockData.showPing();
        return 1;
    }))), new ModCommand("hudEditor", "Opens the NoFrills hud editor.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hudEditor").executes(context -> {
        Utils.setScreen((class_437)new HudEditorScreen());
        return 1;
    }))), new ModCommand("debug", "Random commands for logging, debugging, or testing.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"debug").executes(context -> 1)).then(ClientCommandManager.literal((String)"dumpHeadTextures").executes(context -> {
        List<class_1304> searchedSlots = List.of(class_1304.field_6169, class_1304.field_6173, class_1304.field_6171);
        for (class_1297 ent : Utils.getEntities()) {
            if (!(ent instanceof class_1309)) continue;
            class_1309 living = (class_1309)ent;
            for (class_1304 slot : searchedSlots) {
                class_1799 stack = living.method_6118(slot);
                GameProfile textures = Utils.getTextures(stack);
                if (textures == null || !(stack.method_7909() instanceof class_1809)) continue;
                class_243 pos = living.method_19538();
                Main.LOGGER.info(Utils.format("\n\tURL - {}\n\tSlot - {}\n\tEntity Name - {}\n\tHead Name - {}\n\tPosition - {} {} {}", Utils.getTextureUrl(textures), Utils.toUpper(slot.name()), living.method_5477().getString(), stack.method_7964().getString(), pos.method_10216(), pos.method_10214(), pos.method_10215()));
            }
        }
        Utils.info("Dumped head texture URL's to latest.log.");
        return 1;
    }))).then(ClientCommandManager.literal((String)"dumpPlayerTextures").executes(context -> {
        MinecraftSessionService service = Main.mc.method_1495();
        for (class_1297 ent : Utils.getEntities()) {
            class_1657 player;
            if (!(ent instanceof class_1657) || (player = (class_1657)ent).method_7334() == null) continue;
            MinecraftProfileTextures textures = service.getTextures(player.method_7334());
            class_243 pos = player.method_19538();
            if (textures.skin() == null) continue;
            Main.LOGGER.info(Utils.format("\n\tURL - {}\n\tEntity Name - {}\n\tPosition - {} {} {}", textures.skin().getUrl(), player.method_5477().getString(), pos.method_10216(), pos.method_10214(), pos.method_10215()));
        }
        Utils.info("Dumped player texture URL's to latest.log.");
        return 1;
    })))), new ModCommand("shardTracker", "Commands for managing the Shard Tracker feature.", (LiteralArgumentBuilder<FabricClientCommandSource>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shardTracker").executes(context -> {
        Utils.info("\u00a7f\u00a7lImporting shards\u00a77: Click \"Copy Tree\" on the SkyShards calculator, choose the NoFrills format in the pop-up, and click the Import Shard List button on the Shard Tracker settings screen.\n\n\u00a7f\u00a7lTracking shards\u00a77: Make sure to enable the Shard Tracker feature, and the Shard Tracker element in the NoFrills HUD editor. When enabled, the feature will track the obtained quantity of each shard that you are tracking.");
        return 1;
    })).then(ClientCommandManager.literal((String)"import").executes(context -> {
        ShardTracker.importTreeData();
        ShardTracker.refreshDisplay();
        return 1;
    }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
        ShardTracker.data.value().add("shards", (JsonElement)new JsonArray());
        ShardTracker.refreshDisplay();
        Utils.info("\u00a7aTracked shard list cleared successfully.");
        return 1;
    }))).then(ClientCommandManager.literal((String)"settings").executes(context -> {
        Utils.setScreen((class_437)ShardTracker.buildSettings());
        return 1;
    }))))};

    public static void init(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder helpArg = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"help").executes(context -> {
            Utils.info("\u00a77Printing command list...");
            for (ModCommand command : commands) {
                Utils.info("\u00a7l" + command.command + "\u00a7r\u00a77: " + command.description);
            }
            return 1;
        });
        for (SkyblockData.InstanceType instanceType : SkyblockData.instances) {
            queueCommandBuilder.then(ClientCommandManager.literal((String)instanceType.name).executes(context -> {
                Utils.sendMessage("/joininstance " + instanceType.type);
                return 1;
            }));
        }
        LiteralArgumentBuilder commandMain = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"nofrills").executes(context -> {
            Utils.setScreen((class_437)new ClickGui());
            return 1;
        });
        LiteralArgumentBuilder commandShort = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"nf").executes(context -> {
            Utils.setScreen((class_437)new ClickGui());
            return 1;
        });
        commandMain.then((ArgumentBuilder)helpArg);
        commandShort.then((ArgumentBuilder)helpArg);
        for (ModCommand command : commands) {
            commandMain.then(command.builder);
            commandShort.then(command.builder);
        }
        dispatcher.register(commandMain);
        dispatcher.register(commandShort);
    }

    public static class ModCommand {
        public String command;
        public String description;
        public LiteralArgumentBuilder<FabricClientCommandSource> builder;

        public ModCommand(String command, String description, LiteralArgumentBuilder<FabricClientCommandSource> builder) {
            this.command = command;
            this.description = description;
            this.builder = builder;
        }
    }
}

