/*
 * Decompiled with CFR 0.152.
 */
package nofrills.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import nofrills.Main;

public class Config {
    private static final Path folderPath = FabricLoader.getInstance().getConfigDir().resolve("NoFrills");
    private static final Path filePath = folderPath.resolve("Configuration.json");
    private static JsonObject data = new JsonObject();

    public static void load() {
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                data = JsonParser.parseString((String)Files.readString(filePath)).getAsJsonObject();
            }
            catch (IOException exception) {
                Main.LOGGER.error("Unable to load NoFrills config file!", (Throwable)exception);
            }
        } else {
            Config.save();
        }
    }

    public static void save() {
        try {
            if (!Files.exists(folderPath, new LinkOption[0])) {
                Files.createDirectory(folderPath, new FileAttribute[0]);
            }
            Files.writeString(filePath, (CharSequence)data.toString(), new OpenOption[0]);
        }
        catch (IOException exception) {
            Main.LOGGER.error("Unable to save NoFrills config file!", (Throwable)exception);
        }
    }

    public static void saveAsync() {
        new Thread(Config::save).start();
    }

    public static JsonObject get() {
        return data;
    }
}

