/*
 * Decompiled with CFR 0.152.
 */
package nofrills.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import nofrills.config.Config;
import nofrills.config.Feature;
import nofrills.misc.RenderColor;

public class SettingColor {
    private final String key;
    private final String parent;
    private final RenderColor defaultValue;
    private RenderColor color;

    public SettingColor(RenderColor defaultValue, String key, String parentKey) {
        this.defaultValue = defaultValue;
        this.color = defaultValue;
        this.key = key;
        this.parent = parentKey;
    }

    public SettingColor(RenderColor defaultValue, String key, Feature instance) {
        this(defaultValue, key, instance.key());
    }

    public RenderColor value() {
        JsonObject data;
        if (Config.get().has(this.parent) && (data = Config.get().getAsJsonObject(this.parent)).has(this.key)) {
            RenderColor newColor;
            int color = data.get(this.key).getAsInt();
            if (this.color.argb == color) {
                return this.color;
            }
            this.color = newColor = RenderColor.fromArgb(color);
            return newColor;
        }
        return this.defaultValue;
    }

    public void set(RenderColor value) {
        if (!Config.get().has(this.parent)) {
            Config.get().add(this.parent, (JsonElement)new JsonObject());
        }
        Config.get().get(this.parent).getAsJsonObject().addProperty(this.key, (Number)value.argb);
    }

    public void reset() {
        this.set(this.defaultValue);
    }
}

