/*
 * Decompiled with CFR 0.152.
 */
package nofrills.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import nofrills.config.Config;
import nofrills.config.Feature;

public class SettingEnum<T extends Enum<T>> {
    public final T[] values;
    private final String key;
    private final String parent;
    private final T defaultValue;

    public SettingEnum(T defaultValue, Class<T> values, String key, String parentKey) {
        this.defaultValue = defaultValue;
        this.values = (Enum[])values.getEnumConstants();
        this.key = key;
        this.parent = parentKey;
    }

    public SettingEnum(T defaultValue, Class<T> values, String key, Feature instance) {
        this(defaultValue, values, key, instance.key());
    }

    public T value() {
        JsonObject data;
        if (Config.get().has(this.parent) && (data = Config.get().getAsJsonObject(this.parent)).has(this.key)) {
            String value = data.get(this.key).getAsString();
            for (T constant : this.values) {
                if (!((Enum)constant).name().equals(value)) continue;
                return constant;
            }
        }
        return this.defaultValue;
    }

    public void set(T value) {
        if (!Config.get().has(this.parent)) {
            Config.get().add(this.parent, (JsonElement)new JsonObject());
        }
        Config.get().get(this.parent).getAsJsonObject().addProperty(this.key, String.valueOf(value));
    }

    public void reset() {
        this.set(this.defaultValue);
    }
}

