/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.dungeons;

import java.util.ArrayList;
import java.util.Comparator;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_640;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.config.SettingString;
import nofrills.events.SlotUpdateEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.ScreenOptions;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class LeapOverlay {
    public static final Feature instance = new Feature("leapOverlay");
    public static final SettingBool send = new SettingBool(false, "send", instance.key());
    public static final SettingString message = new SettingString("/pc Leaped to {name}!", "message", instance.key());
    public static final SettingColor healer = new SettingColor(RenderColor.fromHex(15512844), "healerColor", instance.key());
    public static final SettingColor mage = new SettingColor(RenderColor.fromHex(1545156), "mageColor", instance.key());
    public static final SettingColor bers = new SettingColor(RenderColor.fromHex(15155516), "bersColor", instance.key());
    public static final SettingColor arch = new SettingColor(RenderColor.fromHex(4854967), "archColor", instance.key());
    public static final SettingColor tank = new SettingColor(RenderColor.fromHex(7769926), "tankColor", instance.key());
    public static final String leapMenuName = "Spirit Leap";
    public static final RenderColor nameColor = RenderColor.fromHex(0xFFFFFF);
    private static final RenderColor deadColor = RenderColor.fromHex(0xAAAAAA);

    private static RenderColor getColor(String className) {
        return switch (className) {
            case "Healer" -> healer.value();
            case "Mage" -> mage.value();
            case "Berserk" -> bers.value();
            case "Archer" -> arch.value();
            case "Tank" -> tank.value();
            case "DEAD" -> deadColor;
            default -> nameColor;
        };
    }

    @EventHandler
    private static void onSlotUpdate(SlotUpdateEvent event) {
        if (instance.isActive() && event.isFinal && event.title.equals(leapMenuName) && Utils.isInDungeons()) {
            ArrayList<LeapTarget> validTargets = new ArrayList<LeapTarget>();
            ArrayList<LeapTarget> deadTargets = new ArrayList<LeapTarget>();
            for (class_1735 slot : event.handler.field_7761) {
                class_9290 lore;
                class_1799 stack = event.inventory.method_5438(slot.field_7874);
                if (stack.method_7960() || !stack.method_7909().equals(class_1802.field_8575) || (lore = (class_9290)stack.method_57353().method_58694(class_9334.field_49632)) == null) continue;
                String line = Utils.toPlainString((class_2561)lore.comp_2400().getFirst());
                String name = Utils.toPlainString(stack.method_7964());
                if (name.equals("Unknown Player") || line.equals("This player is offline!")) continue;
                if (line.equals("This player is currently dead!")) {
                    deadTargets.add(new LeapTarget(-1, name, "", false, true));
                    continue;
                }
                if (!line.equals("Click to teleport!")) continue;
                block1: for (class_640 entry : Main.mc.method_1562().method_2880()) {
                    String entryName;
                    class_2561 displayName = entry.method_2971();
                    if (displayName == null || !(entryName = Utils.toPlainString(displayName)).contains(name)) continue;
                    for (String dungeonClass : SkyblockData.dungeonClasses) {
                        if (!entryName.contains("(" + dungeonClass) || !entryName.endsWith(")")) continue;
                        int classStart = entryName.indexOf("(");
                        int classEnd = Math.min(entryName.indexOf(" ", classStart), entryName.indexOf(")", classStart));
                        validTargets.add(new LeapTarget(slot.field_7874, name, entryName.substring(classStart + 1, classEnd), false, false));
                        continue block1;
                    }
                }
            }
            validTargets.sort(Comparator.comparing(target -> target.dungeonClass + target.name));
            deadTargets.sort(Comparator.comparing(target -> target.name));
            ArrayList<LeapTarget> targets = new ArrayList<LeapTarget>();
            targets.addAll(validTargets);
            targets.addAll(deadTargets);
            if (targets.size() < 4) {
                int missing = 4 - targets.size();
                for (int i = 1; i <= missing; ++i) {
                    targets.add(new LeapTarget(-1, "", "", true, false));
                }
            }
            for (LeapTarget target2 : targets) {
                String name = target2.empty ? "Empty" : target2.name;
                String dungeonClass = target2.dead ? "DEAD" : target2.dungeonClass;
                ((ScreenOptions)event.screen).nofrills_mod$addLeapButton(target2.slotId, name, dungeonClass, LeapOverlay.getColor(dungeonClass));
            }
        }
    }

    private static class LeapTarget {
        public int slotId;
        public String name;
        public String dungeonClass;
        public boolean empty;
        public boolean dead;

        public LeapTarget(int slotId, String name, String dungeonClass, boolean empty, boolean dead) {
            this.slotId = slotId;
            this.name = name;
            this.dungeonClass = dungeonClass;
            this.empty = empty;
            this.dead = dead;
        }
    }
}

