/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.dungeons;

import java.util.HashMap;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import nofrills.config.Feature;
import nofrills.config.SettingColor;
import nofrills.events.BlockUpdateEvent;
import nofrills.events.EntityUpdatedEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.misc.EntityCache;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;

public class LividSolver {
    public static final Feature instance = new Feature("lividSolver");
    public static final SettingColor color = new SettingColor(RenderColor.fromArgb(-16711936), "color", instance.key());
    private static final HashMap<class_2248, Livid> lividData = LividSolver.buildLividData();
    private static final EntityCache lividCache = new EntityCache();
    private static String currentName = "";

    private static HashMap<class_2248, Livid> buildLividData() {
        HashMap<class_2248, Livid> map = new HashMap<class_2248, Livid>();
        List<Livid> list = List.of(new Livid("Hockey Livid", "\u00a7c\u00a7lRED", class_2246.field_10314, class_2246.field_10272), new Livid("Arcade Livid", "\u00a7e\u00a7lYELLOW", class_2246.field_10490, class_2246.field_10049), new Livid("Smile Livid", "\u00a7a\u00a7lGREEN", class_2246.field_10028, class_2246.field_10157), new Livid("Frog Livid", "\u00a72\u00a7lDARK GREEN", class_2246.field_10170, class_2246.field_10357), new Livid("Scream Livid", "\u00a79\u00a7lBLUE", class_2246.field_10514, class_2246.field_10060), new Livid("Crossed Livid", "\u00a7d\u00a7lPINK", class_2246.field_10215, class_2246.field_10574), new Livid("Purple Livid", "\u00a75\u00a7lPURPLE", class_2246.field_10259, class_2246.field_10399), new Livid("Doctor Livid", "\u00a77\u00a7lGRAY", class_2246.field_10423, class_2246.field_10555), new Livid("Vendetta Livid", "\u00a7f\u00a7lWHITE", class_2246.field_10446, class_2246.field_10087));
        for (Livid livid : list) {
            map.put(livid.wool, livid);
            map.put(livid.glass, livid);
        }
        return map;
    }

    @EventHandler
    private static void onBlock(BlockUpdateEvent event) {
        if (instance.isActive() && Utils.isInDungeonBoss("5") && event.pos.method_10264() >= 107 && event.pos.method_10264() <= 110 && lividData.containsKey(event.newState.method_26204())) {
            Livid livid = lividData.get(event.newState.method_26204());
            if (!currentName.equals(livid.name)) {
                Utils.showTitle(livid.title + "!", "", 0, 50, 10);
                Utils.playSound(class_3417.field_14627, class_3419.field_15250, 1.0f, 0.0f);
                currentName = livid.name;
            }
        }
    }

    @EventHandler
    private static void onEntity(EntityUpdatedEvent event) {
        class_1657 player;
        class_1297 class_12972;
        if (instance.isActive() && Utils.isInDungeonBoss("5") && (class_12972 = event.entity) instanceof class_1657 && !Utils.isPlayer(player = (class_1657)class_12972)) {
            String name = Utils.toPlainString(player.method_5477());
            if (!lividCache.has(event.entity) && lividData.values().stream().anyMatch(livid -> livid.name.equals(name))) {
                lividCache.add((class_1297)player);
            }
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        List<class_1297> livids;
        if (instance.isActive() && Utils.isInDungeonBoss("5") && (livids = lividCache.get()).size() > 1) {
            for (class_1297 livid : livids) {
                if (!Utils.toPlainString(livid.method_5477()).equals(currentName)) continue;
                event.drawOutline(Utils.getLerpedBox(livid, event.tickCounter.method_60637(true)), false, color.value());
                break;
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        currentName = "";
        lividCache.clear();
    }

    private static class Livid {
        public String name;
        public String title;
        public class_2248 wool;
        public class_2248 glass;

        public Livid(String name, String title, class_2248 wool, class_2248 glass) {
            this.name = name;
            this.title = title;
            this.wool = wool;
            this.glass = glass;
        }
    }
}

