/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.dungeons;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingString;
import nofrills.events.ScreenOpenEvent;
import nofrills.events.SlotClickEvent;
import nofrills.events.SlotUpdateEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.SlotOptions;
import nofrills.misc.Utils;

public class TerminalSolvers {
    public static final Feature instance = new Feature("terminalSolvers");
    public static final SettingBool panes = new SettingBool(false, "panes", instance.key());
    public static final SettingBool startsWith = new SettingBool(false, "startsWith", instance.key());
    public static final SettingBool select = new SettingBool(false, "select", instance.key());
    public static final SettingBool inOrder = new SettingBool(false, "inOrder", instance.key());
    public static final SettingBool colors = new SettingBool(false, "colors", instance.key());
    public static final SettingBool instant = new SettingBool(false, "instant", instance.key());
    public static final SettingBool melody = new SettingBool(false, "melody", instance.key());
    public static final SettingString melodyMsg = new SettingString("/pc MELODY", "melodyMsg", instance.key());
    private static final List<class_1792> colorsOrder = List.of(class_1802.field_8656, class_1802.field_8703, class_1802.field_8761, class_1802.field_8879, class_1802.field_8747);
    private static int melodyTicks = 0;

    public static TerminalType getTerminalType(String title) {
        if (title.startsWith("Correct all the panes!")) {
            return TerminalType.Panes;
        }
        if (title.startsWith("Click in order!")) {
            return TerminalType.InOrder;
        }
        if (title.startsWith("What starts with:") && title.endsWith("?")) {
            return TerminalType.StartsWith;
        }
        if (title.startsWith("Select all the") && title.endsWith("items!")) {
            return TerminalType.Select;
        }
        if (title.startsWith("Change all to same color!")) {
            return TerminalType.Colors;
        }
        if (title.equals("Click the button on time!")) {
            return TerminalType.Melody;
        }
        return TerminalType.None;
    }

    public static boolean isInTerminal(String title) {
        return !TerminalSolvers.getTerminalType(title).equals((Object)TerminalType.None);
    }

    public static boolean shouldHideTooltips(String title) {
        return instance.isActive() && TerminalSolvers.isInTerminal(title);
    }

    private static boolean checkStackColor(class_1799 stack, class_1767 color, String colorName) {
        class_1792 item = stack.method_7909();
        if (Utils.toPlainString(stack.method_7964()).trim().isEmpty()) {
            return false;
        }
        if (stack.method_7909().toString().startsWith("minecraft:" + colorName)) {
            return true;
        }
        return switch (color) {
            case class_1767.field_7963 -> item.equals(class_1802.field_8794);
            case class_1767.field_7966 -> item.equals(class_1802.field_8759);
            case class_1767.field_7957 -> item.equals(class_1802.field_8116);
            case class_1767.field_7952 -> item.equals(class_1802.field_8324);
            default -> false;
        };
    }

    private static class_1799 stackWithCount(int count) {
        return SlotOptions.stackWithQuantity(count > 0 ? SlotOptions.first : SlotOptions.second, Math.abs(count));
    }

    @EventHandler
    private static void onScreenOpen(ScreenOpenEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("7") && melody.value() && TerminalSolvers.getTerminalType(event.screen.method_25440().getString()).equals((Object)TerminalType.Melody)) {
            if (melodyTicks == 0 && !melodyMsg.value().isEmpty()) {
                Utils.sendMessage(melodyMsg.value());
            }
            melodyTicks = 60;
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (melodyTicks > 0) {
            --melodyTicks;
        }
    }

    @EventHandler
    private static void onSlotUpdate(SlotUpdateEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("7")) {
            TerminalType type2 = TerminalSolvers.getTerminalType(event.title);
            if (event.isInventory || event.slot == null || type2.equals((Object)TerminalType.None)) {
                return;
            }
            if (type2.equals((Object)TerminalType.Panes) && panes.value()) {
                if (event.stack.method_7909().equals(class_1802.field_8879)) {
                    SlotOptions.spoofSlot(event.slot, SlotOptions.first);
                    SlotOptions.disableSlot(event.slot, false);
                } else {
                    SlotOptions.spoofSlot(event.slot, SlotOptions.background);
                    SlotOptions.disableSlot(event.slot, true);
                }
            }
            if (type2.equals((Object)TerminalType.StartsWith) && startsWith.value()) {
                String character = Utils.toLower(String.valueOf(event.title.charAt(event.title.indexOf("'") + 1)));
                String name = Utils.toLower(Utils.toPlainString(event.stack.method_7964())).trim();
                if (!name.isEmpty() && name.startsWith(character) && !Utils.hasGlint(event.stack)) {
                    SlotOptions.spoofSlot(event.slot, SlotOptions.first);
                    SlotOptions.disableSlot(event.slot, false);
                } else {
                    SlotOptions.spoofSlot(event.slot, SlotOptions.background);
                    SlotOptions.disableSlot(event.slot, true);
                }
            }
            if (type2.equals((Object)TerminalType.Select) && select.value()) {
                String color = event.title.replace("Select all the", "").replace("items!", "").trim();
                String colorName = color.equals("SILVER") ? "light_gray" : Utils.toLower(color).replace(" ", "_");
                for (class_1767 class_17672 : class_1767.values()) {
                    if (!class_17672.method_7792().equals(colorName)) continue;
                    if (!Utils.hasGlint(event.stack) && TerminalSolvers.checkStackColor(event.stack, class_17672, colorName)) {
                        SlotOptions.spoofSlot(event.slot, SlotOptions.first);
                        SlotOptions.disableSlot(event.slot, false);
                        break;
                    }
                    SlotOptions.spoofSlot(event.slot, SlotOptions.background);
                    SlotOptions.disableSlot(event.slot, true);
                    break;
                }
            }
            if (type2.equals((Object)TerminalType.InOrder) && inOrder.value()) {
                ArrayList<class_1735> orderSlots = new ArrayList<class_1735>();
                for (class_1735 slot2 : event.handler.field_7761) {
                    class_1799 class_17992 = event.inventory.method_5438(slot2.field_7874);
                    if (class_17992.method_7960()) continue;
                    class_1792 item = class_17992.method_7909();
                    SlotOptions.spoofSlot(event.slot, SlotOptions.background);
                    SlotOptions.disableSlot(event.slot, true);
                    if (!item.equals(class_1802.field_8879) && !item.equals(class_1802.field_8581)) continue;
                    orderSlots.add(slot2);
                }
                if (orderSlots.size() == 14) {
                    orderSlots.removeIf(slot -> slot.method_7677().method_7909().equals(class_1802.field_8581));
                    if (orderSlots.isEmpty()) {
                        return;
                    }
                    orderSlots.sort(Comparator.comparingInt(slot -> slot.method_7677().method_7947()));
                    Iterator first = (class_1735)orderSlots.getFirst();
                    SlotOptions.spoofSlot((class_1735)first, SlotOptions.stackWithQuantity(SlotOptions.first, first.method_7677().method_7947()));
                    SlotOptions.disableSlot((class_1735)first, false);
                    if (orderSlots.size() > 1) {
                        class_1735 second = (class_1735)orderSlots.get(1);
                        SlotOptions.spoofSlot(second, SlotOptions.stackWithQuantity(SlotOptions.second, second.method_7677().method_7947()));
                        SlotOptions.disableSlot(second, true);
                    }
                    if (orderSlots.size() > 2) {
                        class_1735 third = (class_1735)orderSlots.get(2);
                        SlotOptions.spoofSlot(third, SlotOptions.stackWithQuantity(SlotOptions.third, third.method_7677().method_7947()));
                        SlotOptions.disableSlot(third, true);
                    }
                }
            }
            if (type2.equals((Object)TerminalType.Colors) && colors.value()) {
                ArrayList<Object> colorSlots = new ArrayList<Object>();
                for (Object slot2 : event.handler.field_7761) {
                    class_1799 class_17993 = event.inventory.method_5438(((class_1735)slot2).field_7874);
                    if (class_17993.method_7960()) continue;
                    SlotOptions.spoofSlot(event.slot, SlotOptions.background);
                    SlotOptions.disableSlot(event.slot, true);
                    if (!colorsOrder.contains(class_17993.method_7909()) || colorSlots.contains(slot2)) continue;
                    colorSlots.add(slot2);
                }
                if (colorSlots.size() == 9) {
                    int[] colorCounts = new int[]{0, 0, 0, 0, 0};
                    for (class_1735 class_17352 : colorSlots) {
                        int index;
                        int n = index = colorsOrder.indexOf(class_17352.method_7677().method_7909());
                        colorCounts[n] = colorCounts[n] + 1;
                    }
                    int mostCommon = -1;
                    boolean bl = false;
                    for (int i = 0; i < 5; ++i) {
                        int n;
                        if (colorCounts[i] <= n) continue;
                        n = colorCounts[i];
                        mostCommon = i;
                    }
                    for (class_1735 class_17353 : colorSlots) {
                        int index = colorsOrder.indexOf(class_17353.method_7677().method_7909());
                        int target = Math.negateExact(mostCommon - index);
                        if (Math.abs(target) > 2) {
                            int offset = Math.abs(target) == 4 ? 3 : 1;
                            target = Math.negateExact(target) + (target > 0 ? offset : -offset);
                        }
                        if (target == 0) {
                            SlotOptions.spoofSlot(class_17353, SlotOptions.background);
                            SlotOptions.disableSlot(class_17353, true);
                            continue;
                        }
                        SlotOptions.spoofSlot(class_17353, TerminalSolvers.stackWithCount(target));
                        SlotOptions.disableSlot(class_17353, false);
                    }
                }
            }
        }
    }

    @EventHandler
    private static void onSlotClick(SlotClickEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("7") && event.slot != null && instant.value()) {
            TerminalType type2 = TerminalSolvers.getTerminalType(event.title);
            if (type2.equals((Object)TerminalType.None) || type2.equals((Object)TerminalType.Melody) || type2.equals((Object)TerminalType.Colors)) {
                return;
            }
            SlotOptions.spoofSlot(event.slot, SlotOptions.background);
            SlotOptions.disableSlot(event.slot, true);
        }
    }

    public static enum TerminalType {
        Panes,
        InOrder,
        StartsWith,
        Select,
        Colors,
        Melody,
        None;

    }
}

