/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.dungeons;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2561;
import nofrills.config.Feature;
import nofrills.events.BlockUpdateEvent;
import nofrills.events.ChatMsgEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class TerracottaTimer {
    public static final Feature instance = new Feature("terracottaTimer");
    private static final List<SpawningTerracotta> terracottas = new ArrayList<SpawningTerracotta>();
    private static final class_2338 sadanPit = new class_2338(-9, 67, 66);
    private static int gyroTicks = 0;

    @EventHandler
    private static void onChat(ChatMsgEvent event) {
        if (instance.isActive()) {
            if (event.messagePlain.equals("[BOSS] Sadan: So you made it all the way here... Now you wish to defy me? Sadan?!")) {
                gyroTicks = 267;
            }
            if (event.messagePlain.equals("[BOSS] Sadan: ENOUGH!")) {
                terracottas.clear();
            }
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("6") && gyroTicks > 0) {
            Utils.showTitleCustom("GYRO: " + Utils.formatDecimal((float)gyroTicks / 20.0f) + "s", 1, 25, 2.5f, 0xFFFF00);
        }
    }

    @EventHandler
    private static void onBlockUpdate(BlockUpdateEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("6") && SkyblockData.getLines().stream().anyMatch(line -> line.endsWith("sadan"))) {
            if (event.newState.method_26204() instanceof class_2362 && terracottas.stream().noneMatch(terra -> terra.pos.equals((Object)event.pos))) {
                terracottas.add(new SpawningTerracotta(event.pos, Utils.isOnDungeonFloor("M6") ? 240 : 300));
            }
            if (event.pos.equals((Object)sadanPit) && event.newState.method_26215() && event.oldState.method_26204().equals(class_2246.field_10555)) {
                gyroTicks = 195;
            }
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && !terracottas.isEmpty()) {
            ArrayList<SpawningTerracotta> terras = new ArrayList<SpawningTerracotta>(terracottas);
            for (SpawningTerracotta terra : terras) {
                if (terra.pos == null) continue;
                event.drawText(terra.pos.method_46558(), class_2561.method_30163((String)(Utils.formatDecimal((float)terra.ticks / 20.0f) + "s")), 0.035f, true, RenderColor.fromHex(0xFFFF00));
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        gyroTicks = 0;
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && Utils.isOnDungeonFloor("6")) {
            if (gyroTicks > 0) {
                --gyroTicks;
            }
            ArrayList<SpawningTerracotta> terras = new ArrayList<SpawningTerracotta>(terracottas);
            for (SpawningTerracotta terra2 : terras) {
                --terra2.ticks;
            }
            terracottas.removeIf(terra -> terra.ticks <= 0);
        }
    }

    private static class SpawningTerracotta {
        public class_2338 pos;
        public int ticks;

        public SpawningTerracotta(class_2338 pos, int ticks) {
            this.pos = pos;
            this.ticks = ticks;
        }
    }
}

