/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.dungeons;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2675;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.events.EntityUpdatedEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.SpawnParticleEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.Rendering;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class WitherDragons {
    public static final Feature instance = new Feature("witherDragons");
    public static final SettingBool alert = new SettingBool(false, "alert", instance.key());
    public static final SettingDouble power = new SettingDouble(0.0, "power", instance.key());
    public static final SettingDouble powerEasy = new SettingDouble(0.0, "powerEasy", instance.key());
    public static final SettingBool glow = new SettingBool(false, "glow", instance.key());
    public static final SettingBool boxes = new SettingBool(false, "boxes", instance.key());
    public static final SettingBool tracers = new SettingBool(false, "tracers", instance.key());
    public static final SettingBool stack = new SettingBool(false, "stack", instance.key());
    public static final SettingEnum<stackTypes> stackType = new SettingEnum<stackTypes>(stackTypes.Simple, stackTypes.class, "stackType", instance.key());
    public static final SettingBool timer = new SettingBool(false, "timer", instance.key());
    public static final SettingBool health = new SettingBool(false, "health", instance.key());
    private static final List<Dragon> dragons = List.of(new Dragon("Red", 3, 3, RenderColor.fromHex(0xFF0000), SpawnBoxes.red, PartBoxes.red, new class_238(14.5, 5.0, 45.5, 39.5, 28.0, 70.5)), new Dragon("Orange", 1, 5, RenderColor.fromHex(0xFFAA00), SpawnBoxes.orange, PartBoxes.orange, new class_238(72.0, 5.0, 47.0, 102.0, 28.0, 77.0)), new Dragon("Blue", 4, 2, RenderColor.fromHex(0x55FFFF), SpawnBoxes.blue, PartBoxes.blue, new class_238(71.5, 5.0, 82.5, 96.5, 26.0, 107.5)), new Dragon("Purple", 5, 1, RenderColor.fromHex(0xAA00AA), SpawnBoxes.purple, PartBoxes.purple, new class_238(45.5, 6.0, 113.5, 68.5, 23.0, 136.5)), new Dragon("Green", 2, 4, RenderColor.fromHex(65280), SpawnBoxes.green, PartBoxes.green, new class_238(7.0, 5.0, 80.0, 37.0, 28.0, 110.0)));
    private static final List<SpawnedDragon> spawnedDragons = new ArrayList<SpawnedDragon>();
    private static boolean dragonSplitDone = false;

    private static boolean isDragonPhase() {
        return Main.mc.field_1724 != null && Main.mc.field_1724.method_19538().method_10214() < 50.0 && Utils.isInDungeonBoss("7");
    }

    private static boolean isArcherTeam() {
        return switch (SkyblockData.dungeonClass.value()) {
            case "Archer", "Tank" -> true;
            default -> false;
        };
    }

    private static double getPowerLevel() {
        return SkyblockData.dungeonPower;
    }

    private static List<SpawnedDragon> getSpawnedDragons() {
        return new ArrayList<SpawnedDragon>(spawnedDragons);
    }

    private static boolean isDragonParticle(class_2675 packet) {
        return packet.method_11551().method_10295().equals(class_2398.field_11240) && packet.method_11545() == 20 && packet.method_11547() == 19.0 && packet.method_11548() == 2.0f && packet.method_11549() == 3.0f && packet.method_11550() == 2.0f && packet.method_11543() == 0.0f && packet.method_11544() % 1.0 == 0.0 && packet.method_11546() % 1.0 == 0.0;
    }

    private static boolean isDragonSpawned(Dragon dragon) {
        for (SpawnedDragon drag : WitherDragons.getSpawnedDragons()) {
            if (!dragon.name.equals(drag.data.name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPurpleInArea(Dragon dragon) {
        for (SpawnedDragon drag : WitherDragons.getSpawnedDragons()) {
            class_238 box;
            if (!drag.data.name.equals("Purple") || drag.entity == null || !dragon.area.method_994(box = drag.entity.method_18377(class_4050.field_18076).method_30757(drag.entity.method_19538()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEitherPurple(SpawnedDragon first, SpawnedDragon second) {
        return first.data.name.equals("Purple") || second.data.name.equals("Purple");
    }

    private static boolean doesDragonExist(class_1297 dragon) {
        for (SpawnedDragon drag : WitherDragons.getSpawnedDragons()) {
            if (drag.entity == null || !drag.uuid.equals(dragon.method_5845())) continue;
            return true;
        }
        return false;
    }

    private static SpawnedDragon getHigherPriority(SpawnedDragon first, SpawnedDragon second, boolean archerTeam) {
        if (archerTeam) {
            return first.data.archPriority > second.data.archPriority ? first : second;
        }
        return first.data.bersPriority > second.data.bersPriority ? first : second;
    }

    private static void announceDragonSpawn(SpawnedDragon drag, boolean split) {
        Utils.showTitleCustom(Utils.toUpper(drag.data.name) + " IS SPAWNING!", 60, -20, 4.0f, drag.data.color.hex);
        Utils.playSound(class_3417.field_14627, class_3419.field_15250, 1.0f, 0.0f);
        if (split) {
            Utils.infoRaw(class_2561.method_43470((String)(drag.data.name + " is your priority dragon.")).method_10862(class_2583.field_24360.method_36139(drag.data.color.hex)));
        } else if (dragonSplitDone) {
            Utils.infoRaw(class_2561.method_43470((String)(drag.data.name + " is spawning.")).method_10862(class_2583.field_24360.method_36139(drag.data.color.hex)));
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && !spawnedDragons.isEmpty()) {
            List<SpawnedDragon> spawnedDrags = WitherDragons.getSpawnedDragons();
            for (SpawnedDragon drag : spawnedDrags) {
                if (boxes.value()) {
                    event.drawOutline(drag.data.area, true, drag.data.color);
                }
                if (stack.value() && !drag.spawned) {
                    if (stackType.value().equals((Object)stackTypes.Advanced)) {
                        for (class_238 part : drag.data.parts) {
                            event.drawOutline(part, true, drag.data.color);
                        }
                    } else {
                        event.drawFilled(drag.data.pos, true, RenderColor.fromHex(drag.data.color.hex, 0.67f));
                    }
                }
                if (timer.value() && !drag.spawned) {
                    event.drawText(drag.data.pos.method_1005().method_1031(0.0, 4.0, 0.0), class_2561.method_30163((String)(Utils.formatDecimal((float)drag.spawnTicks / 20.0f, 3) + "s")), 0.3f, true, drag.data.color);
                }
                if (!health.value() || drag.entity == null) continue;
                class_243 pos = drag.entity.method_30950(event.tickCounter.method_60637(true));
                event.drawText(pos, class_2561.method_30163((String)(Utils.formatDecimal((double)drag.health * 1.0E-6) + "M")), 0.2f, true, drag.data.color);
            }
            if (tracers.value()) {
                SpawnedDragon drag;
                SpawnedDragon spawnedDragon = drag = spawnedDrags.size() == 2 ? WitherDragons.getHigherPriority(spawnedDrags.getFirst(), spawnedDrags.get(1), WitherDragons.isArcherTeam()) : spawnedDrags.getFirst();
                if (!drag.spawned) {
                    event.drawTracer(drag.data.pos.method_1005(), drag.data.color);
                }
            }
        }
    }

    @EventHandler
    private static void onParticle(SpawnParticleEvent event) {
        if (instance.isActive() && WitherDragons.isDragonParticle(event.packet) && WitherDragons.isDragonPhase()) {
            for (Dragon drag : dragons) {
                if (WitherDragons.isDragonSpawned(drag) || !drag.area.method_1006(event.pos) || WitherDragons.isPurpleInArea(drag)) continue;
                SpawnedDragon spawnedDragon = new SpawnedDragon(drag);
                spawnedDragons.add(spawnedDragon);
                List<SpawnedDragon> dragons = WitherDragons.getSpawnedDragons();
                if (!dragonSplitDone && dragons.size() == 2) {
                    if (!alert.value()) continue;
                    double currentPower = WitherDragons.getPowerLevel();
                    SpawnedDragon first = dragons.getFirst();
                    SpawnedDragon second = dragons.getLast();
                    if (currentPower >= powerEasy.value() && WitherDragons.isEitherPurple(first, second) || currentPower >= power.value()) {
                        WitherDragons.announceDragonSpawn(WitherDragons.getHigherPriority(first, second, WitherDragons.isArcherTeam()), true);
                    } else {
                        WitherDragons.announceDragonSpawn(WitherDragons.getHigherPriority(first, second, true), true);
                    }
                    dragonSplitDone = true;
                    continue;
                }
                if (!dragonSplitDone || !alert.value()) continue;
                WitherDragons.announceDragonSpawn(spawnedDragon, false);
            }
        }
    }

    @EventHandler
    private static void onEntity(EntityUpdatedEvent event) {
        class_1297 class_12972;
        if (instance.isActive() && (class_12972 = event.entity) instanceof class_1510) {
            class_1510 dragonEntity = (class_1510)class_12972;
            if (WitherDragons.isDragonPhase()) {
                float health = dragonEntity.method_6032();
                String uuid = dragonEntity.method_5845();
                for (SpawnedDragon drag : WitherDragons.getSpawnedDragons()) {
                    if (drag.spawning && !WitherDragons.doesDragonExist(event.entity) && drag.data.area.method_1006(event.entity.method_19538())) {
                        drag.entity = event.entity;
                        drag.uuid = uuid;
                        drag.health = health;
                        drag.spawning = false;
                        drag.spawned = true;
                        if (!glow.value()) continue;
                        Rendering.Entities.drawGlow(event.entity, true, drag.data.color);
                        continue;
                    }
                    if (!drag.spawned || !uuid.equals(drag.uuid)) continue;
                    if (dragonEntity.method_5805() && dragonEntity.field_7031 == 0) {
                        drag.health = health;
                        drag.entity = event.entity;
                        if (!glow.value()) continue;
                        Rendering.Entities.drawGlow(event.entity, true, drag.data.color);
                        continue;
                    }
                    spawnedDragons.removeIf(dragon -> dragon.data.name.equals(drag.data.name));
                }
            }
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && WitherDragons.isDragonPhase()) {
            for (SpawnedDragon drag : WitherDragons.getSpawnedDragons()) {
                if (drag.spawned || drag.spawnTicks <= 0) continue;
                --drag.spawnTicks;
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        dragonSplitDone = false;
        spawnedDragons.clear();
    }

    private static class SpawnedDragon {
        public Dragon data;
        public class_1297 entity = null;
        public String uuid = "";
        public int spawnTicks = 100;
        public boolean spawned = false;
        public boolean spawning = true;
        public float health = 0.0f;

        public SpawnedDragon(Dragon data) {
            this.data = data;
        }
    }

    private static class Dragon {
        public String name;
        public int archPriority;
        public int bersPriority;
        public RenderColor color;
        public class_238 pos;
        public List<class_238> parts;
        public class_238 area;

        public Dragon(String name, int archPriority, int bersPriority, RenderColor color, class_238 pos, List<class_238> parts, class_238 area) {
            this.name = name;
            this.archPriority = archPriority;
            this.bersPriority = bersPriority;
            this.color = color;
            this.pos = pos;
            this.parts = parts;
            this.area = area;
        }
    }

    public static enum stackTypes {
        Simple,
        Advanced;

    }

    private static class SpawnBoxes {
        public static class_238 red = class_238.method_30048((class_243)new class_243(27.0, 14.0, 59.0), (double)1.0, (double)1.0, (double)1.0);
        public static class_238 orange = class_238.method_30048((class_243)new class_243(85.0, 14.0, 56.0), (double)1.0, (double)1.0, (double)1.0);
        public static class_238 blue = class_238.method_30048((class_243)new class_243(84.0, 14.0, 94.0), (double)1.0, (double)1.0, (double)1.0);
        public static class_238 purple = class_238.method_30048((class_243)new class_243(56.0, 14.0, 125.0), (double)1.0, (double)1.0, (double)1.0);
        public static class_238 green = class_238.method_30048((class_243)new class_243(27.0, 14.0, 94.0), (double)1.0, (double)1.0, (double)1.0);

        private SpawnBoxes() {
        }
    }

    private static class PartBoxes {
        public static List<class_238> red = List.of(new class_238(26.5, 14.0, 52.0, 27.5, 15.0, 53.0), new class_238(25.5, 14.0, 52.0, 28.5, 17.0, 55.0), new class_238(24.5, 14.0, 56.0, 29.5, 17.0, 61.0), new class_238(26.0, 15.5, 61.5, 28.0, 17.5, 63.5), new class_238(26.0, 15.5, 63.5, 28.0, 17.5, 65.5), new class_238(26.0, 15.5, 65.5, 28.0, 17.5, 67.5), new class_238(29.5, 16.0, 57.0, 33.5, 18.0, 61.0), new class_238(20.5, 16.0, 57.0, 24.5, 18.0, 61.0));
        public static List<class_238> orange = List.of(new class_238(84.5, 14.0, 49.0, 85.5, 15.0, 50.0), new class_238(83.5, 14.0, 49.0, 86.5, 17.0, 52.0), new class_238(82.5, 14.0, 53.0, 87.5, 17.0, 58.0), new class_238(84.0, 15.5, 58.5, 86.0, 17.5, 60.5), new class_238(84.0, 15.5, 60.5, 86.0, 17.5, 62.5), new class_238(84.0, 15.5, 62.5, 86.0, 17.5, 64.5), new class_238(87.5, 16.0, 54.0, 91.5, 18.0, 58.0), new class_238(78.5, 16.0, 54.0, 82.5, 18.0, 58.0));
        public static List<class_238> blue = List.of(new class_238(83.5, 14.0, 87.0, 84.5, 15.0, 88.0), new class_238(82.5, 14.0, 87.0, 85.5, 17.0, 90.0), new class_238(81.5, 14.0, 91.0, 86.5, 17.0, 96.0), new class_238(83.0, 15.5, 96.5, 85.0, 17.5, 98.5), new class_238(83.0, 15.5, 98.5, 85.0, 17.5, 100.5), new class_238(83.0, 15.5, 100.5, 85.0, 17.5, 102.5), new class_238(86.5, 16.0, 92.0, 90.5, 18.0, 96.0), new class_238(77.5, 16.0, 92.0, 81.5, 18.0, 96.0));
        public static List<class_238> purple = List.of(new class_238(55.5, 14.0, 118.0, 56.5, 15.0, 119.0), new class_238(54.5, 14.0, 118.0, 57.5, 17.0, 121.0), new class_238(53.5, 14.0, 122.0, 58.5, 17.0, 127.0), new class_238(55.0, 15.5, 127.5, 57.0, 17.5, 129.5), new class_238(55.0, 15.5, 129.5, 57.0, 17.5, 131.5), new class_238(55.0, 15.5, 131.5, 57.0, 17.5, 133.5), new class_238(58.5, 16.0, 123.0, 62.5, 18.0, 127.0), new class_238(49.5, 16.0, 123.0, 53.5, 18.0, 127.0));
        public static List<class_238> green = List.of(new class_238(26.5, 14.0, 87.0, 27.5, 15.0, 88.0), new class_238(25.5, 14.0, 87.0, 28.5, 17.0, 90.0), new class_238(24.5, 14.0, 91.0, 29.5, 17.0, 96.0), new class_238(26.0, 15.5, 96.5, 28.0, 17.5, 98.5), new class_238(26.0, 15.5, 98.5, 28.0, 17.5, 100.5), new class_238(26.0, 15.5, 100.5, 28.0, 17.5, 102.5), new class_238(29.5, 16.0, 92.0, 33.5, 18.0, 96.0), new class_238(20.5, 16.0, 92.0, 24.5, 18.0, 96.0));

        private PartBoxes() {
        }
    }
}

