/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.farming;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.events.WorldRenderEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;

public class PlotBorders {
    public static final Feature instance = new Feature("plotBorders");
    public static final SettingBool infested = new SettingBool(false, "infested", instance.key());
    public static final SettingColor infestedColor = new SettingColor(RenderColor.fromArgb(-43691), "infestedColor", instance.key());
    public static final SettingBool current = new SettingBool(false, "current", instance.key());
    public static final SettingColor currentColor = new SettingColor(RenderColor.fromArgb(-11141291), "currentColor", instance.key());
    public static final SettingBool all = new SettingBool(false, "all", instance.key());
    public static final SettingColor allColor = new SettingColor(RenderColor.fromArgb(-1), "allColor", instance.key());
    private static final HashMap<String, Plot> plotData = PlotBorders.buildPlotList();
    private static HashSet<String> infestedPlots = new HashSet();

    private static HashMap<String, Plot> buildPlotList() {
        HashMap<String, Plot> map = new HashMap<String, Plot>();
        map.put("1", new Plot(0, -96));
        map.put("2", new Plot(-96, 0));
        map.put("3", new Plot(96, 0));
        map.put("4", new Plot(0, 96));
        map.put("5", new Plot(-96, -96));
        map.put("6", new Plot(96, -96));
        map.put("7", new Plot(-96, 96));
        map.put("8", new Plot(96, 96));
        map.put("9", new Plot(0, -192));
        map.put("10", new Plot(-192, 0));
        map.put("11", new Plot(192, 0));
        map.put("12", new Plot(0, 192));
        map.put("13", new Plot(-96, -192));
        map.put("14", new Plot(96, -192));
        map.put("15", new Plot(-192, -96));
        map.put("16", new Plot(192, -96));
        map.put("17", new Plot(-192, 96));
        map.put("18", new Plot(192, 96));
        map.put("19", new Plot(-96, 192));
        map.put("20", new Plot(96, 192));
        map.put("21", new Plot(-192, -192));
        map.put("22", new Plot(192, -192));
        map.put("23", new Plot(-192, 192));
        map.put("24", new Plot(192, 192));
        return map;
    }

    private static HashSet<String> getInfestedPlots() {
        for (String line : Utils.getTabListLines()) {
            if (!line.startsWith("Plots: ")) continue;
            String[] plots = line.substring(line.indexOf(":") + 1).split(",");
            HashSet<String> set = new HashSet<String>();
            for (String plot : plots) {
                set.add(plot.trim());
            }
            return set;
        }
        return new HashSet<String>();
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && Utils.isInGarden()) {
            if (all.value()) {
                for (Map.Entry<String, Plot> entry : plotData.entrySet()) {
                    if (infestedPlots.contains(entry.getKey())) continue;
                    event.drawOutline(entry.getValue().boundingBox, true, allColor.value());
                }
            }
            if (current.value()) {
                for (Map.Entry entry : plotData.entrySet()) {
                    if (infestedPlots.contains(entry.getKey()) || !((Plot)entry.getValue()).isPlayerAbove()) continue;
                    event.drawOutline(((Plot)entry.getValue()).boundingBox, true, currentColor.value());
                    break;
                }
            }
            if (infested.value()) {
                for (String string : infestedPlots) {
                    event.drawOutline(PlotBorders.plotData.get((Object)string).boundingBox, true, infestedColor.value());
                }
            }
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && Utils.isInGarden() && infested.value()) {
            infestedPlots = PlotBorders.getInfestedPlots();
        }
    }

    public static class Plot {
        public class_2338 center;
        public class_238 boundingBox;

        public Plot(int centerX, int centerZ) {
            this.center = new class_2338(centerX, 66, centerZ);
            this.boundingBox = class_238.method_30048((class_243)this.center.method_46558().method_1031(-0.5, 0.5, -0.5), (double)96.0, (double)0.0, (double)96.0);
        }

        public boolean isPlayerAbove() {
            class_243 pos = Main.mc.field_1724.method_19538();
            if (pos.method_10214() > 66.0 && pos.method_10214() < 142.0) {
                return pos.method_10216() > this.boundingBox.field_1323 && pos.method_10216() < this.boundingBox.field_1320 && pos.method_10215() > this.boundingBox.field_1321 && pos.method_10215() < this.boundingBox.field_1324;
            }
            return false;
        }
    }
}

