/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.config.SettingInt;
import nofrills.events.ChatMsgEvent;
import nofrills.events.PartyChatMsgEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.RenderColor;

public class ChatWaypoints {
    public static final Feature instance = new Feature("chatWaypoints");
    public static final SettingBool partyWaypoints = new SettingBool(false, "partyEnabled", instance.key());
    public static final SettingInt partyDuration = new SettingInt(120, "partyDuration", instance.key());
    public static final SettingBool partyClear = new SettingBool(false, "partyClearOnArrive", instance.key());
    public static final SettingColor partyColor = new SettingColor(RenderColor.fromArgb(-1437248001), "partyColor", instance.key());
    public static final SettingBool allWaypoints = new SettingBool(false, "allEnabled", instance.key());
    public static final SettingInt allDuration = new SettingInt(60, "allDuration", instance.key());
    public static final SettingBool allClear = new SettingBool(false, "allClearOnArrive", instance.key());
    public static final SettingColor allColor = new SettingColor(RenderColor.fromArgb(-1437204481), "allColor", instance.key());
    private static final List<PlayerWaypoint> waypointList = new ArrayList<PlayerWaypoint>();

    private static boolean isPlayerValid(String name) {
        if (Main.mc.field_1724 != null && Main.mc.field_1724.method_5477().getString().equals(name)) {
            return false;
        }
        return Main.mc.method_1562() != null && Main.mc.method_1562().method_2874(name) != null;
    }

    private static void highlightCoords(String message, String sender, boolean party) {
        ArrayList<Double> coords = new ArrayList<Double>();
        boolean skipNextError = false;
        for (String coord : message.split(" ")) {
            if (coord.endsWith(",") && coord.indexOf(",") == coord.lastIndexOf(",")) {
                coord = coord.replace(",", "");
                skipNextError = true;
            }
            try {
                coords.add(Double.parseDouble(coord));
            }
            catch (NumberFormatException ignored) {
                if (!skipNextError) {
                    coords.clear();
                }
                skipNextError = false;
            }
            if (coords.size() != 3) continue;
            class_2338 pos = new class_2338((int)Math.floor((Double)coords.getFirst()), (int)Math.floor((Double)coords.get(1)), (int)Math.floor((Double)coords.get(2)));
            if (pos.method_10264() < 0 || pos.method_10264() > 256) break;
            int duration = party ? partyDuration.value() * 20 : allDuration.value() * 20;
            waypointList.removeIf(waypoint -> waypoint.name.getString().equals(sender));
            waypointList.add(new PlayerWaypoint(sender, pos, duration, party));
            break;
        }
    }

    @EventHandler
    private static void onMessage(ChatMsgEvent event) {
        String msg = event.getPlainMessage();
        if (instance.isActive() && allWaypoints.value()) {
            if (msg.startsWith("[NPC]") || msg.startsWith("[BOSS]") || msg.startsWith("Guild > ") || msg.startsWith("Party > ")) {
                return;
            }
            int msgStart = msg.indexOf(":");
            if (msgStart != -1) {
                String sender;
                String senderInfo = msg.substring(0, msgStart);
                String string = sender = senderInfo.contains(" ") ? Arrays.stream(senderInfo.split(" ")).toList().getLast().trim() : senderInfo;
                if (ChatWaypoints.isPlayerValid(sender)) {
                    ChatWaypoints.highlightCoords(msg.substring(msgStart), sender, false);
                }
            }
        }
    }

    @EventHandler
    private static void onPartyMessage(PartyChatMsgEvent event) {
        if (instance.isActive() && partyWaypoints.value() && !event.self) {
            ChatWaypoints.highlightCoords(event.message, event.sender, true);
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && !waypointList.isEmpty()) {
            for (PlayerWaypoint waypoint : new ArrayList<PlayerWaypoint>(waypointList)) {
                if (waypoint.duration <= 0) continue;
                --waypoint.duration;
            }
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && !waypointList.isEmpty()) {
            ArrayList<PlayerWaypoint> waypoints = new ArrayList<PlayerWaypoint>(waypointList);
            for (PlayerWaypoint waypoint : waypoints) {
                if (waypoint.duration == 0) {
                    waypointList.remove(waypoint);
                    continue;
                }
                if (waypoint.shouldClear() && waypoint.box.method_1005().method_1022(Main.mc.field_1724.method_19538()) <= 8.0) {
                    waypointList.remove(waypoint);
                    continue;
                }
                RenderColor color = waypoint.party ? partyColor.value() : allColor.value();
                event.drawFilledWithBeam(waypoint.box, 256, true, color);
                event.drawText(waypoint.box.method_1005().method_1031(0.0, 1.0, 0.0), waypoint.name, 0.05f, true, RenderColor.white);
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        if (!waypointList.isEmpty()) {
            waypointList.clear();
        }
    }

    private static class PlayerWaypoint {
        public class_2561 name;
        public class_238 box;
        public int duration;
        public boolean party;

        public PlayerWaypoint(String name, class_2338 pos, int duration, boolean party) {
            this.name = class_2561.method_43470((String)name);
            this.box = class_238.method_54784((class_2338)pos, (class_2338)pos);
            this.duration = duration;
            this.party = party;
        }

        public boolean shouldClear() {
            return this.party ? partyClear.value() : allClear.value();
        }
    }
}

