/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.general;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_465;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingJson;
import nofrills.events.InputEvent;
import nofrills.hud.clickgui.Settings;
import nofrills.hud.clickgui.components.FlatTextbox;
import nofrills.hud.clickgui.components.KeybindButton;
import nofrills.misc.Utils;

public class CustomKeybinds {
    public static final Feature instance = new Feature("customKeybinds");
    public static final SettingBool allowInGui = new SettingBool(false, "allowInGui", instance.key());
    public static final SettingJson data = new SettingJson(new JsonObject(), "data", instance.key());

    public static List<FlowLayout> getSettingsList() {
        ArrayList<FlowLayout> list = new ArrayList<FlowLayout>();
        Settings.Toggle allowInGuiToggle = new Settings.Toggle("Allow in GUI", allowInGui, "Allow keybinds to work while any container GUI (inventory/chest/furnace/etc.) is open.");
        list.add(allowInGuiToggle);
        Settings.BigButton button = new Settings.BigButton("Add New Custom Keybind", btn -> {
            if (!data.value().has("binds")) {
                data.value().add("binds", (JsonElement)new JsonArray());
            }
            JsonObject object = new JsonObject();
            object.addProperty("key", (Number)-1);
            object.addProperty("command", "");
            data.value().get("binds").getAsJsonArray().add((JsonElement)object);
            Main.mc.method_1507((class_437)CustomKeybinds.buildSettings());
        });
        button.button.verticalSizing(Sizing.fixed((int)18));
        list.add(button);
        if (data.value().has("binds")) {
            JsonArray binds = data.value().get("binds").getAsJsonArray();
            for (int i = 0; i < binds.size(); ++i) {
                list.add(new Setting(i));
            }
        }
        return list;
    }

    public static Settings buildSettings() {
        Settings settings = new Settings(CustomKeybinds.getSettingsList());
        settings.setTitle((class_2561)class_2561.method_43470((String)"Custom Keybinds"));
        return settings;
    }

    @EventHandler
    public static void onKey(InputEvent event) {
        if (instance.isActive() && (allowInGui.value() && Main.mc.field_1755 instanceof class_465 || Main.mc.field_1755 == null) && data.value().has("binds")) {
            for (JsonElement entry : data.value().get("binds").getAsJsonArray()) {
                JsonObject bind = entry.getAsJsonObject();
                String command = bind.get("command").getAsString();
                if (bind.get("key").getAsInt() != event.key || command.isEmpty()) continue;
                if (event.action == 1) {
                    Utils.sendMessage(command);
                }
                event.cancel();
                return;
            }
        }
    }

    public static class Setting
    extends FlowLayout {
        public int index;
        public FlatTextbox input;
        public KeybindButton keybind;
        public ButtonComponent delete;

        public Setting(int index) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5, (int)5, (int)4, (int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.index = index;
            this.input = new FlatTextbox(Sizing.fixed((int)160));
            this.input.margins(Insets.of((int)0, (int)0, (int)0, (int)6));
            this.input.text(this.getData().get("command").getAsString());
            this.input.onChanged().subscribe(value -> this.getData().addProperty("command", value));
            this.keybind = new KeybindButton();
            this.keybind.verticalSizing(Sizing.fixed((int)18)).margins(Insets.of((int)1, (int)0, (int)0, (int)0));
            this.keybind.bind(this.getData().get("key").getAsInt());
            this.keybind.onBound().subscribe(key -> this.getData().addProperty("key", (Number)key));
            this.delete = Components.button((class_2561)class_2561.method_43470((String)"Delete").method_54663(0xFFFFFF), button -> {
                data.value().get("binds").getAsJsonArray().remove(this.index);
                Main.mc.method_1507((class_437)CustomKeybinds.buildSettings());
            });
            this.delete.positioning(Positioning.relative((int)100, (int)0)).verticalSizing(Sizing.fixed((int)18)).margins(Insets.of((int)1, (int)0, (int)0, (int)0));
            this.delete.renderer((context, btn, delta) -> {
                context.method_25294(btn.method_46426(), btn.method_46427(), btn.method_46426() + btn.method_25368(), btn.method_46427() + btn.method_25364(), -15724528);
                context.method_49601(btn.method_46426(), btn.method_46427(), btn.method_25368(), btn.method_25364(), -1);
            });
            this.child((Component)this.input);
            this.child((Component)this.keybind);
            this.child((Component)this.delete);
        }

        public JsonObject getData() {
            return data.value().get("binds").getAsJsonArray().get(this.index).getAsJsonObject();
        }
    }
}

