/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.general;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingEnum;
import nofrills.config.SettingJson;
import nofrills.config.SettingString;
import nofrills.events.PartyChatMsgEvent;
import nofrills.events.WorldTickEvent;
import nofrills.features.misc.AutoRequeue;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class PartyCommands {
    public static final Feature instance = new Feature("partyCommands");
    public static final SettingString prefixes = new SettingString("! ?", "prefixes", instance.key());
    public static final SettingBool self = new SettingBool(false, "self", instance.key());
    public static final SettingJson lists = new SettingJson(new JsonObject(), "lists", instance.key());
    public static final SettingEnum<behavior> warp = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "warp", instance.key());
    public static final SettingEnum<behavior> transfer = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "transfer", instance.key());
    public static final SettingEnum<behavior> allinv = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "allinv", instance.key());
    public static final SettingEnum<behavior> downtime = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "downtime", instance.key());
    public static final SettingEnum<behavior> queue = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "queue", instance.key());
    public static final SettingEnum<behavior> coords = new SettingEnum<behavior>(behavior.Disabled, behavior.class, "coords", instance.key());
    private static boolean downtimeNeeded = false;

    private static void showDowntimeReminder() {
        Utils.showTitle("\u00a76\u00a7lDOWNTIME", "", 5, 60, 5);
        Utils.playSound((class_6880.class_6883<class_3414>)class_3417.field_14624, class_3419.field_15250, 1.0f, 0.0f);
        downtimeNeeded = false;
    }

    public static String listInstancesFormatted() {
        StringBuilder builder = new StringBuilder();
        for (SkyblockData.InstanceType instanceType : SkyblockData.instances) {
            builder.append(Utils.format("\n!{} - {}", instanceType.name, Utils.uppercaseFirst(Utils.toLower(instanceType.type), true)));
        }
        return builder.toString();
    }

    public static boolean isOnList(String sender, String list) {
        if (lists.value().has(list)) {
            return lists.value().getAsJsonArray(list).contains((JsonElement)new JsonPrimitive(sender));
        }
        return false;
    }

    public static boolean isListEmpty(String list) {
        if (!lists.value().has(list)) {
            lists.value().add(list, (JsonElement)new JsonArray());
        }
        return lists.value().get(list).getAsJsonArray().isEmpty();
    }

    public static void addToList(String name, String list) {
        if (!lists.value().has(list)) {
            lists.value().add(list, (JsonElement)new JsonArray());
        }
        lists.value().get(list).getAsJsonArray().add(name);
    }

    public static void removeFromList(String name, String list) {
        if (lists.value().has(list)) {
            lists.value().get(list).getAsJsonArray().remove((JsonElement)new JsonPrimitive(name));
        }
    }

    @EventHandler
    private static void onPartyMessage(PartyChatMsgEvent event) {
        if (instance.isActive() && !prefixes.value().isEmpty()) {
            if (!self.value() && event.self) {
                return;
            }
            String msg = Utils.toLower(event.message);
            String author = Utils.toLower(event.sender);
            for (String prefix : prefixes.value().split(" ")) {
                if (!msg.startsWith(Utils.toLower(prefix))) continue;
                if (PartyCommands.isOnList(author, "blacklist")) {
                    return;
                }
                boolean whitelisted = event.self || PartyCommands.isOnList(author, "whitelist");
                String command = msg.replace(prefix, "");
                if (!warp.value().equals((Object)behavior.Disabled) && command.startsWith("warp")) {
                    if (whitelisted || warp.value().equals((Object)behavior.Automatic)) {
                        Utils.sendMessage("/party warp");
                    } else if (!warp.value().equals((Object)behavior.Ignore)) {
                        Utils.infoButton("\u00a7aClick here to warp your party.", "/party warp");
                    }
                }
                if (!transfer.value().equals((Object)behavior.Disabled) && command.startsWith("pt")) {
                    if (whitelisted || transfer.value().equals((Object)behavior.Automatic)) {
                        Utils.sendMessage("/party transfer " + author);
                    } else if (!transfer.value().equals((Object)behavior.Ignore)) {
                        Utils.infoButton("\u00a7aClick here to promote \u00a76" + event.sender + " \u00a7aas leader.", "/party transfer " + author);
                    }
                }
                if (!allinv.value().equals((Object)behavior.Disabled) && command.startsWith("allinv")) {
                    if (whitelisted || allinv.value().equals((Object)behavior.Automatic)) {
                        Utils.sendMessage("/party settings allinvite");
                    } else if (!allinv.value().equals((Object)behavior.Ignore)) {
                        Utils.infoButton("\u00a7aClick here to toggle all invite.", "/party settings allinvite");
                    }
                }
                if (!downtime.value().equals((Object)behavior.Disabled) && command.startsWith("dt") && (whitelisted || downtime.value().equals((Object)behavior.Automatic))) {
                    if (SkyblockData.isInInstance()) {
                        if (!Utils.isInstanceOver()) {
                            Utils.info("\u00a7aScheduled downtime reminder.");
                            downtimeNeeded = true;
                        }
                        if (AutoRequeue.instance.isActive()) {
                            AutoRequeue.setPaused();
                        }
                    } else {
                        PartyCommands.showDowntimeReminder();
                    }
                }
                if (!queue.value().equals((Object)behavior.Disabled)) {
                    for (SkyblockData.InstanceType instance : SkyblockData.instances) {
                        if (!command.equals(instance.name)) continue;
                        if (whitelisted || queue.value().equals((Object)behavior.Automatic)) {
                            Utils.sendMessage("/joininstance " + instance.type);
                            break;
                        }
                        if (queue.value().equals((Object)behavior.Ignore)) break;
                        Utils.infoButton("\u00a7aClick to queue for \u00a76" + Utils.uppercaseFirst(Utils.toLower(instance.type), true) + "\u00a7a.", "/joininstance " + instance.type);
                        break;
                    }
                }
                if (coords.value().equals((Object)behavior.Disabled) || !command.startsWith("coords")) continue;
                if (whitelisted || coords.value().equals((Object)behavior.Automatic)) {
                    Utils.sendMessage("/pc " + Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
                    continue;
                }
                if (coords.value().equals((Object)behavior.Ignore)) continue;
                Utils.infoButton("\u00a7aClick here to send your coordinates.", "/pc " + Utils.getCoordsFormatted("x: {}, y: {}, z: {}"));
            }
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && downtimeNeeded && Utils.isInstanceOver()) {
            PartyCommands.showDowntimeReminder();
        }
    }

    public static enum behavior {
        Automatic,
        Manual,
        Ignore,
        Disabled;

    }
}

