/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.general;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Set;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingInt;
import nofrills.events.TooltipRenderEvent;
import nofrills.misc.NoFrillsAPI;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class PriceTooltips {
    public static final Feature instance = new Feature("priceTooltips");
    public static final SettingBool auction = new SettingBool(false, "auction", instance.key());
    public static final SettingBool bazaar = new SettingBool(false, "bazaar", instance.key());
    public static final SettingBool npc = new SettingBool(false, "npc", instance.key());
    public static final SettingBool mote = new SettingBool(false, "mote", instance.key());
    public static final SettingInt burgers = new SettingInt(0, "burgers", instance.key());

    public static String parseItemId(class_1799 stack, class_2487 data, String title) {
        String id = Utils.getSkyblockId(data);
        if (id.isEmpty()) {
            if (title.equals("Hunting Box")) {
                return PriceTooltips.correctShardId(PriceTooltips.getShardId(stack));
            }
            if (title.equals("Attribute Menu")) {
                for (String line : Utils.getLoreLines(stack)) {
                    if (!line.startsWith("Source: ")) continue;
                    return PriceTooltips.correctShardId(Utils.toUpper(line.substring(line.indexOf(":") + 2, line.indexOf("Shard") - 1)).replaceAll(" ", "_"));
                }
            }
        }
        switch (id) {
            case "PET": {
                if (data.method_10545("petInfo")) {
                    JsonObject petData = JsonParser.parseString((String)data.method_10558("petInfo").orElse("")).getAsJsonObject();
                    return Utils.format("{}_PET_{}", petData.get("type").getAsString(), petData.get("tier").getAsString());
                }
                return "UNKNOWN_PET";
            }
            case "RUNE": 
            case "UNIQUE_RUNE": {
                class_2487 runeData;
                if (data.method_10545("runes") && (runeData = (class_2487)data.method_10562("runes").orElse(null)) != null) {
                    String runeId = (String)runeData.method_10541().toArray()[0];
                    return Utils.format("{}_{}_RUNE", runeId, runeData.method_10550(runeId).orElse(0));
                }
                return "EMPTY_RUNE";
            }
            case "ENCHANTED_BOOK": {
                class_2487 enchantData;
                Set enchants;
                if (data.method_10545("enchantments") && (enchants = (enchantData = (class_2487)data.method_10562("enchantments").orElse(null)).method_10541()).size() == 1) {
                    String enchantId = (String)enchantData.method_10541().toArray()[0];
                    int enchantLevel = enchantData.method_10550(enchantId).orElse(0);
                    return Utils.format("ENCHANTMENT_{}_{}", Utils.toUpper(enchantId), enchantLevel);
                }
                return "ENCHANTMENT_UNKNOWN";
            }
            case "ATTRIBUTE_SHARD": {
                return PriceTooltips.correctShardId(PriceTooltips.getShardId(stack));
            }
            case "POTION": {
                if (data.method_10545("potion")) {
                    return Utils.format("{}_{}_POTION", Utils.toUpper(data.method_10558("potion").orElse("")), data.method_10550("potion_level").orElse(0));
                }
                return "UNKNOWN_POTION";
            }
        }
        return id;
    }

    public static String getShardId(class_1799 stack) {
        return Utils.toUpper(Utils.toPlainString(stack.method_7964()).replaceAll(" Shard", "").replaceAll(" ", "_"));
    }

    public static String correctShardId(String id) {
        return switch (id) {
            case "CINDERBAT" -> "SHARD_CINDER_BAT";
            case "ABYSSAL_LANTERNFISH" -> "SHARD_ABYSSAL_LANTERN";
            case "STRIDERSURFER" -> "SHARD_STRIDER_SURFER";
            case "BOGGED" -> "SHARD_SEA_ARCHER";
            case "LOCH_EMPEROR" -> "SHARD_SEA_EMPEROR";
            default -> Utils.format("SHARD_{}", id);
        };
    }

    public static int getStackQuantity(class_1799 stack, String title) {
        if (title.endsWith("Sack")) {
            for (String line : Utils.getLoreLines(stack)) {
                if (!line.startsWith("Stored: ") || !line.contains("/")) continue;
                String count = line.substring(line.indexOf(":") + 1, line.indexOf("/")).trim();
                try {
                    int countInt = Integer.parseInt(count.replaceAll(",", ""));
                    return countInt > 0 ? countInt : 1;
                }
                catch (NumberFormatException countInt) {
                }
            }
        }
        if (title.equals("Hunting Box")) {
            for (String line : Utils.getLoreLines(stack)) {
                if (!line.startsWith("Owned: ")) continue;
                int start = line.indexOf(":") + 2;
                int end = line.indexOf(" ", start);
                try {
                    int countInt = Integer.parseInt(line.substring(start, end).replaceAll(",", ""));
                    return countInt > 0 ? countInt : 1;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        if (title.equals("Attribute Menu")) {
            for (String line : Utils.getLoreLines(stack)) {
                if (!line.startsWith("Syphon") || !line.endsWith("more to level up!")) continue;
                String replaced = line.replace("Syphon", "").trim();
                try {
                    int countInt = Integer.parseInt(replaced.substring(0, replaced.indexOf(" ")).replaceAll(",", ""));
                    return countInt > 0 ? countInt : 1;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return stack.method_7947();
    }

    private static class_2561 buildLine(String name, double price, int quantity) {
        String line = Utils.format("{}: \u00a76{} {}", name, Utils.formatSeparator(price * (double)quantity), quantity > 1 ? Utils.format("\u00a78({}x {})", Utils.formatSeparator(quantity), Utils.formatSeparator(price)) : "").trim();
        return Utils.getShortTag().method_10852((class_2561)class_2561.method_43470((String)line).method_54663(0xFFFFFF));
    }

    private static class_2561 buildLine(String name, long price, int quantity) {
        String line = Utils.format("{}: \u00a76{} {}", name, Utils.formatSeparator(price * (long)quantity), quantity > 1 ? Utils.format("\u00a78({}x {})", Utils.formatSeparator(quantity), Utils.formatSeparator(price)) : "").trim();
        return Utils.getShortTag().method_10852((class_2561)class_2561.method_43470((String)line).method_54663(0xFFFFFF));
    }

    @EventHandler
    private static void onTooltip(TooltipRenderEvent event) {
        if (instance.isActive()) {
            HashMap<String, Double> prices;
            String itemId = PriceTooltips.parseItemId(event.stack, event.customData, event.title);
            int quantity = PriceTooltips.getStackQuantity(event.stack, event.title);
            if (itemId.isEmpty()) {
                return;
            }
            if (mote.value() && NoFrillsAPI.npcPricing.containsKey(itemId) && SkyblockData.getArea().equals("The Rift") && (prices = NoFrillsAPI.npcPricing.get(itemId)).containsKey("mote")) {
                double burgerBonus = 1.0 + 0.05 * (double)burgers.value();
                event.addLine(PriceTooltips.buildLine("\u00a7dMotes Price", prices.get("mote") * burgerBonus, quantity));
            }
            if (npc.value() && NoFrillsAPI.npcPricing.containsKey(itemId) && (prices = NoFrillsAPI.npcPricing.get(itemId)).containsKey("coin")) {
                event.addLine(PriceTooltips.buildLine("\u00a7eNPC Price", prices.get("coin"), quantity));
            }
            if (auction.value() && NoFrillsAPI.auctionPricing.containsKey(itemId)) {
                event.addLine(PriceTooltips.buildLine("\u00a7eLowest BIN", NoFrillsAPI.auctionPricing.get(itemId), quantity));
            }
            if (bazaar.value() && NoFrillsAPI.bazaarPricing.containsKey(itemId)) {
                prices = NoFrillsAPI.bazaarPricing.get(itemId);
                event.addLine(PriceTooltips.buildLine("\u00a7eBazaar Buy", prices.get("buy"), quantity));
                event.addLine(PriceTooltips.buildLine("\u00a7eBazaar Sell", prices.get("sell"), quantity));
            }
        }
    }
}

