/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.hunting;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingColor;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.SpawnParticleEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;

public class InvisibugHighlight {
    public static final Feature instance = new Feature("invisibugHighlight");
    public static final SettingColor color = new SettingColor(RenderColor.fromHex(0xFF0000, 0.5f), "color", instance.key());
    private static final List<Invisibug> invisibugList = new ArrayList<Invisibug>();

    private static boolean isInvisibugParticle(class_2675 packet) {
        return packet.method_11545() == 1 && packet.method_11543() == 0.0f && packet.method_11548() == 0.0f && packet.method_11549() == 0.0f && packet.method_11550() == 0.0f && packet.method_65082() && packet.method_11552();
    }

    private static boolean hasInvisibugMarker(class_243 pos) {
        class_1297 class_12972;
        List<class_1297> other = Utils.getOtherEntities((class_1297)Main.mc.field_1724, class_238.method_30048((class_243)pos, (double)1.0, (double)2.0, (double)1.0), null);
        if (other.size() == 1 && (class_12972 = other.getFirst()) instanceof class_1531) {
            class_1531 marker = (class_1531)class_12972;
            return marker.method_6912() && marker.method_5797() == null && marker.method_6047().method_7960();
        }
        return false;
    }

    @EventHandler
    private static void onParticle(SpawnParticleEvent event) {
        if (instance.isActive() && Utils.isInArea("Galatea") && event.type.equals((Object)class_2398.field_11205) && InvisibugHighlight.isInvisibugParticle(event.packet) && InvisibugHighlight.hasInvisibugMarker(event.pos)) {
            for (Invisibug bug : new ArrayList<Invisibug>(invisibugList)) {
                if (!bug.isNear(event.pos)) continue;
                bug.add(event.pos);
                return;
            }
            invisibugList.add(new Invisibug(event.pos));
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && Utils.isInArea("Galatea")) {
            for (Invisibug bug : new ArrayList<Invisibug>(invisibugList)) {
                bug.tick();
                if (bug.updateTicks != 0) continue;
                invisibugList.remove(bug);
            }
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && Utils.isInArea("Galatea")) {
            for (Invisibug bug : new ArrayList<Invisibug>(invisibugList)) {
                if (bug.positions.size() != 4) continue;
                event.drawFilled(class_238.method_30048((class_243)bug.positions.getLast(), (double)1.0, (double)1.0, (double)1.0), false, color.value());
                event.drawText(bug.positions.getLast().method_1031(0.0, 1.0, 0.0), class_2561.method_30163((String)"Invisibug"), 0.035f, false, RenderColor.white);
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        invisibugList.clear();
    }

    private static class Invisibug {
        public int updateTicks = 20;
        public List<class_243> positions = new ArrayList<class_243>();

        public Invisibug(class_243 initialPos) {
            this.positions.add(initialPos);
        }

        public void tick() {
            if (this.updateTicks > 0) {
                --this.updateTicks;
            }
        }

        public boolean isNear(class_243 pos) {
            return !this.positions.isEmpty() && pos.method_1022(this.positions.getLast()) <= 0.3;
        }

        public void add(class_243 pos) {
            if (this.positions.size() == 4) {
                this.positions.removeFirst();
            }
            this.positions.add(pos);
            this.updateTicks = 20;
        }
    }
}

