/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.hunting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.zip.GZIPInputStream;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5250;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingJson;
import nofrills.events.ChatMsgEvent;
import nofrills.events.ScreenOpenEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.SlotUpdateEvent;
import nofrills.features.general.PriceTooltips;
import nofrills.hud.clickgui.Settings;
import nofrills.hud.clickgui.components.FlatTextbox;
import nofrills.misc.ShardData;
import nofrills.misc.Utils;

public class ShardTracker {
    public static final Feature instance = new Feature("shardTracker");
    public static final SettingBool boxApply = new SettingBool(false, "load", instance.key());
    public static final SettingBool doneMsg = new SettingBool(false, "doneMsg", instance.key());
    public static final SettingBool filterFuse = new SettingBool(false, "filterFuse", instance.key());
    public static final SettingBool filterDirect = new SettingBool(false, "filterDirect", instance.key());
    public static final SettingJson data = new SettingJson(new JsonObject(), "data", instance.key());
    public static final class_5250 displayNone;
    public static class_5250 display;

    public static List<FlowLayout> getSettingsList() {
        ArrayList<FlowLayout> list = new ArrayList<FlowLayout>();
        list.add(new Settings.Description("Usage", "Run the \"/nf shardTracker\" command to see more information."));
        list.add(new Settings.Toggle("Apply From Box", boxApply, "Automatically applies obtained amounts to shards when you open your Hunting Box."));
        list.add(new Settings.Toggle("Done Message", doneMsg, "Shows a message in chat once you reach the needed amount for any shard."));
        list.add(new Settings.Toggle("Filter Fuse", filterFuse, "Hides every Fuse/Cycle shard while outside of the Fusion Machine."));
        list.add(new Settings.Toggle("Filter Direct", filterDirect, "Hides every Direct/Bazaar shard while inside of the Fusion Machine."));
        Settings.BigButton clearButton = new Settings.BigButton("Clear Shard List", btn -> {
            data.value().add("shards", (JsonElement)new JsonArray());
            Main.mc.method_1507((class_437)ShardTracker.buildSettings());
        });
        clearButton.button.verticalSizing(Sizing.fixed((int)18));
        clearButton.button.tooltip((class_2561)class_2561.method_43470((String)"Clears the list of your tracked shards."));
        list.add(clearButton);
        Settings.BigButton importButton = new Settings.BigButton("Import Shard Tree", btn -> {
            ShardTracker.importTreeData();
            Main.mc.method_1507((class_437)ShardTracker.buildSettings());
        });
        importButton.button.verticalSizing(Sizing.fixed((int)18));
        importButton.button.tooltip((class_2561)class_2561.method_43470((String)"Pastes the list of shards that you need to get."));
        list.add(importButton);
        Settings.BigButton button = new Settings.BigButton("Add New Shard", btn -> {
            if (!data.value().has("shards")) {
                data.value().add("shards", (JsonElement)new JsonArray());
            }
            JsonObject object = new JsonObject();
            object.addProperty("name", "");
            object.addProperty("needed", (Number)0L);
            object.addProperty("obtained", (Number)0L);
            object.addProperty("source", "Direct");
            data.value().get("shards").getAsJsonArray().add((JsonElement)object);
            Main.mc.method_1507((class_437)ShardTracker.buildSettings());
        });
        button.button.verticalSizing(Sizing.fixed((int)18));
        list.add(button);
        if (data.value().has("shards")) {
            JsonArray shards = data.value().get("shards").getAsJsonArray();
            for (int i = 0; i < shards.size(); ++i) {
                list.add(new Setting(i));
            }
        }
        return list;
    }

    public static Settings buildSettings() {
        Settings settings = new Settings(ShardTracker.getSettingsList());
        settings.setTitle((class_2561)class_2561.method_43470((String)"Shard Tracker"));
        ShardTracker.refreshDisplay();
        return settings;
    }

    public static void importTreeData() {
        if (!data.value().has("shards")) {
            data.value().add("shards", (JsonElement)new JsonArray());
        }
        JsonArray shards = data.value().get("shards").getAsJsonArray();
        String clipboard = Main.mc.field_1774.method_1460();
        JsonArray treeData = ShardTracker.parseTreeData(clipboard);
        if (treeData == null) {
            Utils.info("\u00a7cFailed to import the fusion tree from the SkyShards calculator, no valid data found in your clipboard.");
            return;
        }
        try {
            for (JsonElement element : treeData) {
                JsonObject shardData = element.getAsJsonObject();
                String name = Utils.toLower(shardData.get("name").getAsString());
                long needed = shardData.get("needed").getAsLong();
                String source = shardData.get("source").getAsString();
                JsonObject tracked = ShardTracker.getTrackedShard(name);
                if (tracked != null && tracked.get("source").getAsString().equals(source)) {
                    tracked.addProperty("needed", (Number)(tracked.get("needed").getAsLong() + needed));
                    continue;
                }
                JsonObject object = new JsonObject();
                object.addProperty("name", name);
                object.addProperty("needed", (Number)needed);
                object.addProperty("obtained", (Number)0L);
                object.addProperty("source", source);
                shards.add((JsonElement)object);
            }
        }
        catch (Exception ignored) {
            Utils.info("\u00a7cSuccessfully read the fusion tree data, but an unknown error occurred while importing. Try updating the mod to the newest version.");
            return;
        }
        Utils.info("\u00a7aShard list imported successfully.");
    }

    private static JsonArray parseTreeData(String payload) {
        try {
            String data = payload.substring(payload.indexOf(":") + 1);
            GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(data)));
            return JsonParser.parseReader((Reader)new InputStreamReader((InputStream)gzipStream, StandardCharsets.UTF_8)).getAsJsonArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static JsonObject getTrackedShard(String shardName) {
        ArrayList<JsonObject> trackedList = new ArrayList<JsonObject>();
        for (JsonElement shard2 : data.value().get("shards").getAsJsonArray()) {
            JsonObject shardData = shard2.getAsJsonObject();
            if (!shardData.get("name").getAsString().equals(shardName)) continue;
            trackedList.add(shardData);
        }
        if (!trackedList.isEmpty()) {
            return trackedList.size() == 1 ? (JsonObject)trackedList.getFirst() : trackedList.reversed().stream().filter(shard -> {
                long needed = shard.get("needed").getAsLong();
                long obtained = shard.get("obtained").getAsLong();
                return needed == 0L || obtained < needed;
            }).findFirst().orElse((JsonObject)trackedList.getFirst());
        }
        return null;
    }

    private static boolean isInFusion() {
        class_437 class_4372 = Main.mc.field_1755;
        if (class_4372 instanceof class_476) {
            class_476 container = (class_476)class_4372;
            String title = container.method_25440().getString();
            return title.equals("Fusion Box") || title.equals("Confirm Fusion");
        }
        return false;
    }

    private static boolean shouldFilter(TrackerSource source) {
        return switch (source.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> {
                if (filterDirect.value() && ShardTracker.isInFusion()) {
                    yield true;
                }
                yield false;
            }
            case 1, 2 -> filterFuse.value() && !ShardTracker.isInFusion();
        };
    }

    public static void refreshDisplay() {
        if (data.value().has("shards")) {
            JsonArray shards = data.value().get("shards").getAsJsonArray();
            ArrayList<String> lines = new ArrayList<String>();
            for (JsonElement shard : shards) {
                JsonObject shardData = shard.getAsJsonObject();
                String name = shardData.get("name").getAsString();
                long needed = shardData.get("needed").getAsLong();
                long obtained = shardData.get("obtained").getAsLong();
                String source = shardData.get("source").getAsString();
                if (name.isEmpty() || ShardTracker.shouldFilter(ShardTracker.getTrackedSource(source))) continue;
                String shardName = Utils.format("{}\u00a7l{}", ShardData.getColorPrefix(Utils.toLower(name)), Utils.uppercaseFirst(name, false));
                String shardSource = Utils.format("{}[{}]", ShardTracker.getSourceColor(source), source);
                String quantityColor = needed > 0L & obtained >= needed ? "\u00a7a" : "\u00a7f";
                String shardQuantity = needed <= 0L ? Utils.format("{}x", Utils.formatSeparator(obtained)) : Utils.format("{}/{}x", Utils.formatSeparator(obtained), Utils.formatSeparator(needed));
                lines.add(Utils.format("{}{}\u00a7r {}\u00a7r {}", quantityColor, shardQuantity, shardName, shardSource));
            }
            if (!lines.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("\u00a7bShard Tracker");
                for (String line : lines) {
                    builder.append("\n").append(line);
                }
                display = class_2561.method_43470((String)builder.toString());
                return;
            }
        }
        display = displayNone;
    }

    private static Shard getShardFromMsg(String msg) {
        int index;
        if (msg.startsWith("You caught ") && (msg.endsWith("Shards!") || msg.endsWith("Shard!"))) {
            msg = msg.replace("You caught ", "").replace(" Shards!", "").replace(" Shard!", "").trim();
            String quantity = msg.substring(0, msg.indexOf(" "));
            String name = msg.substring(msg.indexOf(" ") + 1);
            return Shard.of(name, quantity.replace("x", ""), ShardSource.Caught);
        }
        if (msg.startsWith("LOOT SHARE You received ") && (msg.contains(" Shard for assisting ") || msg.contains(" Shards for assisting "))) {
            msg = msg.replace("LOOT SHARE You received ", "").trim();
            msg = msg.substring(0, msg.indexOf(" Shard")).trim();
            String quantity = msg.substring(0, msg.indexOf(" "));
            String name = msg.substring(msg.indexOf(" ") + 1);
            return Shard.of(name, quantity, ShardSource.Lootshare);
        }
        if ((msg.startsWith("CHARM ") || msg.startsWith("NAGA ") || msg.startsWith("SALT ")) && (index = msg.indexOf("You charmed a ")) != -1) {
            msg = msg.substring(index + "You charmed a ".length());
            int quantityStart = msg.indexOf(" and captured") + " and captured".length() + 1;
            String quantity = msg.substring(quantityStart, msg.indexOf(" ", quantityStart));
            String name = msg.substring(0, msg.indexOf(" and captured"));
            return Shard.of(name, quantity, ShardSource.Charmed);
        }
        if (msg.startsWith("FUSION! You obtained ") && msg.contains(" Shard")) {
            if ((msg = msg.replace("FUSION! You obtained ", "").replace(" NEW!", "").trim()).startsWith("an ") || msg.startsWith("a ")) {
                msg = msg.substring(msg.indexOf(" ") + 1);
            }
            String quantity = msg.substring(msg.indexOf(" Shard") + " Shard".length() + 1).trim();
            String name = msg.substring(0, msg.indexOf(" Shard"));
            return Shard.of(name, quantity.replace("x", "").replace("!", ""), ShardSource.Fused);
        }
        if (msg.startsWith("You sent ") && msg.endsWith(" to your Hunting Box.")) {
            msg = msg.replace("You sent ", "").replace(" to your Hunting Box.", "").trim();
            String quantity = msg.substring(0, msg.indexOf(" "));
            String name = msg.substring(msg.indexOf(" ") + 1, msg.indexOf(" Shard"));
            return Shard.of(name, quantity, ShardSource.Absorbed);
        }
        if (msg.startsWith("\u26c3 ") && msg.contains(" CATCH! You caught ") && msg.endsWith(" Shard!")) {
            if ((msg = msg.substring(msg.indexOf(" CATCH! You caught ") + 19).replace(" Shard!", "").trim()).startsWith("an ") || msg.startsWith("a ")) {
                msg = msg.substring(msg.indexOf(" ") + 1);
            }
            return new Shard(msg, 1, ShardSource.TreasureCatch);
        }
        if (msg.contains(" Shard (") && msg.endsWith(")")) {
            msg = msg.substring(0, msg.indexOf(" Shard (")).trim();
            return new Shard(msg, 1, ShardSource.TreeGift);
        }
        return null;
    }

    public static String getSourceColor(String source) {
        return switch (Utils.toLower(source)) {
            case "direct", "bazaar" -> "\u00a7a";
            case "fuse" -> "\u00a7d";
            case "cycle" -> "\u00a76";
            default -> "\u00a77";
        };
    }

    private static TrackerSource getTrackedSource(String source) {
        for (TrackerSource value : TrackerSource.values()) {
            if (!value.name().equals(source)) continue;
            return value;
        }
        return TrackerSource.Direct;
    }

    @EventHandler
    private static void onMessage(ChatMsgEvent event) {
        Shard shard;
        if (instance.isActive() && !event.messagePlain.isEmpty() && Utils.isInSkyblock() && (shard = ShardTracker.getShardFromMsg(event.messagePlain.trim())) != null && data.value().has("shards")) {
            if (shard.source.equals((Object)ShardSource.Absorbed) && ShardData.fishingShards.contains(shard.name)) {
                return;
            }
            JsonObject tracked = ShardTracker.getTrackedShard(shard.name);
            if (tracked != null) {
                long needed = tracked.get("needed").getAsLong();
                long obtained = tracked.get("obtained").getAsLong();
                long quantity = obtained + (long)shard.quantity;
                if (doneMsg.value() && needed != 0L && obtained < needed && quantity >= needed) {
                    String name = tracked.get("name").getAsString();
                    Utils.infoFormat("{}\u00a7l{} \u00a7r\u00a7aShard done! {}/{}x obtained.", ShardData.getColorPrefix(name), Utils.uppercaseFirst(name, false), Utils.formatSeparator(quantity), Utils.formatSeparator(needed));
                }
                tracked.addProperty("obtained", (Number)(obtained + (long)shard.quantity));
                ShardTracker.refreshDisplay();
            }
        }
    }

    @EventHandler
    private static void onSlotUpdate(SlotUpdateEvent event) {
        if (instance.isActive() && boxApply.value() && event.title.equals("Hunting Box")) {
            if (event.isInventory || !data.value().has("shards")) {
                return;
            }
            JsonArray shards = data.value().get("shards").getAsJsonArray();
            if (!shards.isEmpty()) {
                for (String line : Utils.getLoreLines(event.stack)) {
                    if (!line.startsWith("Owned: ")) continue;
                    String name = Utils.toLower(Utils.toPlainString(event.stack.method_7964()));
                    JsonObject tracked = ShardTracker.getTrackedShard(name);
                    if (tracked == null) break;
                    tracked.addProperty("obtained", (Number)PriceTooltips.getStackQuantity(event.stack, event.title));
                    ShardTracker.refreshDisplay();
                    break;
                }
            }
        }
    }

    @EventHandler
    private static void onScreen(ScreenOpenEvent event) {
        if (instance.isActive()) {
            ShardTracker.refreshDisplay();
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        if (instance.isActive()) {
            ShardTracker.refreshDisplay();
        }
    }

    static {
        display = displayNone = class_2561.method_43470((String)"\u00a7bShard Tracker\n\u00a77None tracked.");
    }

    public static class Setting
    extends FlowLayout {
        public int index;
        public FlatTextbox inputName;
        public FlatTextbox inputObtained;
        public FlatTextbox inputNeeded;
        public ButtonComponent inputSource;
        public ButtonComponent delete;

        public Setting(int index) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5, (int)5, (int)4, (int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.index = index;
            this.inputName = new FlatTextbox(Sizing.fixed((int)80));
            this.inputName.margins(Insets.of((int)0, (int)0, (int)0, (int)5));
            this.inputName.tooltip((class_2561)class_2561.method_43470((String)"The name of the shard you want to track."));
            this.inputName.text(this.getData().get("name").getAsString());
            this.inputName.borderColor = ShardData.getColorHex(this.getData().get("name").getAsString());
            this.inputName.onChanged().subscribe(value -> {
                this.getData().addProperty("name", Utils.toLower(value));
                this.inputName.borderColor = ShardData.getColorHex(Utils.toLower(value));
                ShardTracker.refreshDisplay();
            });
            this.inputObtained = new FlatTextbox(Sizing.fixed((int)50));
            this.inputObtained.margins(Insets.of((int)0, (int)0, (int)0, (int)5));
            this.inputObtained.tooltip((class_2561)class_2561.method_43470((String)"The amount of this shard that you currently have."));
            this.inputObtained.text(String.valueOf(this.getData().get("obtained").getAsLong()));
            this.inputObtained.onChanged().subscribe(value -> {
                try {
                    this.getData().addProperty("obtained", (Number)Long.valueOf(value));
                    ShardTracker.refreshDisplay();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.inputNeeded = new FlatTextbox(Sizing.fixed((int)50));
            this.inputNeeded.margins(Insets.of((int)0, (int)0, (int)0, (int)5));
            this.inputNeeded.tooltip((class_2561)class_2561.method_43470((String)"The amount of this shard that you want to obtain. Set to 0 for no target amount."));
            this.inputNeeded.text(String.valueOf(this.getData().get("needed").getAsLong()));
            this.inputNeeded.onChanged().subscribe(value -> {
                try {
                    this.getData().addProperty("needed", (Number)Long.valueOf(value));
                    ShardTracker.refreshDisplay();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            this.inputSource = Components.button((class_2561)this.getSourceInputLabel(ShardTracker.getTrackedSource(this.getData().get("source").getAsString())), button -> {
                TrackerSource[] values = TrackerSource.values();
                TrackerSource source = ShardTracker.getTrackedSource(this.getData().get("source").getAsString());
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].equals((Object)source)) continue;
                    TrackerSource newSource = i == values.length - 1 ? values[0] : values[i + 1];
                    this.getData().addProperty("source", newSource.name());
                    this.inputSource.method_25355((class_2561)this.getSourceInputLabel(newSource));
                    ShardTracker.refreshDisplay();
                    return;
                }
                this.getData().addProperty("source", TrackerSource.Direct.name());
                this.inputSource.method_25355((class_2561)this.getSourceInputLabel(TrackerSource.Direct));
                ShardTracker.refreshDisplay();
            });
            this.inputSource.renderer((context, button, delta) -> {
                context.method_25294(button.method_46426(), button.method_46427(), button.method_46426() + button.method_25368(), button.method_46427() + button.method_25364(), -15724528);
                context.method_49601(button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), -10706753);
            });
            this.inputSource.margins(Insets.of((int)1, (int)0, (int)0, (int)0));
            this.inputSource.sizing(Sizing.fixed((int)48), Sizing.fixed((int)18));
            this.inputSource.tooltip((class_2561)class_2561.method_43470((String)"The source that this shard is obtained from. Click to rotate."));
            this.delete = Components.button((class_2561)class_2561.method_43470((String)"Delete").method_54663(0xFFFFFF), button -> {
                data.value().get("shards").getAsJsonArray().remove(this.index);
                Main.mc.method_1507((class_437)ShardTracker.buildSettings());
            });
            this.delete.positioning(Positioning.relative((int)100, (int)0)).verticalSizing(Sizing.fixed((int)18)).margins(Insets.of((int)1, (int)0, (int)0, (int)0));
            this.delete.renderer((context, btn, delta) -> {
                context.method_25294(btn.method_46426(), btn.method_46427(), btn.method_46426() + btn.method_25368(), btn.method_46427() + btn.method_25364(), -15724528);
                context.method_49601(btn.method_46426(), btn.method_46427(), btn.method_25368(), btn.method_25364(), -1);
            });
            this.child((Component)this.inputName);
            this.child((Component)this.inputObtained);
            this.child((Component)this.inputNeeded);
            this.child((Component)this.inputSource);
            this.child((Component)this.delete);
        }

        public JsonObject getData() {
            return data.value().get("shards").getAsJsonArray().get(this.index).getAsJsonObject();
        }

        public class_5250 getSourceInputLabel(TrackerSource source) {
            return class_2561.method_43470((String)Utils.format("{}{}", ShardTracker.getSourceColor(source.name()), source.name()));
        }
    }

    public static enum TrackerSource {
        Direct,
        Fuse,
        Cycle,
        Bazaar;

    }

    public static enum ShardSource {
        Caught,
        Lootshare,
        TreasureCatch,
        Charmed,
        Fused,
        Absorbed,
        TreeGift;

    }

    public static class Shard {
        public String name;
        public int quantity;
        public ShardSource source;

        public Shard(String name, int quantity, ShardSource source) {
            this.name = name;
            this.quantity = quantity;
            this.source = source;
        }

        public static Shard of(String name, String quantity, ShardSource source) {
            String shardName = Utils.toLower(name);
            try {
                int amount = Integer.parseInt(quantity);
                return new Shard(shardName, amount, source);
            }
            catch (NumberFormatException numberFormatException) {
                return new Shard(shardName, 1, source);
            }
        }
    }
}

