/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.kuudra;

import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import nofrills.config.Feature;
import nofrills.config.SettingInt;
import nofrills.events.ScreenOpenEvent;
import nofrills.events.SlotUpdateEvent;
import nofrills.features.general.PriceTooltips;
import nofrills.misc.NoFrillsAPI;
import nofrills.misc.Utils;

public class KuudraChestValue {
    public static final Feature instance = new Feature("kuudraChestValue");
    public static final SettingInt petBonus = new SettingInt(0, "petBonus", instance.key());
    public static double currentValue = 0.0;

    private static int getLootQuantity(class_1799 stack, String name) {
        String[] parts = name.split(" ");
        String last = parts[parts.length - 1];
        if (last.startsWith("x")) {
            try {
                int quantity = Integer.parseInt(last.replaceAll("x", "").replaceAll(",", ""));
                if (name.startsWith("Crimson Essence")) {
                    quantity = (int)Math.floor((double)quantity * (1.0 + (double)petBonus.value() * 0.01));
                }
                return quantity;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stack.method_7947();
    }

    private static String getLootID(class_1799 stack, String name) {
        class_2487 data = Utils.getCustomData(stack);
        String id = Utils.getSkyblockId(data);
        if (id.isEmpty()) {
            if (name.startsWith("Crimson Essence")) {
                return "ESSENCE_CRIMSON";
            }
            if (name.contains(" Shard")) {
                return PriceTooltips.correctShardId(Utils.toUpper(name.substring(0, name.indexOf("Shard")).trim().replaceAll(" ", "_")));
            }
        }
        return PriceTooltips.parseItemId(stack, data, "");
    }

    @EventHandler
    private static void onSlot(SlotUpdateEvent event) {
        if (instance.isActive() && Utils.isInKuudra() && event.title.endsWith("Chest")) {
            if (event.isInventory || event.stack.method_7909().equals(class_1802.field_8157)) {
                return;
            }
            String name = Utils.toPlainString(event.stack.method_7964());
            String id = KuudraChestValue.getLootID(event.stack, name);
            int quantity = KuudraChestValue.getLootQuantity(event.stack, name);
            if (NoFrillsAPI.auctionPricing.containsKey(id)) {
                currentValue += (double)(NoFrillsAPI.auctionPricing.get(id) * (long)quantity);
            } else if (NoFrillsAPI.bazaarPricing.containsKey(id)) {
                currentValue += NoFrillsAPI.bazaarPricing.get(id).get("sell") * (double)quantity;
            }
        }
    }

    @EventHandler
    private static void onScreen(ScreenOpenEvent event) {
        currentValue = 0.0;
    }
}

