/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.kuudra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1589;
import net.minecraft.class_345;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.KuudraUtil;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;
import nofrills.mixin.BossBarHudAccessor;

public class KuudraHealth {
    public static final Feature instance = new Feature("kuudraHealth");
    public static final SettingBool dps = new SettingBool(false, "dps", instance.key());
    public static final SettingColor color = new SettingColor(RenderColor.fromHex(0xFFFF00), "color", instance.key());
    private static final List<Float> dpsData = new ArrayList<Float>();
    private static float previousHealth = 0.0f;

    private static float getTrueHealth(float health) {
        return (health - 1024.0f) * 10000.0f;
    }

    private static float calculateDPS() {
        float total = 0.0f;
        for (float damage : dpsData) {
            total += damage;
        }
        return total / (float)dpsData.size();
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && Utils.isInKuudra()) {
            class_1589 kuudra = KuudraUtil.getKuudraEntity();
            if (kuudra == null || !kuudra.method_5805()) {
                Collection<class_345> bossBars;
                if (KuudraUtil.getCurrentPhase() == KuudraUtil.phase.DPS && !(bossBars = ((BossBarHudAccessor)Main.mc.field_1705.method_1740()).getBossBars().values()).isEmpty()) {
                    float health = ((class_345)bossBars.toArray()[0]).method_5412();
                    Utils.showTitleCustom(Utils.format("KUUDRA: {}% HP", Utils.formatDecimal(health * 100.0f)), 1, 25, 2.5f, KuudraHealth.color.value().hex);
                }
            } else {
                if (KuudraUtil.getCurrentPhase() == KuudraUtil.phase.DPS) {
                    float health = kuudra.method_6032() / kuudra.method_6063();
                    Utils.showTitleCustom(Utils.format("KUUDRA: {}% HP", Utils.formatDecimal(health)), 1, 25, 2.5f, KuudraHealth.color.value().hex);
                }
                if (dps.value() && KuudraUtil.getCurrentPhase() == KuudraUtil.phase.Lair && !Utils.isInstanceOver()) {
                    Utils.showTitleCustom(Utils.format("DPS: {}M", Utils.formatDecimal((double)(KuudraHealth.calculateDPS() * 20.0f) * 1.0E-6)), 1, 25, 2.5f, KuudraHealth.color.value().hex);
                }
            }
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && Utils.isInKuudra() && dps.value() && KuudraUtil.getCurrentPhase() == KuudraUtil.phase.Lair && !Utils.isInstanceOver()) {
            float health = KuudraHealth.getTrueHealth(KuudraUtil.getKuudraEntity().method_6032());
            float damage = Math.clamp(previousHealth - health, 0.0f, 2.4E8f);
            dpsData.add(Float.valueOf(damage));
            if (dpsData.size() > 20) {
                dpsData.removeFirst();
            }
            previousHealth = health;
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        previousHealth = 0.0f;
        dpsData.clear();
    }
}

