/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.kuudra;

import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1570;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.events.EntityNamedEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.EntityCache;
import nofrills.misc.KuudraUtil;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;

public class KuudraWaypoints {
    public static final Feature instance = new Feature("kuudraWaypoints");
    public static final SettingBool supply = new SettingBool(false, "supply", instance.key());
    public static final SettingColor supplyColor = new SettingColor(new RenderColor(0, 255, 255, 170), "supplyColor", instance.key());
    public static final SettingBool drop = new SettingBool(false, "drop", instance.key());
    public static final SettingColor dropColor = new SettingColor(new RenderColor(255, 255, 0, 170), "dropColor", instance.key());
    public static final SettingBool build = new SettingBool(false, "build", instance.key());
    public static final SettingColor buildColor = new SettingColor(new RenderColor(255, 0, 0, 170), "buildColor", instance.key());
    private static final EntityCache supplies = new EntityCache();
    private static final EntityCache dropOffs = new EntityCache();
    private static final EntityCache buildPiles = new EntityCache();

    private static class_243 getGround(class_243 pos) {
        class_2338 blockPos = class_2338.method_49637((double)pos.method_10216(), (double)Math.max(pos.method_10214(), 75.0), (double)pos.method_10215());
        class_2338 ground = Utils.findGround(blockPos, 4);
        return new class_243(pos.method_10216(), ground.method_46558().method_1031(0.0, 0.5, 0.0).method_10214(), pos.method_10215());
    }

    private static boolean hasName(class_1297 ent, String name) {
        return ent.method_5807() && ent.method_5797() != null && Utils.toPlainString(ent.method_5797()).endsWith(name);
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        if (instance.isActive() && Utils.isInKuudra()) {
            if (drop.value() && event.namePlain.equals("BRING SUPPLY CHEST HERE")) {
                dropOffs.add(event.entity);
            }
            if (build.value() && event.namePlain.startsWith("PROGRESS: ") && event.namePlain.endsWith("%")) {
                buildPiles.add(event.entity);
            }
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && Utils.isInKuudra() && supply.value() && KuudraUtil.getCurrentPhase().equals((Object)KuudraUtil.phase.Collect)) {
            for (class_1297 ent : Utils.getEntities()) {
                if (!(ent instanceof class_1570)) continue;
                supplies.add(ent);
            }
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && Utils.isInKuudra()) {
            if (!supplies.empty() && KuudraUtil.getCurrentPhase().equals((Object)KuudraUtil.phase.Collect)) {
                for (class_1297 supply : supplies.get()) {
                    float delta = event.tickCounter.method_60637(true);
                    class_243 pos = supply.method_30950(delta);
                    float yaw = supply.method_5705(delta);
                    class_243 supplyPos = new class_243(pos.method_10216() + 3.7 * Math.cos((double)(yaw + 130.0f) * (Math.PI / 180)), 75.0, pos.method_10215() + 3.7 * Math.sin((double)(yaw + 130.0f) * (Math.PI / 180)));
                    event.drawBeam(supplyPos, 256, true, supplyColor.value());
                }
            }
            if (!dropOffs.empty()) {
                for (class_1297 drop : dropOffs.get()) {
                    if (KuudraWaypoints.hasName(drop, "BRING SUPPLY CHEST HERE")) {
                        event.drawBeam(KuudraWaypoints.getGround(drop.method_19538()), 256, true, dropColor.value());
                        continue;
                    }
                    dropOffs.remove(drop);
                }
            }
            if (!buildPiles.empty()) {
                for (class_1297 pile : buildPiles.get()) {
                    if (KuudraWaypoints.hasName(pile, "%")) {
                        event.drawBeam(KuudraWaypoints.getGround(pile.method_30950(event.tickCounter.method_60637(true))), 256, true, buildColor.value());
                        continue;
                    }
                    buildPiles.remove(pile);
                }
            }
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        supplies.clear();
        dropOffs.clear();
        buildPiles.clear();
    }
}

