/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.mining;

import java.util.Arrays;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingString;
import nofrills.events.ChatMsgEvent;
import nofrills.events.ServerTickEvent;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class BetterSkyMall {
    public static final Feature instance = new Feature("betterSkyMall");
    public static final SettingString whitelist = new SettingString("titanium, goblins", "whitelist", instance.key());
    private static int skyMallTicks = 0;
    private static boolean skyMallInbound = false;
    private static String skyMallBuff = "";

    private static boolean isWearingMiningPiece() {
        for (class_1799 armor : Utils.getEntityArmor((class_1309)Main.mc.field_1724)) {
            if (!Utils.hasEitherStat(armor, "Mining Speed", "Mining Fortune", "Block Fortune")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBuffWhitelisted(String buff) {
        if (!whitelist.value().isEmpty()) {
            return Arrays.stream(whitelist.value().split(",")).anyMatch(keyword -> Utils.toLower(buff).contains(Utils.toLower(keyword).trim()));
        }
        return false;
    }

    private static boolean isMonth(String line) {
        return line.contains("Spring") || line.contains("Summer") || line.contains("Autumn") || line.contains("Winter");
    }

    private static String getSkyblockDay() {
        return SkyblockData.getLines().stream().filter(BetterSkyMall::isMonth).findFirst().orElse("Unknown Day").trim();
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && skyMallTicks > 0 && --skyMallTicks == 0) {
            Utils.info("\u00a72Sky Mall \u00a7ebuff for \u00a7b" + BetterSkyMall.getSkyblockDay() + "\u00a7e: " + skyMallBuff);
        }
    }

    @EventHandler
    private static void onChat(ChatMsgEvent event) {
        if (Main.mc.field_1724 != null && instance.isActive()) {
            if (event.messagePlain.equals("New day! Your Sky Mall buff changed!")) {
                skyMallInbound = true;
                event.cancel();
            }
            if (event.messagePlain.equals("You can disable this messaging by toggling Sky Mall in your /hotm!")) {
                event.cancel();
            }
            if (event.messagePlain.startsWith("New buff: ") && skyMallInbound) {
                String message = event.messagePlain.replace("New buff:", "").trim();
                if (BetterSkyMall.isWearingMiningPiece() || BetterSkyMall.isBuffWhitelisted(message)) {
                    skyMallBuff = message;
                    skyMallTicks = 50;
                }
                skyMallInbound = false;
                event.cancel();
            }
        }
    }
}

