/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.mining;

import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.events.ChatMsgEvent;
import nofrills.events.EntityNamedEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.misc.EntityCache;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class ScathaMining {
    public static final Feature instance = new Feature("scathaMining");
    public static final SettingBool alert = new SettingBool(false, "alert", instance.key());
    public static final SettingBool cooldown = new SettingBool(false, "cooldown", instance.key());
    private static final EntityCache wormsCache = new EntityCache();
    private static int spawnCooldown = 0;

    private static boolean active() {
        return SkyblockData.getArea().equals("Crystal Hollows") && instance.isActive();
    }

    private static wormType getWormType(String name) {
        if (name.endsWith(Utils.Symbols.heart)) {
            if (name.startsWith("[Lv10] Scatha ")) {
                return wormType.Scatha;
            }
            if (name.startsWith("[Lv5] Worm ")) {
                return wormType.Worm;
            }
        }
        return wormType.None;
    }

    private static void alertSpawn(boolean scatha) {
        if (scatha) {
            Utils.showTitle("\u00a7cScatha", "\u00a77GOLD GOLD GOLD!", 5, 20, 5);
            Utils.playSound((class_6880.class_6883<class_3414>)class_3417.field_14622, class_3419.field_15250, 1.0f, 1.0f);
        } else {
            Utils.showTitle("\u00a7eWorm", "\u00a77Drops Hytale", 5, 20, 5);
            Utils.playSound((class_6880.class_6883<class_3414>)class_3417.field_14624, class_3419.field_15250, 1.0f, 0.0f);
        }
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        wormType type2;
        if (ScathaMining.active() && !(type2 = ScathaMining.getWormType(event.namePlain)).equals((Object)wormType.None) && !wormsCache.has(event.entity)) {
            if (alert.value()) {
                ScathaMining.alertSpawn(type2.equals((Object)wormType.Scatha));
            }
            wormsCache.add(event.entity);
        }
    }

    @EventHandler
    private static void onChat(ChatMsgEvent event) {
        if (ScathaMining.active() && event.messagePlain.equals("You hear the sound of something approaching...")) {
            spawnCooldown = 620;
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (spawnCooldown > 0 && --spawnCooldown == 0) {
            if (cooldown.value()) {
                Utils.showTitle("\u00a7a\u00a7lWORM COOLDOWN ENDED", "", 5, 20, 5);
                Utils.info("\u00a7a\u00a7lWorm spawn cooldown ended!");
                Utils.playSound((class_6880.class_6883<class_3414>)class_3417.field_15114, class_3419.field_15250, 1.0f, 0.0f);
            }
            wormsCache.removeDead();
        }
    }

    @EventHandler
    private static void onJoin(ServerJoinEvent event) {
        spawnCooldown = 0;
        wormsCache.clear();
    }

    private static enum wormType {
        Scatha,
        Worm,
        None;

    }
}

