/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.slayer;

import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import nofrills.config.Feature;
import nofrills.config.SettingColor;
import nofrills.config.SettingEnum;
import nofrills.events.EntityNamedEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.Rendering;
import nofrills.misc.SlayerUtil;
import nofrills.misc.Utils;

public class BossHighlight {
    public static final Feature instance = new Feature("bossHighlight");
    public static final SettingColor fillColor = new SettingColor(RenderColor.fromArgb(0x5500FFFF), "fillColor", instance.key());
    public static final SettingColor outlineColor = new SettingColor(RenderColor.fromArgb(-16711681), "outlineColor", instance.key());
    public static final SettingEnum<style> highlightStyle = new SettingEnum<style>(style.Both, style.class, "highlightStyle", instance.key());
    public static final SettingColor ashenFill = new SettingColor(RenderColor.fromArgb(0x55000000), "ashenFill", instance.key());
    public static final SettingColor ashenOutline = new SettingColor(RenderColor.fromArgb(-16777216), "ashenOutline", instance.key());
    public static final SettingColor spiritFill = new SettingColor(RenderColor.fromArgb(0x55FFFFFF), "spiritFill", instance.key());
    public static final SettingColor spiritOutline = new SettingColor(RenderColor.fromArgb(-1), "spiritOutline", instance.key());
    public static final SettingColor auricFill = new SettingColor(RenderColor.fromArgb(0x55FFFF00), "auricFill", instance.key());
    public static final SettingColor auricOutline = new SettingColor(RenderColor.fromArgb(-256), "auricOutline", instance.key());
    public static final SettingColor crystalFill = new SettingColor(RenderColor.fromArgb(0x5500FFFF), "crystalFill", instance.key());
    public static final SettingColor crystalOutline = new SettingColor(RenderColor.fromArgb(-16711681), "crystalOutline", instance.key());

    private static void highlightBlaze(class_1297 ent, String name) {
        String attunement = name.contains(" ") ? name.substring(0, name.indexOf(" ")) : "";
        List<class_1297> other = Utils.getOtherEntities(ent, 1.0, 3.0, 1.0, SlayerUtil.currentBoss.predicate);
        class_1297 owner = Utils.findNametagOwner(ent, other);
        if (owner != null) {
            BossHighlight.applyHighlight(owner, BossHighlight.getBlazeFillColor(attunement), BossHighlight.getBlazeOutlineColor(attunement));
        }
    }

    private static RenderColor getBlazeFillColor(String attunement) {
        return switch (attunement) {
            case "IMMUNE" -> null;
            case "ASHEN" -> ashenFill.value();
            case "SPIRIT" -> spiritFill.value();
            case "AURIC" -> auricFill.value();
            case "CRYSTAL" -> crystalFill.value();
            default -> fillColor.value();
        };
    }

    private static RenderColor getBlazeOutlineColor(String attunement) {
        return switch (attunement) {
            case "IMMUNE" -> null;
            case "ASHEN" -> ashenOutline.value();
            case "SPIRIT" -> spiritOutline.value();
            case "AURIC" -> auricOutline.value();
            case "CRYSTAL" -> crystalOutline.value();
            default -> outlineColor.value();
        };
    }

    private static void applyHighlight(class_1297 ent, RenderColor fillColor, RenderColor outlineColor) {
        if (!highlightStyle.value().equals((Object)style.Outline)) {
            Rendering.Entities.drawFilled(ent, fillColor != null, fillColor);
        }
        if (!highlightStyle.value().equals((Object)style.Filled)) {
            Rendering.Entities.drawOutline(ent, outlineColor != null, outlineColor);
        }
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        if (instance.isActive() && SlayerUtil.isFightingBoss(SlayerUtil.blaze) && SlayerUtil.isTimer(event.namePlain)) {
            BossHighlight.highlightBlaze(event.entity, event.namePlain);
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && !SlayerUtil.isFightingBoss(SlayerUtil.blaze)) {
            class_1309 boss = SlayerUtil.getBossEntity();
            if (boss == null) {
                return;
            }
            class_238 box = Utils.getLerpedBox((class_1297)boss, event.tickCounter.method_60637(true));
            if (!highlightStyle.value().equals((Object)style.Outline)) {
                event.drawFilled(box, false, fillColor.value());
            }
            if (!highlightStyle.value().equals((Object)style.Filled)) {
                event.drawOutline(box, false, outlineColor.value());
            }
        }
    }

    public static enum style {
        Outline,
        Filled,
        Both;

    }
}

