/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.slayer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import nofrills.config.Feature;
import nofrills.events.EntityNamedEvent;
import nofrills.events.PlaySoundEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.SlayerUtil;
import nofrills.misc.Utils;

public class PillarAlert {
    public static final Feature instance = new Feature("pillarAlert");
    private static final Pattern firePillarRegex = Pattern.compile("[0-9]s [0-9] hits");
    private static final List<class_243> pillarData = new ArrayList<class_243>();
    private static int pillarClearTicks = 0;

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        if (instance.isActive() && !pillarData.isEmpty() && firePillarRegex.matcher(event.namePlain).matches() && Utils.horizontalDistance(event.entity.method_19538(), pillarData.getLast()) <= 3.0f) {
            Utils.showTitleCustom("Pillar: " + event.namePlain, 30, 25, 4.0f, 0xFFFF00);
            pillarClearTicks = 60;
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (instance.isActive() && !SlayerUtil.bossAlive && pillarClearTicks > 0) {
            pillarData.clear();
            pillarClearTicks = 0;
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (instance.isActive() && SlayerUtil.isFightingBoss(SlayerUtil.blaze) && pillarClearTicks > 0 && --pillarClearTicks == 0) {
            pillarData.clear();
        }
    }

    @EventHandler
    private static void onSound(PlaySoundEvent event) {
        if (instance.isActive() && SlayerUtil.isFightingBoss(SlayerUtil.blaze) && event.isSound(class_3417.field_15219)) {
            class_1531 spawner = SlayerUtil.getSpawnerEntity();
            if (spawner == null) {
                return;
            }
            class_243 pos = new class_243(event.packet.method_11890(), event.packet.method_11889(), event.packet.method_11893());
            if (pillarData.isEmpty()) {
                if ((double)Utils.horizontalDistance(pos, spawner.method_19538()) <= 1.5) {
                    pillarData.add(pos);
                    pillarClearTicks = 60;
                }
            } else if (Utils.horizontalDistance(pos, pillarData.getLast()) <= 4.0f) {
                pillarData.add(pos);
                pillarClearTicks = 60;
            }
        }
    }
}

