/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.solvers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2596;
import net.minecraft.class_2813;
import net.minecraft.class_437;
import net.minecraft.class_476;
import nofrills.Main;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.events.ScreenOpenEvent;
import nofrills.events.SendPacketEvent;
import nofrills.events.SlotUpdateEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.SlotOptions;
import nofrills.misc.Utils;

public class ExperimentSolver {
    public static final Feature instance = new Feature("experimentSolver");
    public static final SettingBool chronomatron = new SettingBool(false, "chronomatron", instance.key());
    public static final SettingBool ultrasequencer = new SettingBool(false, "ultrasequencer", instance.key());
    public static final SettingBool superpairs = new SettingBool(false, "superpairs", instance.key());
    private static final List<Solution> chronoSolution = new ArrayList<Solution>();
    private static final List<Solution> ultraSolution = new ArrayList<Solution>();
    private static final RenderColor superColorFound = RenderColor.fromHex(65280, 0.5f);
    private static final RenderColor superColorPotential = RenderColor.fromHex(0xFFFF00, 0.5f);
    private static Solution superSolution = new Solution();
    private static boolean rememberPhase = true;

    private static void updatePhase(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!rememberPhase && item.equals(class_1802.field_8801)) {
            rememberPhase = true;
        }
        if (rememberPhase && item.equals(class_1802.field_8557)) {
            rememberPhase = false;
        }
    }

    public static ExperimentType getExperimentType() {
        class_437 class_4372;
        if (Utils.isOnPrivateIsland() && (class_4372 = Main.mc.field_1755) instanceof class_476) {
            class_476 container = (class_476)class_4372;
            String title = container.method_25440().getString();
            if (title.startsWith("Chronomatron (")) {
                return ExperimentType.Chronomatron;
            }
            if (title.startsWith("Ultrasequencer (")) {
                return ExperimentType.Ultrasequencer;
            }
            if (title.startsWith("Superpairs (")) {
                return ExperimentType.Superpairs;
            }
        }
        return ExperimentType.None;
    }

    private static boolean isStatus(class_1799 stack) {
        class_1792 item = stack.method_7909();
        String name = Utils.toPlainString(stack.method_7964());
        return item.equals(class_1802.field_8557) || item.equals(class_1802.field_8536) || item.equals(class_1802.field_8801) && !name.equals("Enchanted Book") || item.equals(class_1802.field_8638);
    }

    private static boolean isDye(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1769 || item.equals(class_1802.field_8794) || item.equals(class_1802.field_8324) || item.equals(class_1802.field_8759) || item.equals(class_1802.field_8116);
    }

    private static boolean isPowerup(class_1799 stack) {
        for (String line : Utils.getLoreLines(stack)) {
            if (!Utils.toLower(line).contains("powerup")) continue;
            return true;
        }
        return false;
    }

    private static boolean isTerracotta(class_1799 stack) {
        return stack.method_7909().toString().endsWith("terracotta");
    }

    private static boolean isStainedGlass(class_1799 stack) {
        return stack.method_7909().toString().endsWith("stained_glass");
    }

    private static boolean isStainedGlassPane(class_1799 stack) {
        return stack.method_7909().toString().endsWith("stained_glass_pane");
    }

    private static List<class_1735> getContainerSlots(class_1707 handler) {
        class_1263 inventory = handler.method_7629();
        ArrayList<class_1735> slots = new ArrayList<class_1735>((Collection<class_1735>)handler.field_7761);
        slots.removeIf(slot -> inventory.method_5438(slot.field_7874).method_7960());
        return slots;
    }

    private static void showChronoSolution() {
        if (!chronoSolution.isEmpty()) {
            for (class_1735 solution : ExperimentSolver.chronoSolution.getFirst().slots) {
                SlotOptions.spoofSlot(solution, SlotOptions.first);
                SlotOptions.disableSlot(solution, false);
            }
        }
        if (chronoSolution.size() > 1) {
            Solution first = chronoSolution.getFirst();
            for (class_1735 solution : ExperimentSolver.chronoSolution.get((int)1).slots) {
                if (!first.slots.stream().noneMatch(slot -> slot.field_7874 == solution.field_7874)) continue;
                SlotOptions.spoofSlot(solution, SlotOptions.second);
                SlotOptions.disableSlot(solution, true);
            }
        }
    }

    private static void showUltraSolution() {
        if (!ultraSolution.isEmpty()) {
            Solution first = ultraSolution.getFirst();
            SlotOptions.spoofSlot(first.slot, SlotOptions.stackWithQuantity(SlotOptions.first, first.stack.method_7947()));
            SlotOptions.disableSlot(first.slot, false);
        }
        if (ultraSolution.size() > 1) {
            Solution second = ultraSolution.get(1);
            SlotOptions.spoofSlot(second.slot, SlotOptions.stackWithQuantity(SlotOptions.second, second.stack.method_7947()));
            SlotOptions.disableSlot(second.slot, true);
        }
    }

    private static boolean matchSuperStacks(class_1799 first, class_1799 second) {
        return first.method_7909().equals(second.method_7909()) && first.method_7964().getString().equals(second.method_7964().getString()) && first.method_7947() == second.method_7947() && Objects.equals(Utils.getTextureUrl(first), Utils.getTextureUrl(second));
    }

    @EventHandler
    private static void onSlotUpdate(SlotUpdateEvent event) {
        if (!instance.isActive() || event.isInventory) {
            return;
        }
        ExperimentType experimentType = ExperimentSolver.getExperimentType();
        if (experimentType.equals((Object)ExperimentType.None)) {
            return;
        }
        class_1792 item = event.stack.method_7909();
        class_1735 eventSlot = event.handler.method_7611(event.slotId);
        ExperimentSolver.updatePhase(event.stack);
        if (chronomatron.value() && experimentType.equals((Object)ExperimentType.Chronomatron)) {
            if (rememberPhase) {
                for (class_1735 class_17352 : ExperimentSolver.getContainerSlots(event.handler)) {
                    SlotOptions.disableSlot(class_17352, true);
                }
                if (ExperimentSolver.isTerracotta(event.stack)) {
                    if (chronoSolution.isEmpty()) {
                        chronoSolution.add(new Solution(new ArrayList<class_1735>()));
                    }
                    ExperimentSolver.chronoSolution.getLast().slots.add(eventSlot);
                } else if (ExperimentSolver.isStainedGlass(event.stack) && !chronoSolution.isEmpty() && ExperimentSolver.chronoSolution.getLast().slots.stream().anyMatch(slot -> slot.field_7874 == event.slotId)) {
                    chronoSolution.add(new Solution(new ArrayList<class_1735>()));
                }
            } else {
                if (ExperimentSolver.isStatus(event.stack)) {
                    return;
                }
                ExperimentSolver.showChronoSolution();
            }
        }
        if (ultrasequencer.value() && experimentType.equals((Object)ExperimentType.Ultrasequencer)) {
            if (item.equals(class_1802.field_8557)) {
                ultraSolution.sort(Comparator.comparingInt(s -> s.stack.method_7947()));
                ExperimentSolver.showUltraSolution();
            } else if (item.equals(class_1802.field_8801)) {
                ArrayList<Solution> solution = new ArrayList<Solution>();
                SlotOptions.clearSpoofedSlots();
                SlotOptions.clearDisabledSlots();
                for (class_1735 slot3 : ExperimentSolver.getContainerSlots(event.handler)) {
                    SlotOptions.disableSlot(slot3, true);
                    if (!ExperimentSolver.isDye(slot3.method_7677())) continue;
                    solution.add(new Solution(slot3.method_7677(), slot3));
                }
                ultraSolution.clear();
                ultraSolution.addAll(solution);
            }
        }
        if (!(!superpairs.value() || !experimentType.equals((Object)ExperimentType.Superpairs) || ExperimentSolver.isStatus(event.stack) || ExperimentSolver.isPowerup(event.stack) || ExperimentSolver.isStainedGlass(event.stack) || ExperimentSolver.isStainedGlassPane(event.stack) || item.equals(class_1802.field_8162))) {
            if (ExperimentSolver.superSolution.slot != null && ExperimentSolver.superSolution.slot != eventSlot && ExperimentSolver.matchSuperStacks(event.stack, ExperimentSolver.superSolution.slot.method_7677())) {
                SlotOptions.setBackground(eventSlot, superColorFound);
                SlotOptions.setBackground(ExperimentSolver.superSolution.slot, superColorFound);
            }
            for (Map.Entry entry : ExperimentSolver.superSolution.rewards.entrySet()) {
                if (SlotOptions.hasBackground(eventSlot) || eventSlot.equals(entry.getKey()) || !ExperimentSolver.matchSuperStacks(event.stack, (class_1799)entry.getValue())) continue;
                SlotOptions.setBackground(eventSlot, superColorPotential);
                SlotOptions.setBackground((class_1735)entry.getKey(), superColorPotential);
            }
            ExperimentSolver.superSolution.rewards.put(eventSlot, event.stack);
            ExperimentSolver.superSolution.slot = eventSlot;
            SlotOptions.spoofSlot(eventSlot, event.stack);
        }
    }

    @EventHandler
    private static void onScreen(ScreenOpenEvent event) {
        if (instance.isActive()) {
            rememberPhase = true;
            chronoSolution.clear();
            ultraSolution.clear();
            superSolution = new Solution();
        }
    }

    @EventHandler
    private static void onSendPacket(SendPacketEvent event) {
        class_2596<?> class_25962;
        if (instance.isActive() && (class_25962 = event.packet) instanceof class_2813) {
            Solution first;
            class_2813 clickPacket = (class_2813)class_25962;
            ExperimentType type2 = ExperimentSolver.getExperimentType();
            short slotId = clickPacket.comp_3844();
            if (chronomatron.value() && type2.equals((Object)ExperimentType.Chronomatron) && !rememberPhase) {
                if (!chronoSolution.isEmpty()) {
                    first = chronoSolution.getFirst();
                    if (first.slots.stream().anyMatch(slot -> slot.field_7874 == slotId)) {
                        for (class_1735 slot2 : first.slots) {
                            SlotOptions.clearSpoof(slot2);
                            SlotOptions.disableSlot(slot2, true);
                        }
                        chronoSolution.removeFirst();
                    }
                }
                ExperimentSolver.showChronoSolution();
            }
            if (ultrasequencer.value() && type2.equals((Object)ExperimentType.Ultrasequencer) && !rememberPhase) {
                if (!ultraSolution.isEmpty() && ExperimentSolver.ultraSolution.getFirst().slot.field_7874 == slotId) {
                    first = ultraSolution.getFirst();
                    SlotOptions.spoofSlot(first.slot, SlotOptions.stackWithQuantity(class_1802.field_8333.method_7854(), first.stack.method_7947()));
                    SlotOptions.disableSlot(first.slot, true);
                    ultraSolution.removeFirst();
                }
                ExperimentSolver.showUltraSolution();
            }
        }
    }

    public static enum ExperimentType {
        Chronomatron,
        Ultrasequencer,
        Superpairs,
        None;

    }

    private static class Solution {
        public ExperimentType type;
        public class_1799 stack;
        public class_1735 slot;
        public List<class_1735> slots;
        public ConcurrentHashMap<class_1735, class_1799> rewards;

        public Solution(class_1799 stack, class_1735 slot) {
            this.type = ExperimentType.Ultrasequencer;
            this.stack = stack;
            this.slot = slot;
        }

        public Solution(List<class_1735> slots) {
            this.type = ExperimentType.Chronomatron;
            this.slots = slots;
        }

        public Solution() {
            this.type = ExperimentType.Ultrasequencer;
            this.rewards = new ConcurrentHashMap();
            this.slot = null;
        }
    }
}

