/*
 * Decompiled with CFR 0.152.
 */
package nofrills.features.solvers;

import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import nofrills.config.Feature;
import nofrills.config.SettingColor;
import nofrills.events.EntityNamedEvent;
import nofrills.events.WorldRenderEvent;
import nofrills.misc.EntityCache;
import nofrills.misc.RenderColor;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class SpookyChests {
    public static final Feature instance = new Feature("spookyChests");
    public static final SettingColor color = new SettingColor(new RenderColor(1.0f, 0.67f, 0.0f, 0.67f), "color", instance.key());
    private static final EntityCache chestList = new EntityCache();

    private static boolean isSpooky() {
        for (String line : SkyblockData.getLines()) {
            if (!line.startsWith("Spooky Festival") || !line.contains(":")) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        String name;
        if (instance.isActive() && SpookyChests.isSpooky() && event.entity.method_5807() && ((name = Utils.toLower(event.namePlain)).equals("trick or treat?") || name.equals("party chest")) && !chestList.has(event.entity)) {
            Utils.showTitle("\u00a76\u00a7lCHEST SPAWNED!", "", 5, 20, 5);
            Utils.playSound(class_3417.field_48796, class_3419.field_15250, 1.0f, 1.0f);
            chestList.add(event.entity);
        }
    }

    @EventHandler
    private static void onRender(WorldRenderEvent event) {
        if (instance.isActive() && !chestList.empty()) {
            for (class_1297 chest : chestList.get()) {
                class_2338 pos = Utils.findGround(chest.method_24515(), 4).method_10086(1);
                event.drawFilledWithBeam(class_238.method_54784((class_2338)pos, (class_2338)pos), 256, true, color.value());
            }
        }
    }
}

