/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud;

import io.wispforest.owo.ui.hud.Hud;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_156;
import net.minecraft.class_2596;
import net.minecraft.class_2923;
import net.minecraft.class_2960;
import nofrills.Main;
import nofrills.events.EntityNamedEvent;
import nofrills.events.HudRenderEvent;
import nofrills.events.ReceivePacketEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.ServerTickEvent;
import nofrills.events.WorldTickEvent;
import nofrills.features.fishing.CapTracker;
import nofrills.hud.HudEditorScreen;
import nofrills.hud.HudElement;
import nofrills.hud.elements.Day;
import nofrills.hud.elements.FPS;
import nofrills.hud.elements.FishingBobber;
import nofrills.hud.elements.LagMeter;
import nofrills.hud.elements.Ping;
import nofrills.hud.elements.Power;
import nofrills.hud.elements.SeaCreatures;
import nofrills.hud.elements.ShardTrackerDisplay;
import nofrills.hud.elements.TPS;
import nofrills.misc.SkyblockData;
import nofrills.misc.Utils;

public class HudManager {
    private static final List<HudElement> elements = new ArrayList<HudElement>();
    public static FPS fpsElement = new FPS("\u00a7bFPS: \u00a7f0");
    public static TPS tpsElement = new TPS("\u00a7bTPS: \u00a7f20.00");
    public static Ping pingElement = new Ping("\u00a7bPing: \u00a7f0ms");
    public static Day dayElement = new Day("\u00a7bDay: \u00a7f0");
    public static SeaCreatures seaCreaturesElement = new SeaCreatures("\u00a73Sea Creatures: \u00a770");
    public static FishingBobber bobberElement = new FishingBobber("\u00a7cBobber: \u00a77Inactive");
    public static LagMeter lagMeterElement = new LagMeter("\u00a7cLast server tick was 0.00s ago");
    public static Power powerElement = new Power("\u00a7bPower: \u00a7f0");
    public static ShardTrackerDisplay shardTrackerElement = new ShardTrackerDisplay();

    public static boolean isEditingHud() {
        return Main.mc.field_1755 instanceof HudEditorScreen;
    }

    public static List<HudElement> getElements() {
        return elements;
    }

    public static void addNew(HudElement element) {
        elements.add(element);
    }

    public static double getDefaultX() {
        return 0.01;
    }

    public static double getDefaultY() {
        return 0.01 + 0.05 * (double)elements.size();
    }

    public static void registerElements() {
        for (HudElement element : elements) {
            class_2960 identifier = element.getIdentifier();
            if (identifier == null || Hud.hasComponent((class_2960)identifier)) continue;
            Hud.add((class_2960)identifier, () -> element);
        }
    }

    @EventHandler
    private static void onRenderHud(HudRenderEvent event) {
        if (!HudManager.isEditingHud()) {
            for (HudElement element : elements) {
                element.updatePosition();
            }
        }
    }

    @EventHandler
    private static void onJoinServer(ServerJoinEvent event) {
        pingElement.reset();
        tpsElement.reset();
        fpsElement.reset();
        lagMeterElement.setTickTime(0L);
        HudManager.bobberElement.hologram = null;
    }

    @EventHandler
    private static void onPing(ReceivePacketEvent event) {
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_2923) {
            class_2923 pingPacket = (class_2923)class_25962;
            if (HudManager.pingElement.instance.isActive()) {
                pingElement.setPing(class_156.method_658() - pingPacket.comp_2201());
                HudManager.pingElement.ticks = 20;
            }
        }
    }

    @EventHandler
    private static void onWorldTick(WorldTickEvent event) {
        if (HudManager.powerElement.instance.isActive()) {
            powerElement.setPower(SkyblockData.dungeonPower);
        }
        if (HudManager.dayElement.instance.isActive() && Main.mc.field_1687 != null) {
            dayElement.setDay(Main.mc.field_1687.method_28104().method_217() / 24000L);
        }
        if (HudManager.pingElement.instance.isActive() && HudManager.pingElement.ticks > 0) {
            --HudManager.pingElement.ticks;
            if (HudManager.pingElement.ticks == 0) {
                Utils.sendPingPacket();
            }
        }
        if (HudManager.tpsElement.instance.isActive() && HudManager.tpsElement.clientTicks > 0) {
            --HudManager.tpsElement.clientTicks;
            if (HudManager.tpsElement.clientTicks == 0) {
                tpsElement.setTps(HudManager.tpsElement.serverTicks);
                HudManager.tpsElement.clientTicks = 20;
                HudManager.tpsElement.serverTicks = 0;
            }
        }
        if (HudManager.seaCreaturesElement.instance.isActive()) {
            seaCreaturesElement.setCount(CapTracker.seaCreatures.size());
        }
        if (HudManager.bobberElement.instance.isActive() && Main.mc.field_1724 != null) {
            if (!(Main.mc.field_1724.field_7513 == null || HudManager.bobberElement.hologram != null && HudManager.bobberElement.hologram.method_5805())) {
                bobberElement.setActive();
            } else if (Main.mc.field_1724.field_7513 == null) {
                bobberElement.setInactive();
            }
        }
        if (HudManager.fpsElement.instance.isActive() && HudManager.fpsElement.ticks > 0) {
            --HudManager.fpsElement.ticks;
            if (HudManager.fpsElement.ticks == 0) {
                fpsElement.setFps(Main.mc.method_47599());
                HudManager.fpsElement.ticks = 20;
            }
        }
    }

    @EventHandler
    private static void onServerTick(ServerTickEvent event) {
        if (HudManager.lagMeterElement.instance.isActive()) {
            lagMeterElement.setTickTime(class_156.method_658());
        }
        if (HudManager.tpsElement.instance.isActive()) {
            ++HudManager.tpsElement.serverTicks;
        }
        if (HudManager.bobberElement.instance.isActive() && HudManager.bobberElement.timer.value() && HudManager.bobberElement.active) {
            ++HudManager.bobberElement.timerTicks;
        }
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        if (HudManager.bobberElement.instance.isActive() && event.namePlain.length() == 3 && (event.namePlain.equals("!!!") || event.namePlain.indexOf(".") == 1)) {
            HudManager.bobberElement.hologram = event.entity;
            bobberElement.setTimer(event.namePlain);
        }
    }
}

