/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud.clickgui;

import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import nofrills.Main;
import nofrills.config.SettingBool;
import nofrills.config.SettingColor;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.config.SettingInt;
import nofrills.config.SettingKeybind;
import nofrills.config.SettingString;
import nofrills.hud.clickgui.ClickGui;
import nofrills.hud.clickgui.components.EnumCollapsible;
import nofrills.hud.clickgui.components.FlatSlider;
import nofrills.hud.clickgui.components.FlatTextbox;
import nofrills.hud.clickgui.components.KeybindButton;
import nofrills.hud.clickgui.components.PlainLabel;
import nofrills.misc.RenderColor;
import org.jetbrains.annotations.NotNull;

public class Settings
extends BaseOwoScreen<FlowLayout> {
    public List<FlowLayout> settings;
    public class_2561 title = class_2561.method_43473();
    public ScrollContainer<FlowLayout> scroll;

    public Settings(List<FlowLayout> settings) {
        this.settings = settings;
    }

    private static ButtonComponent buildResetButton(Consumer<ButtonComponent> onPress) {
        ButtonComponent button = Components.button((class_2561)class_2561.method_43470((String)"Reset").method_54663(0xFFFFFF), onPress);
        button.positioning(Positioning.relative((int)100, (int)0));
        button.renderer((context, btn, delta) -> {
            context.method_25294(btn.method_46426(), btn.method_46427(), btn.method_46426() + btn.method_25368(), btn.method_46427() + btn.method_25364(), -15724528);
            context.method_49601(btn.method_46426(), btn.method_46427(), btn.method_25368(), btn.method_25364(), -1);
        });
        return button;
    }

    private static double roundDouble(double value) {
        return BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }

    private static int getSettingsHeight(List<Component> children) {
        int height = 0;
        for (Component child : children) {
            if (child instanceof ColorPicker) {
                ColorPicker picker = (ColorPicker)child;
                if (picker.sliderList.size() == 4) {
                    height += 90;
                    continue;
                }
                height += 70;
                continue;
            }
            if (child instanceof Description) {
                Description description = (Description)child;
                PlainLabel label = (PlainLabel)((Object)description.children().getLast());
                height += 10 + label.getTextHeight();
                continue;
            }
            height += 30;
        }
        return (int)Math.clamp((double)height, 30.0, (double)Main.mc.method_22683().method_4502() * 0.8);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (FlowLayout setting : this.settings) {
            for (Component child : setting.children()) {
                if (!(child instanceof KeybindButton)) continue;
                KeybindButton keybind = (KeybindButton)child;
                if (!keybind.isBinding) continue;
                keybind.bind(keyCode);
                return true;
            }
        }
        if (keyCode == 266 || keyCode == 267) {
            this.scroll.onMouseScroll(0.0, 0.0, keyCode == 266 ? 4.0 : -4.0);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scroll.onMouseScroll(0.0, 0.0, verticalAmount * 2.0);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (FlowLayout setting : this.settings) {
            for (Component child : setting.children()) {
                if (!(child instanceof KeybindButton)) continue;
                KeybindButton keybind = (KeybindButton)child;
                if (!keybind.isBinding) continue;
                keybind.bind(button);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout root) {
        root.surface(Surface.VANILLA_TRANSLUCENT);
        root.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        FlowLayout parent = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        parent.padding(Insets.of((int)5));
        Color textColor = Color.ofArgb((int)-1);
        FlowLayout settings = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        settings.surface(Surface.flat((int)-1442840576)).alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
        int width = 300;
        ArrayList<FlowLayout> optionsMutable = new ArrayList<FlowLayout>(this.settings);
        for (FlowLayout option : optionsMutable) {
            option.horizontalSizing(Sizing.fixed((int)width));
            settings.child((Component)option);
        }
        this.scroll = Containers.verticalScroll((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)Settings.getSettingsHeight(settings.children())), (Component)settings).scrollbarThiccness(5).scrollbar(ScrollContainer.Scrollbar.flat((Color)textColor));
        LabelComponent label = new PlainLabel(this.title).color(textColor).horizontalTextAlignment(HorizontalAlignment.CENTER).verticalTextAlignment(VerticalAlignment.CENTER);
        ParentComponent header = Containers.verticalFlow((Sizing)Sizing.fixed((int)width), (Sizing)Sizing.content()).child((Component)label).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).padding(Insets.of((int)3)).surface(Surface.flat((int)-10706753));
        parent.child((Component)header);
        parent.child(this.scroll);
        root.child((Component)parent);
    }

    public void method_25419() {
        Main.mc.method_1507((class_437)new ClickGui());
    }

    public Settings setTitle(class_2561 title) {
        this.title = title;
        return this;
    }

    public static class ColorPicker
    extends FlowLayout {
        public SettingColor setting;
        public List<FlatSlider> sliderList = new ArrayList<FlatSlider>();

        public ColorPicker(String name, boolean alpha, SettingColor setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.verticalAlignment(VerticalAlignment.CENTER);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.right((int)5)).verticalSizing(Sizing.fixed((int)20));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            FlowLayout colorDisplay = Containers.verticalFlow((Sizing)Sizing.fixed((int)20), (Sizing)Sizing.fixed((int)20));
            colorDisplay.surface(Surface.flat((int)this.setting.value().argb)).margins(Insets.right((int)10));
            FlowLayout colorSliders = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            for (int i = 0; i <= 3; ++i) {
                if (i == 3 && !alpha) continue;
                int id = i;
                FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
                PlainLabel colorLabel = new PlainLabel((class_2561)class_2561.method_43470((String)this.getColorLabel(id)).method_54663(0xFFFFFF));
                colorLabel.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.right((int)5)).verticalSizing(Sizing.fixed((int)20));
                FlatTextbox text = new FlatTextbox(Sizing.fixed((int)30));
                FlatSlider slider = new FlatSlider(-2236963, -10706753);
                slider.min(0.0).max(255.0).stepSize(1.0).horizontalSizing(Sizing.fixed((int)60)).verticalSizing(Sizing.fixed((int)20));
                this.sliderList.add(slider);
                text.onChanged().subscribe(change -> {
                    try {
                        int value = Integer.parseInt(text.method_1882());
                        this.setColorValue(id, (float)value / 255.0f);
                        slider.value(value);
                        colorDisplay.surface(Surface.flat((int)this.setting.value().argb));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
                text.text(String.valueOf((int)(this.getColorValue(id) * 255.0)));
                slider.onChanged().subscribe(change -> {
                    int value = (int)slider.value();
                    this.setColorValue(id, (float)value / 255.0f);
                    text.method_1852(String.valueOf(value));
                    colorDisplay.surface(Surface.flat((int)this.setting.value().argb));
                });
                row.child((Component)colorLabel);
                row.child((Component)text);
                row.child((Component)slider);
                colorSliders.child((Component)row);
            }
            this.child((Component)label);
            this.child((Component)colorDisplay);
            this.child((Component)colorSliders);
            this.child(Settings.buildResetButton(btn -> {
                this.setting.reset();
                for (int i = 0; i <= 3; ++i) {
                    if (i == 3 && !alpha) continue;
                    this.sliderList.get(i).value((int)(this.getColorValue(i) * 255.0));
                }
            }).positioning(Positioning.relative((int)100, (int)50)));
        }

        private String getColorLabel(int id) {
            return switch (id) {
                case 0 -> "R";
                case 1 -> "G";
                case 2 -> "B";
                case 3 -> "A";
                default -> "";
            };
        }

        private double getColorValue(int id) {
            RenderColor color = this.setting.value();
            return switch (id) {
                case 0 -> color.r;
                case 1 -> color.g;
                case 2 -> color.b;
                case 3 -> color.a;
                default -> 0.0;
            };
        }

        private void setColorValue(int id, double value) {
            RenderColor color = this.setting.value();
            RenderColor newColor = switch (id) {
                case 0 -> RenderColor.fromFloat((float)value, color.g, color.b, color.a);
                case 1 -> RenderColor.fromFloat(color.r, (float)value, color.b, color.a);
                case 2 -> RenderColor.fromFloat(color.r, color.g, (float)value, color.a);
                case 3 -> RenderColor.fromFloat(color.r, color.g, color.b, (float)value);
                default -> color;
            };
            this.setting.set(newColor);
        }
    }

    public static class Description
    extends FlowLayout {
        public Description(String name, String description) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.verticalAlignment(VerticalAlignment.CENTER);
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            PlainLabel desc = new PlainLabel((class_2561)class_2561.method_43470((String)description).method_54663(0xFFFFFF));
            desc.verticalTextAlignment(VerticalAlignment.CENTER).verticalSizing(Sizing.content()).horizontalSizing(Sizing.fixed((int)200));
            this.child((Component)label);
            this.child((Component)desc);
        }
    }

    public static class BigButton
    extends FlowLayout {
        public ButtonComponent button;

        public BigButton(String name, Consumer<ButtonComponent> onPress) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.CENTER);
            this.button = Components.button((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF), onPress);
            this.button.horizontalSizing(Sizing.fixed((int)290));
            this.button.renderer((context, btn, delta) -> {
                context.method_25294(btn.method_46426(), btn.method_46427(), btn.method_46426() + btn.method_25368(), btn.method_46427() + btn.method_25364(), -15724528);
                context.method_49601(btn.method_46426(), btn.method_46427(), btn.method_25368(), btn.method_25364(), -10706753);
            });
            this.child((Component)this.button);
        }
    }

    public static class Keybind
    extends FlowLayout {
        public SettingKeybind setting;
        public KeybindButton button;

        public Keybind(String name, SettingKeybind setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            this.button = new KeybindButton();
            this.button.bind(this.setting.value());
            this.button.onBound().subscribe(keycode -> this.setting.set(keycode));
            this.child((Component)label);
            this.child((Component)this.button);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                this.button.bind(this.setting.value());
            }));
        }
    }

    public static class TextInput
    extends FlowLayout {
        public SettingString setting;

        public TextInput(String name, SettingString setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            FlatTextbox text = new FlatTextbox(Sizing.fixed((int)150));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            text.onChanged().subscribe(change -> this.setting.set(text.method_1882()));
            text.text(String.valueOf(this.setting.value()));
            this.child((Component)label);
            this.child((Component)text);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                text.method_1852(String.valueOf(this.setting.value()));
            }));
        }
    }

    public static class Separator
    extends FlowLayout {
        public Separator(String name) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.CENTER);
            this.verticalAlignment(VerticalAlignment.CENTER);
            this.verticalSizing(Sizing.fixed((int)30));
            class_5250 text = class_2561.method_43470((String)name);
            int textWidth = Main.mc.field_1772.method_27525((class_5348)text) / 2;
            PlainLabel label = new PlainLabel((class_2561)text.method_54663(0xFFFFFF));
            label.verticalTextAlignment(VerticalAlignment.CENTER).verticalSizing(Sizing.fixed((int)30));
            this.surface((context, component) -> {
                int centerX = component.x() + component.width() / 2;
                int centerY = component.y() + component.height() / 2;
                context.method_25294(component.x(), centerY - 1, centerX - textWidth - 5, centerY + 1, -1);
                context.method_25294(centerX + textWidth + 5, centerY - 1, component.x() + component.width(), centerY + 1, -1);
            });
            this.child((Component)label);
        }
    }

    public static class Dropdown<T extends Enum<T>>
    extends FlowLayout {
        public SettingEnum<T> setting;

        public Dropdown(String name, SettingEnum<T> setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            EnumCollapsible dropdown = new EnumCollapsible(((Enum)this.setting.value()).name());
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            dropdown.surface(Surface.flat((int)-15724528).and(Surface.outline((int)-10706753)));
            for (Object value : this.setting.values) {
                ButtonComponent button = Components.button((class_2561)class_2561.method_30163((String)((Enum)value).name()), btn -> {
                    dropdown.setLabel(value.name());
                    this.setting.set((Enum)value);
                    dropdown.toggleExpansion();
                });
                button.sizing(Sizing.content(), Sizing.fixed((int)12));
                button.renderer((context, btn, delta) -> {});
                dropdown.child((Component)button);
            }
            this.child((Component)label);
            this.child((Component)dropdown);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                dropdown.setLabel(((Enum)this.setting.value()).name());
            }));
        }
    }

    public static class SliderInt
    extends FlowLayout {
        public SettingInt setting;

        public SliderInt(String name, int min, int max, int step, SettingInt setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            FlatTextbox text = new FlatTextbox(Sizing.fixed((int)50));
            FlatSlider slider = new FlatSlider(-2236963, -10706753);
            slider.min(min).max((double)max).stepSize((double)step).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            text.onChanged().subscribe(change -> {
                try {
                    int value = Integer.parseInt(text.method_1882());
                    this.setting.set(value);
                    slider.value(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            text.text(String.valueOf(this.setting.value()));
            slider.onChanged().subscribe(change -> {
                int value = (int)slider.value();
                this.setting.set(value);
                text.method_1852(String.valueOf(value));
            });
            this.child((Component)label);
            this.child((Component)text);
            this.child((Component)slider);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                text.method_1852(String.valueOf(this.setting.value()));
            }));
        }
    }

    public static class SliderDouble
    extends FlowLayout {
        public SettingDouble setting;

        public SliderDouble(String name, double min, double max, double step, SettingDouble setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            FlatTextbox text = new FlatTextbox(Sizing.fixed((int)50));
            FlatSlider slider = new FlatSlider(-2236963, -10706753);
            slider.min(min).max(max).stepSize(step).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20));
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            text.onChanged().subscribe(change -> {
                try {
                    double value = Double.parseDouble(text.method_1882());
                    this.setting.set(value);
                    slider.value(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            text.text(String.valueOf(this.setting.value()));
            slider.onChanged().subscribe(change -> {
                double value = Settings.roundDouble(slider.value());
                this.setting.set(value);
                text.method_1852(String.valueOf(value));
            });
            this.child((Component)label);
            this.child((Component)text);
            this.child((Component)slider);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                text.method_1852(String.valueOf(Settings.roundDouble(this.setting.value())));
            }));
        }
    }

    public static class Toggle
    extends FlowLayout {
        public boolean active = false;
        public SettingBool setting;
        public class_2561 enabledText;
        public class_2561 disabledText;
        public ButtonComponent toggle;

        public Toggle(String name, SettingBool setting, String tooltip) {
            super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
            this.padding(Insets.of((int)5));
            this.horizontalAlignment(HorizontalAlignment.LEFT);
            this.setting = setting;
            this.enabledText = class_2561.method_43470((String)"Enabled").method_54663(0x55FF55);
            this.disabledText = class_2561.method_43470((String)"Disabled").method_54663(0xFF5555);
            PlainLabel label = new PlainLabel((class_2561)class_2561.method_43470((String)name).method_54663(0xFFFFFF));
            label.tooltip((class_2561)class_2561.method_43470((String)tooltip));
            this.toggle = Components.button((class_2561)class_2561.method_43473(), button -> {
                boolean value = this.setting.value();
                this.active(!value);
            });
            this.toggle.renderer((context, button, delta) -> {
                context.method_25294(button.method_46426(), button.method_46427(), button.method_46426() + button.method_25368(), button.method_46427() + button.method_25364(), -15724528);
                context.method_49601(button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), -10706753);
            });
            label.verticalTextAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)0, (int)0, (int)5)).verticalSizing(Sizing.fixed((int)20));
            this.active(this.setting.value());
            this.child((Component)label);
            this.child((Component)this.toggle);
            this.child((Component)Settings.buildResetButton(btn -> {
                this.setting.reset();
                this.active(this.setting.value());
            }));
        }

        private void active(boolean active) {
            if (active) {
                this.toggle.method_25355(this.enabledText);
            } else {
                this.toggle.method_25355(this.disabledText);
            }
            this.setting.set(active);
            this.active = active;
        }
    }
}

