/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud.elements;

import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.hud.HudManager;
import nofrills.hud.HudSettings;
import nofrills.hud.SimpleTextElement;
import nofrills.hud.clickgui.Settings;
import nofrills.misc.Utils;

public class FishingBobber
extends SimpleTextElement {
    public final Feature instance = new Feature("bobberElement");
    public final SettingDouble x;
    public final SettingDouble y;
    public final SettingBool shadow = new SettingBool(true, "shadow", this.instance.key());
    public final SettingEnum<SimpleTextElement.alignment> align = new SettingEnum<SimpleTextElement.alignment>(SimpleTextElement.alignment.Left, SimpleTextElement.alignment.class, "align", this.instance.key());
    public final SettingBool inactive = new SettingBool(false, "inactive", this.instance.key());
    public final SettingBool timer = new SettingBool(false, "timer", this.instance.key());
    private final class_2960 identifier = class_2960.method_60655((String)"nofrills", (String)"bobber-element");
    public class_1297 hologram = null;
    public int timerTicks = 0;
    public boolean active = false;
    public String currentText = "\u00a7cBobber: \u00a77Inactive";

    public FishingBobber(String text, double x, double y) {
        super((class_2561)class_2561.method_43470((String)text));
        this.x = new SettingDouble(x, "x", this.instance.key());
        this.y = new SettingDouble(y, "y", this.instance.key());
        this.options = new HudSettings(List.of(new Settings.Toggle("Shadow", this.shadow, "Adds a shadow to the element's text."), new Settings.Dropdown<SimpleTextElement.alignment>("Alignment", this.align, "The alignment of the element's text."), new Settings.Toggle("Hide If Inactive", this.inactive, "Hides the element if your fishing bobber is inactive."), new Settings.Toggle("Bobber Timer", this.timer, "Tracks how long your fishing bobber has existed for, useful for Slugfish.")));
        this.options.setTitle(class_2561.method_30163((String)"Bobber Element"));
    }

    public FishingBobber(String text) {
        this(text, HudManager.getDefaultX(), HudManager.getDefaultY());
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (HudManager.isEditingHud()) {
            this.layout.surface(this.instance.isActive() ? Surface.BLANK : this.disabledSurface);
        } else {
            if (!this.instance.isActive()) {
                return;
            }
            if (this.inactive.value() && !this.active) {
                return;
            }
        }
        if (this.timer.value()) {
            this.setText(Utils.format("{} \u00a77{}s", this.currentText, Utils.formatDecimal((double)this.timerTicks / 20.0, 1)));
        } else {
            this.setText(this.currentText);
        }
        this.updateShadow(this.shadow);
        this.updateAlignment(this.align);
        super.draw(context, mouseX, mouseY, partialTicks, delta);
    }

    private void updateText(String text) {
        this.currentText = text;
    }

    public void setActive() {
        this.updateText("\u00a7cBobber: \u00a7aActive");
        this.active = true;
    }

    public void setInactive() {
        this.updateText("\u00a7cBobber: \u00a77Inactive");
        this.timerTicks = 0;
        this.active = false;
    }

    public void setTimer(String timer) {
        if (timer.equals("!!!")) {
            this.updateText("\u00a7cBobber: \u00a7c\u00a7lReel!");
        } else {
            this.updateText(Utils.format("\u00a7cBobber: \u00a7e\u00a7l{}", timer));
        }
        this.active = true;
    }

    @Override
    public void toggle() {
        this.instance.setActive(!this.instance.isActive());
    }

    @Override
    public void updatePosition() {
        this.updatePosition(this.x, this.y);
    }

    @Override
    public void savePosition(double x, double y) {
        this.x.set(x);
        this.y.set(y);
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }
}

