/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud.elements;

import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.config.SettingInt;
import nofrills.hud.HudManager;
import nofrills.hud.HudSettings;
import nofrills.hud.SimpleTextElement;
import nofrills.hud.clickgui.Settings;
import nofrills.misc.Utils;

public class LagMeter
extends SimpleTextElement {
    public final Feature instance = new Feature("lagMeterElement");
    public final SettingDouble x;
    public final SettingDouble y;
    public final SettingBool shadow = new SettingBool(true, "shadow", this.instance.key());
    public final SettingEnum<SimpleTextElement.alignment> align = new SettingEnum<SimpleTextElement.alignment>(SimpleTextElement.alignment.Left, SimpleTextElement.alignment.class, "align", this.instance.key());
    public final SettingInt min = new SettingInt(500, "min", this.instance.key());
    private final class_2960 identifier = class_2960.method_60655((String)"nofrills", (String)"lag-meter-element");
    public long lastTick = 0L;

    public LagMeter(String text, double x, double y) {
        super((class_2561)class_2561.method_43470((String)text));
        this.x = new SettingDouble(x, "x", this.instance.key());
        this.y = new SettingDouble(y, "y", this.instance.key());
        this.options = new HudSettings(List.of(new Settings.Toggle("Shadow", this.shadow, "Adds a shadow to the element's text."), new Settings.Dropdown<SimpleTextElement.alignment>("Alignment", this.align, "The alignment of the element's text."), new Settings.SliderInt("Minimum Time", 0, 5000, 50, this.min, "The minimum amount of time (in milliseconds) since the last tick for the element to be visible.")));
        this.options.setTitle(class_2561.method_30163((String)"Lag Meter Element"));
    }

    public LagMeter(String text) {
        this(text, HudManager.getDefaultX(), HudManager.getDefaultY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (HudManager.isEditingHud()) {
            this.layout.surface(this.instance.isActive() ? Surface.BLANK : this.disabledSurface);
        } else {
            if (!this.instance.isActive()) {
                return;
            }
            if (this.lastTick == 0L) return;
            long sinceTick = class_156.method_658() - this.lastTick;
            if (sinceTick < (long)this.min.value()) return;
            this.setText(Utils.format("\u00a7cLast server tick was {}s ago", Utils.formatDecimal((double)sinceTick * 0.001)));
        }
        this.updateShadow(this.shadow);
        this.updateAlignment(this.align);
        super.draw(context, mouseX, mouseY, partialTicks, delta);
    }

    public void setTickTime(long time) {
        this.lastTick = time;
    }

    @Override
    public void toggle() {
        this.instance.setActive(!this.instance.isActive());
    }

    @Override
    public void updatePosition() {
        this.updatePosition(this.x, this.y);
    }

    @Override
    public void savePosition(double x, double y) {
        this.x.set(x);
        this.y.set(y);
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }
}

