/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud.elements;

import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.hud.HudManager;
import nofrills.hud.HudSettings;
import nofrills.hud.SimpleTextElement;
import nofrills.hud.clickgui.Settings;
import nofrills.misc.Utils;

public class Power
extends SimpleTextElement {
    public final Feature instance = new Feature("powerElement");
    public final SettingDouble x;
    public final SettingDouble y;
    public final SettingBool shadow = new SettingBool(true, "shadow", this.instance.key());
    public final SettingEnum<SimpleTextElement.alignment> align = new SettingEnum<SimpleTextElement.alignment>(SimpleTextElement.alignment.Left, SimpleTextElement.alignment.class, "align", this.instance.key());
    public final SettingBool dungeon = new SettingBool(true, "dungeon", this.instance.key());
    private final class_2960 identifier = class_2960.method_60655((String)"nofrills", (String)"power-element");

    public Power(String text, double x, double y) {
        super((class_2561)class_2561.method_43470((String)text));
        this.x = new SettingDouble(x, "x", this.instance.key());
        this.y = new SettingDouble(y, "y", this.instance.key());
        this.options = new HudSettings(List.of(new Settings.Toggle("Shadow", this.shadow, "Adds a shadow to the element's text."), new Settings.Dropdown<SimpleTextElement.alignment>("Alignment", this.align, "The alignment of the element's text."), new Settings.Toggle("Dungeons Only", this.dungeon, "Hides the element outside of Dungeons.")));
        this.options.setTitle(class_2561.method_30163((String)"Power Element"));
    }

    public Power(String text) {
        this(text, HudManager.getDefaultX(), HudManager.getDefaultY());
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (HudManager.isEditingHud()) {
            this.layout.surface(this.instance.isActive() ? Surface.BLANK : this.disabledSurface);
        } else {
            if (!this.instance.isActive()) {
                return;
            }
            if (this.dungeon.value() && !Utils.isInDungeons()) {
                return;
            }
        }
        this.updateShadow(this.shadow);
        this.updateAlignment(this.align);
        super.draw(context, mouseX, mouseY, partialTicks, delta);
    }

    public void setPower(double power) {
        this.setText(Utils.format("\u00a7bPower: \u00a7f{}", power));
    }

    @Override
    public void toggle() {
        this.instance.setActive(!this.instance.isActive());
    }

    @Override
    public void updatePosition() {
        this.updatePosition(this.x, this.y);
    }

    @Override
    public void savePosition(double x, double y) {
        this.x.set(x);
        this.y.set(y);
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }
}

