/*
 * Decompiled with CFR 0.152.
 */
package nofrills.hud.elements;

import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Surface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import nofrills.config.Feature;
import nofrills.config.SettingBool;
import nofrills.config.SettingDouble;
import nofrills.config.SettingEnum;
import nofrills.hud.HudManager;
import nofrills.hud.HudSettings;
import nofrills.hud.SimpleTextElement;
import nofrills.hud.clickgui.Settings;
import nofrills.misc.Utils;

public class TPS
extends SimpleTextElement {
    public final Feature instance = new Feature("tpsElement");
    public final SettingDouble x;
    public final SettingDouble y;
    public final SettingBool shadow = new SettingBool(true, "shadow", this.instance.key());
    public final SettingEnum<SimpleTextElement.alignment> align = new SettingEnum<SimpleTextElement.alignment>(SimpleTextElement.alignment.Left, SimpleTextElement.alignment.class, "align", this.instance.key());
    public final SettingBool average = new SettingBool(false, "average", this.instance.key());
    private final class_2960 identifier = class_2960.method_60655((String)"nofrills", (String)"tps-element");
    public int clientTicks = 20;
    public int serverTicks = 0;
    public List<Integer> tpsList = new ArrayList<Integer>();

    public TPS(String text, double x, double y) {
        super((class_2561)class_2561.method_43470((String)text));
        this.x = new SettingDouble(x, "x", this.instance.key());
        this.y = new SettingDouble(y, "y", this.instance.key());
        this.options = new HudSettings(List.of(new Settings.Toggle("Shadow", this.shadow, "Adds a shadow to the element's text."), new Settings.Dropdown<SimpleTextElement.alignment>("Alignment", this.align, "The alignment of the element's text."), new Settings.Toggle("Average", this.average, "Tracks and adds the average TPS to the element.")));
        this.options.setTitle(class_2561.method_30163((String)"TPS Element"));
    }

    public TPS(String text) {
        this(text, HudManager.getDefaultX(), HudManager.getDefaultY());
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (HudManager.isEditingHud()) {
            this.layout.surface(this.instance.isActive() ? Surface.BLANK : this.disabledSurface);
        } else if (!this.instance.isActive()) {
            return;
        }
        this.updateShadow(this.shadow);
        this.updateAlignment(this.align);
        super.draw(context, mouseX, mouseY, partialTicks, delta);
    }

    public void setTps(int tps) {
        if (this.average.value()) {
            if (this.tpsList.size() > 30) {
                this.tpsList.removeFirst();
            }
            this.tpsList.add(Math.clamp((long)tps, 0, 20));
            int avg = 0;
            for (int previous : this.tpsList) {
                avg += previous;
            }
            this.setText(Utils.format("\u00a7bTPS: \u00a7f{} \u00a77{}", tps, Utils.formatDecimal((double)avg / (double)this.tpsList.size())));
        } else {
            this.setText(Utils.format("\u00a7bTPS: \u00a7f{}", tps));
        }
    }

    public void reset() {
        this.clientTicks = 20;
        this.serverTicks = 0;
        this.tpsList.clear();
        this.setText("\u00a7bTPS: \u00a7f0");
    }

    @Override
    public void updatePosition() {
        this.updatePosition(this.x, this.y);
    }

    @Override
    public void toggle() {
        this.instance.setActive(!this.instance.isActive());
    }

    @Override
    public void savePosition(double x, double y) {
        this.x.set(x);
        this.y.set(y);
    }

    @Override
    public class_2960 getIdentifier() {
        return this.identifier;
    }
}

