/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.orbit.EventHandler;
import nofrills.Main;
import nofrills.events.WorldTickEvent;
import nofrills.features.general.PriceTooltips;
import nofrills.features.kuudra.KuudraChestValue;
import nofrills.misc.Utils;

public class NoFrillsAPI {
    public static final ConcurrentHashMap<String, Long> auctionPricing = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, HashMap<String, Double>> bazaarPricing = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, HashMap<String, Double>> npcPricing = new ConcurrentHashMap();
    private static int refreshTicks = 0;

    private static boolean shouldRefresh() {
        return PriceTooltips.instance.isActive() || KuudraChestValue.instance.isActive();
    }

    private static void refreshItemPricing() {
        new Thread(() -> {
            try {
                HashMap<String, Double> pricing;
                JsonObject object;
                InputStream connection = URI.create("https://whatyouth.ing/api/nofrills/v2/economy/get-item-pricing/").toURL().openStream();
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(connection)).getAsJsonObject();
                for (Map.Entry entry : json.getAsJsonObject("auction").asMap().entrySet()) {
                    auctionPricing.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                }
                for (Map.Entry entry : json.getAsJsonObject("bazaar").asMap().entrySet()) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    pricing = new HashMap<String, Double>();
                    pricing.put("buy", object.get("buy").getAsDouble());
                    pricing.put("sell", object.get("sell").getAsDouble());
                    bazaarPricing.put((String)entry.getKey(), pricing);
                }
                for (Map.Entry entry : json.getAsJsonObject("npc").asMap().entrySet()) {
                    object = ((JsonElement)entry.getValue()).getAsJsonObject();
                    pricing = new HashMap();
                    if (object.has("coin")) {
                        pricing.put("coin", object.get("coin").getAsDouble());
                    }
                    if (object.has("mote")) {
                        pricing.put("mote", object.get("mote").getAsDouble());
                    }
                    if (pricing.isEmpty()) continue;
                    npcPricing.put((String)entry.getKey(), pricing);
                }
            }
            catch (IOException exception) {
                StringBuilder trace = new StringBuilder();
                for (StackTraceElement element : exception.getStackTrace()) {
                    trace.append("\n\tat ").append(element.toString());
                }
                Main.LOGGER.error("{}{}", (Object)exception.getMessage(), (Object)trace);
            }
        }).start();
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (NoFrillsAPI.shouldRefresh() && Utils.isInSkyblock()) {
            if (refreshTicks == 0) {
                if (Main.mc.method_1569()) {
                    NoFrillsAPI.refreshItemPricing();
                    refreshTicks = 1200;
                }
            } else {
                --refreshTicks;
            }
        }
    }
}

