/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import io.wispforest.owo.ui.core.Color;
import net.minecraft.class_9848;

public class RenderColor {
    public static final RenderColor white = RenderColor.fromHex(0xFFFFFF);
    public static final RenderColor green = RenderColor.fromHex(0x55FF55);
    public static final RenderColor darkGray = RenderColor.fromHex(0x202020);
    public float r;
    public float g;
    public float b;
    public float a;
    public int hex;
    public int argb;

    public RenderColor(int r, int g, int b, int a) {
        this.r = (float)Math.clamp((long)r, 0, 255) / 255.0f;
        this.g = (float)Math.clamp((long)g, 0, 255) / 255.0f;
        this.b = (float)Math.clamp((long)b, 0, 255) / 255.0f;
        this.a = (float)Math.clamp((long)a, 0, 255) / 255.0f;
        this.hex = (Math.clamp((long)r, 0, 255) << 16) + (Math.clamp((long)g, 0, 255) << 8) + Math.clamp((long)b, 0, 255);
        this.argb = class_9848.method_61324((int)Math.clamp((long)a, 0, 255), (int)Math.clamp((long)r, 0, 255), (int)Math.clamp((long)g, 0, 255), (int)Math.clamp((long)b, 0, 255));
    }

    public RenderColor(float r, float g, float b, float a) {
        this.r = Math.clamp(r, 0.0f, 1.0f);
        this.g = Math.clamp(g, 0.0f, 1.0f);
        this.b = Math.clamp(b, 0.0f, 1.0f);
        this.a = Math.clamp(a, 0.0f, 1.0f);
        this.hex = ((int)this.r * 255 << 16) + ((int)this.g * 255 << 8) + (int)this.b * 255;
        this.argb = class_9848.method_61318((float)this.a, (float)this.r, (float)this.g, (float)this.b);
    }

    public static RenderColor fromHex(int hex) {
        return new RenderColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, 255);
    }

    public static RenderColor fromArgb(int hex) {
        return new RenderColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, hex >> 24 & 0xFF);
    }

    public static RenderColor fromHex(int hex, float alpha) {
        return new RenderColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, (int)(255.0f * alpha));
    }

    public static RenderColor fromColor(Color color) {
        return RenderColor.fromHex(color.rgb(), color.alpha());
    }

    public static RenderColor fromFloat(float r, float g, float b, float a) {
        return new RenderColor(r, g, b, a);
    }
}

