/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import net.minecraft.class_9974;
import nofrills.Main;
import nofrills.misc.EntityRendering;
import nofrills.misc.RenderColor;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class Rendering {
    public static void drawFilled(class_4587 matrices, class_4597.class_4598 consumer, class_4184 camera, class_238 box, boolean throughWalls, RenderColor color) {
        matrices.method_22903();
        class_243 camPos = camera.method_19326().method_22882();
        matrices.method_22904(camPos.field_1352, camPos.field_1351, camPos.field_1350);
        class_4588 buffer = throughWalls ? consumer.getBuffer((class_1921)Layers.BoxFilledNoCull) : consumer.getBuffer((class_1921)Layers.BoxFilled);
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)color.r, (float)color.g, (float)color.b, (float)color.a);
        matrices.method_22909();
    }

    public static void drawOutline(class_4587 matrices, class_4597.class_4598 consumer, class_4184 camera, class_238 box, boolean throughWalls, RenderColor color) {
        matrices.method_22903();
        class_243 camPos = camera.method_19326().method_22882();
        matrices.method_22904(camPos.field_1352, camPos.field_1351, camPos.field_1350);
        class_4588 buffer = throughWalls ? consumer.getBuffer((class_1921)Layers.BoxOutlineNoCull) : consumer.getBuffer((class_1921)Layers.BoxOutline);
        class_9974.method_62295((class_4587)matrices, (class_4588)buffer, (class_238)box, (float)color.r, (float)color.g, (float)color.b, (float)color.a);
        matrices.method_22909();
    }

    public static void drawText(class_4597.class_4598 consumer, class_4184 camera, class_243 pos, class_2561 text, float scale, boolean throughWalls, RenderColor color) {
        Matrix4f matrices = new Matrix4f();
        class_243 camPos = camera.method_19326();
        float textX = (float)(pos.method_10216() - camPos.method_10216());
        float textY = (float)(pos.method_10214() - camPos.method_10214());
        float textZ = (float)(pos.method_10215() - camPos.method_10215());
        matrices.translate(textX, textY, textZ);
        matrices.rotate((Quaternionfc)camera.method_23767());
        matrices.scale(scale, -scale, scale);
        Main.mc.field_1772.method_27522(text, (float)(-Main.mc.field_1772.method_27525((class_5348)text)) / 2.0f, 1.0f, color.hex, true, matrices, (class_4597)consumer, throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public static void drawBeam(class_4587 matrices, class_4597.class_4598 consumer, class_4184 camera, class_243 pos, int height, boolean throughWalls, RenderColor color) {
        Rendering.drawFilled(matrices, consumer, camera, class_238.method_30048((class_243)pos, (double)0.35, (double)0.0, (double)0.35).method_1012(0.0, (double)height, 0.0), throughWalls, color);
    }

    public static void drawTracer(class_4587 matrices, class_4597.class_4598 consumer, class_4184 camera, class_243 pos, RenderColor color) {
        class_243 camPos = camera.method_19326();
        matrices.method_22903();
        matrices.method_22904(-camPos.method_10216(), -camPos.method_10214(), -camPos.method_10215());
        class_4587.class_4665 entry = matrices.method_23760();
        class_4588 buffer = consumer.getBuffer((class_1921)Layers.BoxOutlineNoCull);
        class_243 point = camPos.method_1019(class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330()));
        Vector3f normal = pos.method_46409().sub((float)point.method_10216(), (float)point.method_10214(), (float)point.method_10215()).normalize();
        buffer.method_56824(entry, (float)point.method_10216(), (float)point.method_10214(), (float)point.method_10215()).method_22915(color.r, color.g, color.b, color.a).method_61959(entry, normal);
        buffer.method_56824(entry, (float)pos.method_10216(), (float)pos.method_10214(), (float)pos.method_10215()).method_22915(color.r, color.g, color.b, color.a).method_61959(entry, normal);
        matrices.method_22909();
    }

    public static class Layers {
        public static final class_1921.class_4687 BoxFilled = class_1921.method_24049((String)"nofrills_box_filled", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.filledCull, (class_1921.class_4688)Parameters.filled.method_23617(false));
        public static final class_1921.class_4687 BoxFilledNoCull = class_1921.method_24049((String)"nofrills_box_filled_no_cull", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)Pipelines.filledNoCull, (class_1921.class_4688)Parameters.filled.method_23617(false));
        public static final class_1921.class_4687 BoxOutline = class_1921.method_24049((String)"nofrills_box_outline", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.outlineCull, (class_1921.class_4688)Parameters.lines.method_23617(false));
        public static final class_1921.class_4687 BoxOutlineNoCull = class_1921.method_24049((String)"nofrills_box_outline_no_cull", (int)1536, (boolean)false, (boolean)false, (RenderPipeline)Pipelines.outlineNoCull, (class_1921.class_4688)Parameters.lines.method_23617(false));
        public static final class_1921.class_4687 GuiLine = class_1921.method_24049((String)"nofrills_gui_line", (int)262144, (boolean)false, (boolean)false, (RenderPipeline)class_10799.field_56836, (class_1921.class_4688)Parameters.lines.method_23617(false));
    }

    public static class Parameters {
        public static final class_1921.class_4688.class_4689 filled = class_1921.class_4688.method_23598().method_23607(class_1921.field_22241);
        public static final class_1921.class_4688.class_4689 lines = class_1921.class_4688.method_23598().method_23607(class_1921.field_22241).method_23609(new class_4668.class_4677(OptionalDouble.of(3.0)));
    }

    public static class Pipelines {
        public static final RenderPipeline.Snippet filledSnippet = class_10799.field_56860;
        public static final RenderPipeline.Snippet outlineSnippet = class_10799.field_56859;
        public static final RenderPipeline filledNoCull = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{filledSnippet}).withLocation(class_2960.method_60655((String)"nofrills", (String)"pipeline/nofrills_filled_no_cull")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
        public static final RenderPipeline filledCull = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{filledSnippet}).withLocation(class_2960.method_60655((String)"nofrills", (String)"pipeline/nofrills_filled_cull")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).build());
        public static final RenderPipeline outlineNoCull = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{outlineSnippet}).withLocation(class_2960.method_60655((String)"nofrills", (String)"pipeline/nofrills_outline_no_cull")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
        public static final RenderPipeline outlineCull = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{outlineSnippet}).withLocation(class_2960.method_60655((String)"nofrills", (String)"pipeline/nofrills_outline_cull")).build());
    }

    public static class Entities {
        public static void drawFilled(class_1297 entity, boolean shouldRender, RenderColor color) {
            ((EntityRendering)entity).nofrills_mod$setRenderBoxFilled(shouldRender, color);
        }

        public static boolean isDrawingFilled(class_1297 entity) {
            return ((EntityRendering)entity).nofrills_mod$getRenderingFilled();
        }

        public static void drawOutline(class_1297 entity, boolean shouldRender, RenderColor color) {
            ((EntityRendering)entity).nofrills_mod$setRenderBoxOutline(shouldRender, color);
        }

        public static boolean isDrawingOutline(class_1297 entity) {
            return ((EntityRendering)entity).nofrills_mod$getRenderingOutline();
        }

        public static void drawGlow(class_1297 ent, boolean shouldGlow, RenderColor color) {
            ((EntityRendering)ent).nofrills_mod$setGlowingColored(shouldGlow, color);
        }

        public static boolean isDrawingGlow(class_1297 ent) {
            return ((EntityRendering)ent).nofrills_mod$getGlowing();
        }
    }
}

