/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import com.google.common.collect.Sets;
import java.util.HashSet;

public class ShardData {
    public static final HashSet<String> fishingShards = Sets.newHashSet((Object[])new String[]{"azure", "cod", "verdant", "salmon", "piranha", "abyssal lanternfish", "silentdepth", "inferno koi", "shinyfish"});
    public static final HashSet<String> commonShards = Sets.newHashSet((Object[])new String[]{"grove", "mist", "flash", "phanpyre", "cod", "phanflare", "night squid", "lapis zombie", "hideonleaf", "verdant", "chill", "bogged", "voracious spider", "hideongift", "birries", "tank zombie", "crow", "tadgang", "zealot", "coralot", "harpy", "mudworm", "golden ghoul", "azure", "bezal", "yog", "boreal owl", "newt", "miner zombie"});
    public static final HashSet<String> uncommonShards = Sets.newHashSet((Object[])new String[]{"bramble", "tide", "quake", "sparrow", "goldfin", "troglobyte", "hideoncave", "salamander", "cuboa", "pest", "mossybit", "rain slime", "seer", "heron", "obsidian defender", "salmon", "viper", "praying mantis", "zombie soldier", "bambuleaf", "sycophant", "seagull", "ent", "soul of the alpha", "mochibear", "magma slug", "flaming spider", "kiwi", "bruiser", "stridersurfer", "rana", "termite"});
    public static final HashSet<String> rareShards = Sets.newHashSet((Object[])new String[]{"sylvan", "cascade", "bolt", "bambloom", "toad", "glacite walker", "beaconmite", "lizard king", "python", "invisibug", "piranha", "hideongeon", "lapis skeleton", "cropeetle", "drowned", "star sentry", "hideondra", "abyssal lanternfish", "arachne", "bitbug", "revenant", "silentdepth", "skeletor", "thyst", "quartzfang", "hideonring", "snowfin", "kada knight", "carrot king", "wither specter", "matcho", "ladybug", "lumisquid", "crocodile", "bullfrog", "dreadwing", "joydive", "stalagmight", "fungloom", "eel", "king cobra", "lava flame", "draconic", "falcon", "inferno koi", "wither", "gecko", "hummingbird"});
    public static final HashSet<String> epicShards = Sets.newHashSet((Object[])new String[]{"terra", "cryo", "aero", "pandarai", "leviathan", "alligator", "fenlord", "basilisk", "iguana", "moray eel", "thorn", "lunar moth", "fire eel", "bal", "hideonsack", "water hydra", "flare", "loch emperor", "prince", "komodo dragon", "mimic", "shellwise", "barbarian duke x", "toucan", "hellwisp", "caiman", "firefly", "sea serpent", "ghost", "xyz", "leatherback", "cavernshade", "dragonfly"});
    public static final HashSet<String> legendaryShards = Sets.newHashSet((Object[])new String[]{"tenebris", "blizzard", "tempest", "chameleon", "tiamat", "wyvern", "tortoise", "endstone protector", "naga", "lapis creeper", "wartybug", "spike", "kraken", "taurus", "daemon", "moltenfish", "shinyfish", "ananke", "hideonbox", "lord jawbus", "burningsoul", "cinderbat", "megalith", "power dragon", "condor", "sun fish", "apex dragon", "dodo", "jormung", "etherdrake", "galaxy fish", "molthorn", "starborn", "titanoboa"});

    public static String getColorPrefix(String shard) {
        if (legendaryShards.contains(shard)) {
            return "\u00a76";
        }
        if (epicShards.contains(shard)) {
            return "\u00a75";
        }
        if (rareShards.contains(shard)) {
            return "\u00a79";
        }
        if (uncommonShards.contains(shard)) {
            return "\u00a7a";
        }
        if (commonShards.contains(shard)) {
            return "\u00a7f";
        }
        return "\u00a77";
    }

    public static int getColorHex(String shard) {
        if (legendaryShards.contains(shard)) {
            return -22016;
        }
        if (epicShards.contains(shard)) {
            return -5635926;
        }
        if (rareShards.contains(shard)) {
            return -11184641;
        }
        if (uncommonShards.contains(shard)) {
            return -11141291;
        }
        if (commonShards.contains(shard)) {
            return -1;
        }
        return -5592406;
    }
}

