/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2703;
import net.minecraft.class_2751;
import net.minecraft.class_2923;
import net.minecraft.class_5900;
import net.minecraft.class_8646;
import net.minecraft.class_9015;
import nofrills.Main;
import nofrills.config.SettingString;
import nofrills.events.ChatMsgEvent;
import nofrills.events.ReceivePacketEvent;
import nofrills.events.ServerJoinEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.SlayerUtil;
import nofrills.misc.Utils;

public class SkyblockData {
    public static final List<InstanceType> instances = List.of(new InstanceType("f0", "CATACOMBS_ENTRANCE"), new InstanceType("f1", "CATACOMBS_FLOOR_ONE"), new InstanceType("f2", "CATACOMBS_FLOOR_TWO"), new InstanceType("f3", "CATACOMBS_FLOOR_THREE"), new InstanceType("f4", "CATACOMBS_FLOOR_FOUR "), new InstanceType("f5", "CATACOMBS_FLOOR_FIVE"), new InstanceType("f6", "CATACOMBS_FLOOR_SIX"), new InstanceType("f7", "CATACOMBS_FLOOR_SEVEN"), new InstanceType("m1", "MASTER_CATACOMBS_FLOOR_ONE"), new InstanceType("m2", "MASTER_CATACOMBS_FLOOR_TWO"), new InstanceType("m3", "MASTER_CATACOMBS_FLOOR_THREE"), new InstanceType("m4", "MASTER_CATACOMBS_FLOOR_FOUR"), new InstanceType("m5", "MASTER_CATACOMBS_FLOOR_FIVE"), new InstanceType("m6", "MASTER_CATACOMBS_FLOOR_SIX"), new InstanceType("m7", "MASTER_CATACOMBS_FLOOR_SEVEN"), new InstanceType("k1", "KUUDRA_NORMAL"), new InstanceType("k2", "KUUDRA_HOT"), new InstanceType("k3", "KUUDRA_BURNING"), new InstanceType("k4", "KUUDRA_FIERY"), new InstanceType("k5", "KUUDRA_INFERNAL"), new InstanceType("t1", "KUUDRA_NORMAL"), new InstanceType("t2", "KUUDRA_HOT"), new InstanceType("t3", "KUUDRA_BURNING"), new InstanceType("t4", "KUUDRA_FIERY"), new InstanceType("t5", "KUUDRA_INFERNAL"));
    public static final List<String> dungeonClasses = List.of("Healer", "Mage", "Berserk", "Archer", "Tank");
    public static final SettingString dungeonClass = new SettingString("Berserker", "dungeonClass", "misc");
    private static final Pattern scoreRegex = Pattern.compile("Team Score: [0-9]* (.*)");
    public static double dungeonPower = 0.0;
    private static String location = "";
    private static String area = "";
    private static boolean inSkyblock = false;
    private static boolean instanceOver = false;
    private static List<String> lines = new ArrayList<String>();
    private static boolean showPing = false;

    private static void updateDungeonClass(String msg) {
        if (Main.mc.field_1724 != null) {
            String playerName = Main.mc.field_1724.method_5477().getString();
            for (String name : dungeonClasses) {
                String tag = Utils.format("[{}]", name);
                String selected = Utils.format("{} selected the {} Class!", playerName, name);
                String selectedHub = Utils.format("You have selected the {} Dungeon Class!", name);
                String milestone = Utils.format("{} Milestone", name);
                if (!msg.startsWith(tag) && !msg.equals(selectedHub) && !msg.equals(selected) && !msg.startsWith(milestone)) continue;
                dungeonClass.set(name);
                break;
            }
        }
    }

    private static double updateDungeonPower() {
        double total = 0.0;
        for (String line : Utils.getFooterLines()) {
            if (line.startsWith("Blessing of Power")) {
                total += (double)Utils.parseRoman(line.replace("Blessing of Power", "").trim());
            }
            if (!line.startsWith("Blessing of Time")) continue;
            total += 0.5 * (double)Utils.parseRoman(line.replace("Blessing of Time", "").trim());
        }
        return total;
    }

    public static String getLocation() {
        return location;
    }

    public static String getArea() {
        return area;
    }

    public static boolean isInSkyblock() {
        return inSkyblock;
    }

    public static boolean isInInstance() {
        return Utils.isInDungeons() || Utils.isInKuudra();
    }

    public static boolean isInstanceOver() {
        return instanceOver;
    }

    public static List<String> getLines() {
        return new ArrayList<String>(lines);
    }

    public static void showPing() {
        showPing = true;
        Utils.sendPingPacket();
    }

    public static void updateTabList(class_2703 packet, List<class_2703.class_2705> entries) {
        for (class_2703.class_2705 entry : entries) {
            String name = Utils.toPlainString(entry.comp_1111()).trim();
            if (!name.startsWith("Area:") && !name.startsWith("Dungeon:")) continue;
            area = name.split(":", 2)[1].trim();
            break;
        }
    }

    public static void updateObjective(class_2751 packet) {
        class_269 scoreboard = Main.mc.field_1724.method_7327();
        class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
        if (objective != null) {
            inSkyblock = Utils.toPlainString(objective.method_1114()).contains("SKYBLOCK");
        }
    }

    public static void updateScoreboard(class_5900 packet) {
        ArrayList<String> currentLines = new ArrayList<String>();
        class_269 scoreboard = Main.mc.field_1724.method_7327();
        class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
        for (class_9015 scoreHolder : scoreboard.method_1178()) {
            String line;
            class_268 team;
            if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null || (line = class_124.method_539((String)(team.method_1144().getString() + team.method_1136().getString()))).trim().isEmpty()) continue;
            String cleanLine = line.trim();
            if (cleanLine.startsWith(Utils.Symbols.zone) || cleanLine.startsWith(Utils.Symbols.zoneRift)) {
                location = cleanLine;
            }
            if (Utils.isInKuudra() && !instanceOver) {
                instanceOver = cleanLine.startsWith("Instance Shutdown");
            }
            currentLines.add(cleanLine);
        }
        lines = currentLines;
        SlayerUtil.updateQuestState(currentLines);
    }

    @EventHandler
    private static void onChat(ChatMsgEvent event) {
        if (Utils.isInDungeons()) {
            if (!instanceOver && scoreRegex.matcher(event.messagePlain.trim()).matches()) {
                instanceOver = true;
            }
            SkyblockData.updateDungeonClass(event.messagePlain);
        }
        if (SkyblockData.getArea().equals("Dungeon Hub")) {
            SkyblockData.updateDungeonClass(event.messagePlain);
        }
    }

    @EventHandler
    private static void onJoinServer(ServerJoinEvent event) {
        instanceOver = false;
        inSkyblock = false;
        location = "";
        area = "";
        lines.clear();
    }

    @EventHandler
    private static void onPing(ReceivePacketEvent event) {
        class_2596<?> class_25962;
        if (showPing && (class_25962 = event.packet) instanceof class_2923) {
            class_2923 pingPacket = (class_2923)class_25962;
            Utils.infoFormat("\u00a7aPing: \u00a7f{}\u00a77ms", class_156.method_658() - pingPacket.comp_2201());
            showPing = false;
        }
    }

    @EventHandler
    private static void onWorldTick(WorldTickEvent event) {
        if (Utils.isInDungeons()) {
            dungeonPower = SkyblockData.updateDungeonPower();
        } else if (dungeonPower != 0.0) {
            dungeonPower = 0.0;
        }
    }

    public static class InstanceType {
        public String name;
        public String type;

        public InstanceType(String name, String type2) {
            this.name = name;
            this.type = type2;
        }
    }
}

