/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1531;
import net.minecraft.class_1545;
import net.minecraft.class_1549;
import net.minecraft.class_1560;
import net.minecraft.class_1590;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import nofrills.Main;
import nofrills.events.EntityNamedEvent;
import nofrills.events.WorldTickEvent;
import nofrills.misc.EntityCache;
import nofrills.misc.Utils;

public class SlayerUtil {
    public static final SlayerBoss revenant = new SlayerBoss("Revenant Horror", List.of("Revenant Horror", "Atoned Horror"), ent -> ent instanceof class_1642);
    public static final SlayerBoss tarantula = new SlayerBoss("Tarantula Broodfather", List.of("Tarantula Broodfather", "Conjoined Brood"), ent -> ent instanceof class_1628 && !(ent instanceof class_1549));
    public static final SlayerBoss sven = new SlayerBoss("Sven Packmaster", List.of("Sven Packmaster"), ent -> ent instanceof class_1493);
    public static final SlayerBoss voidgloom = new SlayerBoss("Voidgloom Seraph", List.of("Voidgloom Seraph"), ent -> ent instanceof class_1560);
    public static final SlayerBoss vampire = new SlayerBoss("Riftstalker Bloodfiend", List.of("Bloodfiend"), ent -> {
        class_1657 player;
        return ent instanceof class_1657 && !Utils.isPlayer(player = (class_1657)ent);
    });
    public static final SlayerBoss blaze = new SlayerBoss("Inferno Demonlord", List.of("Inferno Demonlord", "\u24c9\u24ce\u24c5\u24bd\u24c4\u24ba\u24ca\u24c8", "\u24c6\u24ca\u24b6\u24cf\u24be\u24be"), ent -> ent instanceof class_1545 || ent instanceof class_1590 || ent instanceof class_1639);
    public static final List<SlayerBoss> bossList = List.of(revenant, tarantula, sven, voidgloom, vampire, blaze);
    private static final Pattern bossTimerRegex = Pattern.compile(".*[0-9][0-9]:[0-9][0-9].*");
    private static final Predicate<class_1297> predicate = entity -> entity.method_5805() && Utils.isMob(entity);
    private static final HashMap<String, class_1297> entities = new HashMap();
    public static boolean bossAlive = false;
    public static SlayerBoss currentBoss = null;

    public static boolean isSpawner(String name) {
        return name.equals(Utils.format("Spawned by: {}", Main.mc.field_1724.method_5477().getString()));
    }

    public static boolean isTimer(String name) {
        return bossTimerRegex.matcher(name).matches();
    }

    public static boolean isName(String name) {
        return SlayerUtil.currentBoss.entityNames.stream().anyMatch(name::contains);
    }

    public static boolean isFightingBoss(SlayerBoss boss) {
        return bossAlive && currentBoss != null && currentBoss.equals(boss);
    }

    public static class_1531 getSpawnerEntity() {
        return entities.containsKey("spawner") ? (class_1531)entities.get("spawner") : null;
    }

    public static class_1531 getTimerEntity() {
        return entities.containsKey("timer") ? (class_1531)entities.get("timer") : null;
    }

    public static class_1531 getNameEntity() {
        return entities.containsKey("name") ? (class_1531)entities.get("name") : null;
    }

    public static class_1309 getBossEntity() {
        return entities.containsKey("boss") ? (class_1309)entities.get("boss") : null;
    }

    public static void updateQuestState(List<String> lines) {
        bossAlive = lines.contains("Slay the boss!");
        for (SlayerBoss boss : bossList) {
            for (String line : lines) {
                if (!line.startsWith(boss.bossName)) continue;
                currentBoss = boss;
                return;
            }
        }
        currentBoss = null;
    }

    @EventHandler
    private static void onNamed(EntityNamedEvent event) {
        if (currentBoss != null && SlayerUtil.isSpawner(event.namePlain)) {
            entities.put("spawner", event.entity);
        }
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        class_1531 spawner;
        entities.entrySet().removeIf(entry -> !EntityCache.exists((class_1297)entry.getValue()));
        if (currentBoss != null && (spawner = SlayerUtil.getSpawnerEntity()) != null && !currentBoss.equals(blaze)) {
            for (class_1297 entity : Utils.getOtherEntities((class_1297)spawner, 0.5, 2.0, 0.5, predicate)) {
                if (entity instanceof class_1531) {
                    class_1531 stand = (class_1531)entity;
                    String name = Utils.toPlainString(stand.method_5477());
                    if (SlayerUtil.isTimer(name)) {
                        entities.put("timer", entity);
                    }
                    if (!SlayerUtil.isName(name)) continue;
                    entities.put("name", entity);
                    continue;
                }
                if (!SlayerUtil.currentBoss.predicate.test(entity)) continue;
                entities.put("boss", entity);
            }
        }
    }

    public static class SlayerBoss {
        public String bossName;
        public List<String> entityNames;
        public Predicate<class_1297> predicate;

        public SlayerBoss(String bossName, List<String> entityNames, Predicate<class_1297> predicate) {
            this.bossName = bossName;
            this.entityNames = entityNames;
            this.predicate = predicate;
        }
    }
}

