/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import nofrills.events.ScreenOpenEvent;
import nofrills.misc.RenderColor;
import nofrills.misc.Utils;

public class SlotOptions {
    public static final class_1799 background = SlotOptions.stackWithName(class_1802.field_8157.method_7854(), " ");
    public static final class_1799 first = SlotOptions.stackWithName(class_1802.field_8839.method_7854(), Utils.Symbols.format + "aClick here!");
    public static final class_1799 second = SlotOptions.stackWithName(class_1802.field_8771.method_7854(), Utils.Symbols.format + "9Click next.");
    public static final class_1799 third = SlotOptions.stackWithName(class_1802.field_8197.method_7854(), Utils.Symbols.format + "cClick after.");
    public static final ConcurrentHashMap<class_1735, Flags> slotFlags = new ConcurrentHashMap();

    public static class_1799 stackWithName(class_1799 stack, String name) {
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)name));
        return stack;
    }

    public static class_1799 stackWithQuantity(class_1799 stack, int quantity) {
        class_1799 copy = stack.method_7972();
        copy.method_7939(quantity);
        return copy;
    }

    public static boolean isSlotDisabled(class_1735 slot) {
        return slot != null && slotFlags.containsKey(slot) && SlotOptions.slotFlags.get((Object)slot).disabled;
    }

    public static void disableSlot(class_1735 slot, boolean disabled) {
        if (slot != null) {
            if (slotFlags.containsKey(slot)) {
                slotFlags.get(slot).setDisabled(disabled);
            } else {
                slotFlags.put(slot, new Flags().setDisabled(disabled));
            }
        }
    }

    public static void clearDisabledSlots() {
        for (Map.Entry<class_1735, Flags> entry : slotFlags.entrySet()) {
            Flags value = entry.getValue();
            if (!value.disabled) continue;
            entry.setValue(value.setDisabled(false));
        }
    }

    public static boolean isSlotSpoofed(class_1735 slot) {
        return slot != null && slotFlags.containsKey(slot) && SlotOptions.slotFlags.get((Object)slot).spoofed;
    }

    public static class_1799 getSpoofedStack(class_1735 slot) {
        if (SlotOptions.isSlotSpoofed(slot)) {
            return SlotOptions.slotFlags.get((Object)slot).replacement;
        }
        return class_1799.field_8037;
    }

    public static void spoofSlot(class_1735 slot, class_1799 replacement) {
        if (slot != null) {
            if (slotFlags.containsKey(slot)) {
                slotFlags.get(slot).setSpoofed(true).setReplacement(replacement);
            } else {
                slotFlags.put(slot, new Flags().setSpoofed(true).setReplacement(replacement));
            }
        }
    }

    public static void clearSpoof(class_1735 slot) {
        if (slot != null && slotFlags.containsKey(slot)) {
            slotFlags.get(slot).setSpoofed(false);
        }
    }

    public static void clearSpoofedSlots() {
        for (Map.Entry<class_1735, Flags> entry : slotFlags.entrySet()) {
            Flags value = entry.getValue();
            if (!value.spoofed) continue;
            entry.setValue(value.setSpoofed(false));
        }
    }

    public static boolean hasBackground(class_1735 slot) {
        return slot != null && slotFlags.containsKey(slot) && SlotOptions.slotFlags.get((Object)slot).background;
    }

    public static RenderColor getBackgroundColor(class_1735 slot) {
        if (SlotOptions.hasBackground(slot)) {
            return SlotOptions.slotFlags.get((Object)slot).color;
        }
        return RenderColor.fromHex(0xFFFFFF);
    }

    public static void setBackground(class_1735 slot, RenderColor color) {
        if (slot != null) {
            if (slotFlags.containsKey(slot)) {
                slotFlags.get(slot).setBackground(true).setBackgroundColor(color);
            } else {
                slotFlags.put(slot, new Flags().setBackground(true).setBackgroundColor(color));
            }
        }
    }

    public static void clearBackground(class_1735 slot) {
        if (slot != null && slotFlags.containsKey(slot)) {
            slotFlags.get(slot).setBackground(false);
        }
    }

    public static void clearBackgrounds() {
        for (Map.Entry<class_1735, Flags> entry : slotFlags.entrySet()) {
            Flags value = entry.getValue();
            if (!value.background) continue;
            entry.setValue(value.setBackground(false));
        }
    }

    @EventHandler
    private static void onScreen(ScreenOpenEvent event) {
        slotFlags.clear();
    }

    public static class Flags {
        public boolean disabled = false;
        public boolean spoofed = false;
        public class_1799 replacement = class_1799.field_8037;
        public boolean background = false;
        public RenderColor color = RenderColor.fromHex(0xFFFFFF);

        public Flags setDisabled(boolean toggle) {
            this.disabled = toggle;
            return this;
        }

        public Flags setSpoofed(boolean toggle) {
            this.spoofed = toggle;
            return this;
        }

        public Flags setReplacement(class_1799 replacement) {
            this.replacement = replacement;
            return this;
        }

        public Flags setBackground(boolean toggle) {
            this.background = toggle;
            return this;
        }

        public Flags setBackgroundColor(RenderColor color) {
            this.color = color;
            return this;
        }
    }

    public static class DisabledSlot {
        public int slotId;

        public DisabledSlot(class_1735 slot) {
            this.slotId = slot.field_7874;
        }

        public boolean isSlot(class_1735 slot) {
            return slot != null && slot.field_7874 == this.slotId;
        }
    }

    public static class SpoofedSlot {
        public int slotId;
        public class_1799 replacementStack;

        public SpoofedSlot(class_1735 slot, class_1799 replacementStack) {
            this.slotId = slot.field_7874;
            this.replacementStack = replacementStack;
        }

        public boolean isSlot(class_1735 slot) {
            return slot != null && slot.field_7874 == this.slotId;
        }
    }
}

