/*
 * Decompiled with CFR 0.152.
 */
package nofrills.misc;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2935;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4050;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5570;
import net.minecraft.class_5577;
import net.minecraft.class_5582;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7591;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import nofrills.Main;
import nofrills.events.WorldTickEvent;
import nofrills.features.dungeons.LeapOverlay;
import nofrills.misc.RaycastOptions;
import nofrills.misc.SkyblockData;
import nofrills.misc.TitleRendering;
import nofrills.mixin.ClientEntityManagerAccessor;
import nofrills.mixin.ClientWorldAccessor;
import nofrills.mixin.EntityIndexAccessor;
import nofrills.mixin.HandledScreenAccessor;
import nofrills.mixin.NbtComponentAccessor;
import nofrills.mixin.PlayerListHudAccessor;
import nofrills.mixin.SimpleEntityLookupAccessor;
import org.apache.commons.io.IOUtils;

public class Utils {
    public static final class_7591 noFrillsIndicator = new class_7591(6070463, null, class_2561.method_30163((String)"Message from NoFrills mod."), "NoFrills Mod");
    private static final class_5819 soundRandom = class_5819.method_43049((long)0L);
    private static final HashSet<String> abilityWhitelist = Sets.newHashSet((Object[])new String[]{"ABINGOPHONE", "SUPERBOOM_TNT", "INFINITE_SUPERBOOM_TNT", "ARROW_SWAPPER", "PUMPKIN_LAUNCHER", "SNOW_CANNON", "SNOW_BLASTER", "SNOW_HOWITZER"});
    private static class_437 newScreen = null;

    public static void showTitle(String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        Main.mc.field_1705.method_34004(class_2561.method_30163((String)title));
        Main.mc.field_1705.method_34002(class_2561.method_30163((String)subtitle));
        Main.mc.field_1705.method_34001(fadeInTicks, stayTicks, fadeOutTicks);
    }

    public static void showTitleCustom(String title, int stayTicks, int yOffset, float scale, int color) {
        ((TitleRendering)Main.mc.field_1705).nofrills_mod$setRenderTitle(title, stayTicks, yOffset, scale, color);
    }

    public static boolean isRenderingCustomTitle() {
        return ((TitleRendering)Main.mc.field_1705).nofrills_mod$isRenderingTitle();
    }

    public static void playSound(class_3414 event, class_3419 category, float volume, float pitch) {
        class_243 coords = Main.mc.field_1719.method_19538();
        Main.mc.method_1483().method_4873((class_1113)new class_1109(event, category, volume, pitch, soundRandom, coords.method_10216(), coords.method_10214(), coords.method_10215()));
    }

    public static void playSound(class_6880.class_6883<class_3414> event, class_3419 category, float volume, float pitch) {
        Utils.playSound((class_3414)event.comp_349(), category, volume, pitch);
    }

    public static void sendMessage(String message) {
        if (Main.mc.field_1724 != null && !message.isEmpty()) {
            if (message.startsWith("/")) {
                Main.mc.field_1724.field_3944.method_45730(message.substring(1));
            } else {
                Main.mc.field_1724.field_3944.method_45729(message);
            }
        }
    }

    public static class_5250 getTag() {
        return class_2561.method_43470((String)"[NoFrills] ").method_54663(6070463);
    }

    public static class_5250 getShortTag() {
        return class_2561.method_43470((String)"[NF] ").method_54663(6070463);
    }

    public static void info(String message) {
        Utils.infoRaw(class_2561.method_43470((String)message));
    }

    public static void infoButton(String message, String command) {
        class_2558.class_10609 click = new class_2558.class_10609(command);
        Utils.infoRaw(class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10958((class_2558)click)));
    }

    public static void infoLink(String message, String url) {
        class_2558.class_10608 click = new class_2558.class_10608(URI.create(url));
        Utils.infoRaw(class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10958((class_2558)click)));
    }

    public static void infoRaw(class_5250 message) {
        Main.mc.field_1705.method_1743().method_44811((class_2561)Utils.getTag().method_10852((class_2561)message.method_54663(0xFFFFFF)).method_27693("\u00a7r"), null, noFrillsIndicator);
    }

    public static void infoFormat(String message, Object ... values) {
        Utils.infoRaw(class_2561.method_43470((String)Utils.format(message, values)));
    }

    public static String getCoordsFormatted(String format) {
        class_2338 pos = Main.mc.field_1724.method_24515();
        return Utils.format(format, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static boolean isInZone(String zone, boolean containsCheck) {
        if (containsCheck) {
            return SkyblockData.getLocation().contains(zone);
        }
        return SkyblockData.getLocation().startsWith(zone);
    }

    public static boolean isInArea(String area) {
        return SkyblockData.getArea().equals(area);
    }

    public static boolean isInDungeons() {
        return Utils.isInZone(Symbols.zone + " The Catacombs", false);
    }

    public static boolean isOnDungeonFloor(String floor) {
        return Utils.isInDungeons() && SkyblockData.getLocation().endsWith(floor + ")");
    }

    public static boolean isInDungeonBoss(String floor) {
        boolean bl;
        block17: {
            block16: {
                if (!Utils.isOnDungeonFloor(floor)) break block16;
                switch (floor) {
                    case "4": {
                        if (Utils.isInZone(50.0, 112.0, 81.0, -40.0, 53.0, -40.0)) {
                            break;
                        }
                        break block16;
                    }
                    case "5": {
                        if (Utils.isInZone(50.0, 112.0, 118.0, -40.0, 53.0, -8.0)) {
                            break;
                        }
                        break block16;
                    }
                    case "6": {
                        if (Utils.isInZone(22.0, 110.0, 134.0, -40.0, 51.0, -8.0)) {
                            break;
                        }
                        break block16;
                    }
                    case "7": {
                        if (Utils.isInZone(134.0, 254.0, 147.0, -8.0, 0.0, -8.0)) {
                            break;
                        }
                        break block16;
                    }
                    default: {
                        break block16;
                    }
                }
                bl = true;
                break block17;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isInKuudra() {
        return SkyblockData.getArea().equals("Kuudra");
    }

    public static boolean isInChateau() {
        return Utils.isInZone(Symbols.zoneRift + " Stillgore Ch\u00e2teau", false) || Utils.isInZone(Symbols.zoneRift + " Oubliette", false);
    }

    public static boolean isOnPrivateIsland() {
        return Utils.isInZone(Symbols.zone + " Your Island", false);
    }

    public static boolean isOnGardenPlot() {
        return SkyblockData.getLines().stream().anyMatch(line -> line.contains("Plot -"));
    }

    public static boolean isInGarden() {
        return Utils.isInZone(Symbols.zone + " The Garden", true) || Utils.isOnGardenPlot();
    }

    public static boolean isOnModernIsland() {
        HashSet islands = Sets.newHashSet((Object[])new String[]{"The Park", "Galatea", "Catacombs"});
        return islands.contains(SkyblockData.getArea());
    }

    public static boolean isInstanceOver() {
        return SkyblockData.isInstanceOver();
    }

    public static boolean isInSkyblock() {
        return SkyblockData.isInSkyblock();
    }

    public static boolean isPlayer(class_1657 entity) {
        String displayName;
        class_640 listEntry;
        class_634 handler = Main.mc.method_1562();
        if (handler != null && (listEntry = handler.method_2871(entity.method_5667())) != null && (displayName = listEntry.method_2966().getName()) != null) {
            String name = class_124.method_539((String)displayName);
            return !name.isEmpty() && !name.contains(" ");
        }
        return entity == Main.mc.field_1724;
    }

    public static boolean isMob(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !Utils.isPlayer(player);
        }
        return entity instanceof class_1309;
    }

    public static boolean isBaseHealth(class_1309 entity, float health) {
        return entity.method_6032() >= health && entity.method_6032() % health == 0.0f;
    }

    public static class_238 getLerpedBox(class_1297 entity, float tickProgress) {
        return entity.method_18377(class_4050.field_18076).method_30757(entity.method_30950(tickProgress));
    }

    public static List<class_1297> getEntities() {
        if (Main.mc.field_1687 != null) {
            class_5582<class_1297> manager = ((ClientWorldAccessor)Main.mc.field_1687).getManager();
            class_5577 lookup = ((ClientEntityManagerAccessor)manager).getLookup();
            class_5570 index = ((SimpleEntityLookupAccessor)lookup).getIndex();
            Int2ObjectMap map = ((EntityIndexAccessor)index).getEntityMap();
            return new ArrayList<class_1297>((Collection<class_1297>)map.values());
        }
        return new ArrayList<class_1297>();
    }

    public static List<class_1297> getOtherEntities(class_1297 except, class_238 box, Predicate<? super class_1297> filter) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (class_1297 ent : Utils.getEntities()) {
            if (ent == null || ent == except || filter != null && !filter.test((class_1297)ent) || !ent.method_5829().method_994(box)) continue;
            entities.add(ent);
        }
        return entities;
    }

    public static List<class_1297> getOtherEntities(class_1297 from, double distX, double distY, double distZ, Predicate<? super class_1297> filter) {
        return Utils.getOtherEntities(from, class_238.method_30048((class_243)from.method_19538(), (double)distX, (double)distY, (double)distZ), filter);
    }

    public static List<class_1297> getOtherEntities(class_1297 from, double dist, Predicate<? super class_1297> filter) {
        return Utils.getOtherEntities(from, class_238.method_30048((class_243)from.method_19538(), (double)dist, (double)dist, (double)dist), filter);
    }

    public static void sendPingPacket() {
        class_634 handler = Main.mc.method_1562();
        if (handler != null) {
            handler.method_52787((class_2596)new class_2935(class_156.method_658()));
        }
    }

    public static List<class_1799> getEntityArmor(class_1309 entity) {
        return List.of(entity.method_6118(class_1304.field_6169), entity.method_6118(class_1304.field_6174), entity.method_6118(class_1304.field_6172), entity.method_6118(class_1304.field_6166));
    }

    public static class_2487 getCustomData(class_1799 stack) {
        class_9279 data;
        if (stack != null && !stack.method_7960() && (data = (class_9279)stack.method_58694(class_9334.field_49628)) != null) {
            return ((NbtComponentAccessor)data).get();
        }
        return null;
    }

    public static String getSkyblockId(class_2487 customData) {
        if (customData != null && customData.method_10545("id")) {
            return customData.method_10558("id").orElse("");
        }
        return "";
    }

    public static String getSkyblockId(class_1799 stack) {
        return Utils.getSkyblockId(Utils.getCustomData(stack));
    }

    public static GameProfile getTextures(class_1799 stack) {
        class_9296 profile = (class_9296)stack.method_57353().method_58694(class_9334.field_49617);
        if (!stack.method_7960() && profile != null) {
            return profile.comp_2413();
        }
        return null;
    }

    public static String getTextureUrl(GameProfile profile) {
        Property property;
        MinecraftSessionService service;
        MinecraftProfileTextures textures;
        if (profile != null && (textures = (service = Main.mc.method_1495()).unpackTextures(property = service.getPackedTextures(profile))).skin() != null) {
            return textures.skin().getUrl();
        }
        return "";
    }

    public static String getTextureUrl(class_1799 stack) {
        return Utils.getTextureUrl(Utils.getTextures(stack));
    }

    public static boolean isTextureEqual(GameProfile profile, String textureId) {
        String url = Utils.getTextureUrl(profile);
        if (url != null) {
            return url.endsWith("texture/" + textureId);
        }
        return false;
    }

    public static List<String> getLoreLines(class_1799 stack) {
        ArrayList<String> lines = new ArrayList<String>();
        class_9290 lore = (class_9290)stack.method_57353().method_58694(class_9334.field_49632);
        if (lore != null) {
            for (class_2561 line : lore.comp_2400()) {
                lines.add(Utils.toPlainString(line).trim());
            }
        }
        return lines;
    }

    public static String getRightClickAbility(class_1799 stack) {
        for (String line : Utils.getLoreLines(stack)) {
            if (!line.contains("Ability: ") || !line.endsWith("RIGHT CLICK")) continue;
            return line;
        }
        return "";
    }

    public static boolean hasRightClickAbility(class_1799 stack) {
        String id = Utils.getSkyblockId(stack);
        if (!id.isEmpty()) {
            if (id.startsWith("ABIPHONE")) {
                return true;
            }
            if (abilityWhitelist.contains(id)) {
                return true;
            }
        }
        return !Utils.getRightClickAbility(stack).isEmpty();
    }

    public static boolean hasEitherStat(class_1799 stack, String ... stats) {
        List<String> lines = Utils.getLoreLines(stack);
        Iterator iterator = Arrays.stream(stats).iterator();
        while (iterator.hasNext()) {
            String stat = (String)iterator.next();
            for (String line : lines) {
                if (!line.startsWith(stat + ":")) continue;
                return true;
            }
        }
        return false;
    }

    public static class_2338 findGround(class_2338 pos, int maxDistance) {
        int dist = Math.clamp((long)maxDistance, 0, 256);
        for (int i = 0; i <= dist; ++i) {
            class_2338 below = pos.method_10087(i);
            if (Main.mc.field_1687.method_8320(below).method_26215()) continue;
            return below;
        }
        return pos;
    }

    public static String uppercaseFirst(String text, boolean replaceUnderscores) {
        return Arrays.stream(replaceUnderscores ? text.replaceAll("_", " ").split("\\s") : text.split("\\s")).map(word -> Character.toTitleCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" ")).trim();
    }

    private static int getVersionNumber(String version) {
        try {
            String[] numbers = version.split("\\.");
            return Integer.parseInt(numbers[0]) * 1000 + Integer.parseInt(numbers[1]) * 100 + Integer.parseInt(numbers[2]);
        }
        catch (RuntimeException ignored) {
            return 0;
        }
    }

    public static void checkUpdate(boolean notifyIfMatch) {
        new Thread(() -> {
            try {
                String version = ((ModContainer)FabricLoader.getInstance().getModContainer("nofrills").orElseThrow()).getMetadata().getVersion().getFriendlyString();
                InputStream connection = URI.create("https://raw.githubusercontent.com/WhatYouThing/NoFrills/refs/heads/main/gradle.properties").toURL().openStream();
                for (String line : IOUtils.toString((InputStream)connection, (Charset)StandardCharsets.UTF_8).split("\n")) {
                    String newest;
                    if (!line.startsWith("mod_version=") || Utils.getVersionNumber(newest = line.replace("mod_version=", "")) <= Utils.getVersionNumber(version)) continue;
                    Utils.infoLink(Utils.format("\u00a7a\u00a7lNew version available! \u00a7aClick here to open the Modrinth releases page. \u00a77Current: {}, Newest: {}", version, newest), "https://modrinth.com/mod/nofrills/versions");
                    return;
                }
                if (notifyIfMatch) {
                    Utils.info("\u00a7aNoFrills is up to date.");
                }
            }
            catch (IOException e) {
                Utils.info("\u00a7cAn error occurred while checking for an update. Additional information can be found in the log.");
                StringBuilder trace = new StringBuilder();
                for (StackTraceElement element : e.getStackTrace()) {
                    trace.append("\n\tat ").append(element.toString());
                }
                Main.LOGGER.error("{}{}", (Object)e.getMessage(), (Object)trace);
            }
        }).start();
    }

    public static boolean isInZone(double x1, double y1, double z1, double x2, double y2, double z2) {
        class_238 area = new class_238(x1, y1, z1, x2, y2, z2);
        return area.method_1006(Main.mc.field_1724.method_19538());
    }

    public static boolean isSelf(Object entity) {
        return entity == Main.mc.field_1724;
    }

    public static float horizontalDistance(class_243 from, class_243 to) {
        float x = (float)(from.method_10216() - to.method_10216());
        float z = (float)(from.method_10215() - to.method_10215());
        return class_3532.method_15355((float)(x * x + z * z));
    }

    public static class_239 raycastFullBlock(class_1297 entity, double maxDistance, float tickDelta) {
        class_243 height = entity.method_30950(tickDelta).method_1031(0.0, Utils.isOnModernIsland() && !Utils.isInDungeons() ? 1.27 : 1.54, 0.0);
        class_243 camPos = entity.method_5836(tickDelta);
        class_243 rot = entity.method_5828(tickDelta);
        class_243 pos = new class_243(camPos.method_10216(), height.method_10214(), camPos.method_10215());
        class_243 end = pos.method_1031(rot.field_1352 * maxDistance, rot.field_1351 * maxDistance, rot.field_1350 * maxDistance);
        class_3959 context = new class_3959(pos, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, entity);
        ((RaycastOptions)context).nofrills_mod$setConsiderAllFull(true);
        return entity.method_37908().method_17742(context);
    }

    public static class_1297 findNametagOwner(class_1297 armorStand, List<class_1297> otherEntities) {
        class_1297 entity = null;
        float lowestDist = 2.0f;
        double maxY = armorStand.method_19538().method_10214();
        for (class_1297 ent : otherEntities) {
            float dist = Utils.horizontalDistance(ent.method_19538(), armorStand.method_19538());
            if (ent instanceof class_1531 || !(ent.method_19538().method_10214() < maxY) || !(dist < lowestDist)) continue;
            entity = ent;
            lowestDist = dist;
        }
        return entity;
    }

    public static boolean hasGlint(class_1799 stack) {
        Optional component = stack.method_57380().method_57845(class_9334.field_49641);
        return component != null && component.isPresent();
    }

    public static List<String> getTabListLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (Main.mc.method_1562() != null) {
            for (class_640 entry : Main.mc.method_1562().method_2880()) {
                if (entry.method_2971() == null) continue;
                lines.add(Utils.toPlainString(entry.method_2971()).trim());
            }
        }
        return lines;
    }

    public static List<String> getFooterLines() {
        ArrayList<String> list = new ArrayList<String>();
        class_2561 footer = ((PlayerListHudAccessor)Main.mc.field_1705.method_1750()).getFooter();
        if (footer != null) {
            String[] lines;
            for (String line : lines = footer.getString().split("\n")) {
                String l = line.trim();
                if (l.isEmpty()) continue;
                list.add(l);
            }
        }
        return list;
    }

    public static List<class_1735> getContainerSlots(class_1707 handler) {
        class_1263 inventory = handler.method_7629();
        ArrayList<class_1735> slots = new ArrayList<class_1735>((Collection<class_1735>)handler.field_7761);
        slots.removeIf(slot -> inventory.method_5438(slot.field_7874).equals(class_1799.field_8037));
        return slots;
    }

    public static class_1799 getHeldItem() {
        return Main.mc.field_1724 != null ? Main.mc.field_1724.method_6047() : class_1799.field_8037;
    }

    public static class_1735 getFocusedSlot() {
        return Main.mc.field_1755 != null ? ((HandledScreenAccessor)Main.mc.field_1755).getFocusedSlot() : null;
    }

    private static int romanToInt(Character roman) {
        return switch (Character.toUpperCase(roman.charValue())) {
            case 'I' -> 1;
            case 'V' -> 5;
            case 'X' -> 10;
            case 'L' -> 50;
            case 'C' -> 100;
            case 'D' -> 500;
            case 'M' -> 1000;
            default -> 0;
        };
    }

    public static int parseRoman(String roman) {
        int result = 0;
        for (int i = 0; i < roman.length(); ++i) {
            int number = Utils.romanToInt(Character.valueOf(roman.charAt(i)));
            if (number == 0) {
                return 0;
            }
            if (i != roman.length() - 1) {
                int nextNumber = Utils.romanToInt(Character.valueOf(roman.charAt(i + 1)));
                if (number < nextNumber) {
                    result -= number;
                    continue;
                }
                result += number;
                continue;
            }
            result += number;
        }
        return result;
    }

    public static String toLower(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toUpper(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public static String toPlainString(class_2561 text) {
        if (text != null) {
            return class_124.method_539((String)text.getString());
        }
        return "";
    }

    public static String format(String string, Object ... values) {
        int lastIndex = 0;
        Iterator iterator = Arrays.stream(values).iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            int bracket = ((String)string).indexOf("{}", lastIndex);
            if (bracket == -1) continue;
            string = ((String)string).substring(0, bracket) + String.valueOf(value) + ((String)string).substring(bracket + 2);
            lastIndex = bracket + 2;
        }
        return string;
    }

    public static String formatDecimal(double number) {
        return Utils.formatDecimal(number, 2);
    }

    public static String formatDecimal(float number) {
        return Utils.formatDecimal(number, 2);
    }

    public static String formatDecimal(double number, int spaces) {
        return new DecimalFormat("0." + "0".repeat(spaces)).format(number);
    }

    public static String formatDecimal(float number, int spaces) {
        return Utils.formatDecimal((double)number, spaces);
    }

    public static String formatSeparator(long number) {
        return String.format("%,d", number);
    }

    public static String formatSeparator(int number) {
        return Utils.formatSeparator((long)number);
    }

    public static String formatSeparator(double number) {
        return String.format("%,.1f", number);
    }

    public static String formatSeparator(float number) {
        return Utils.formatSeparator((double)number);
    }

    public static boolean isLeapMenu(String title) {
        return LeapOverlay.instance.isActive() && Utils.isInDungeons() && title.equals("Spirit Leap");
    }

    public static void setScreen(class_437 screen) {
        newScreen = screen;
    }

    @EventHandler
    private static void onTick(WorldTickEvent event) {
        if (newScreen != null) {
            Main.mc.method_1507(newScreen);
            newScreen = null;
        }
    }

    public static class Symbols {
        public static String zone = "\u23e3";
        public static String zoneRift = "\u0444";
        public static String star = "\u272f";
        public static String heart = "\u2764";
        public static String skull = "\u2620";
        public static String format = "\u00a7";
        public static String vampLow = "\u0489";
        public static String check = "\u2714";
        public static String cross = "\u2716";
        public static String bingo = "\u24b7";
        public static String aquatic = "\u2693";
        public static String magmatic = "\u2646";
    }
}

