/*
 * Decompiled with CFR 0.152.
 */
package nofrills.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import meteordevelopment.orbit.ICancellable;
import net.minecraft.class_1140;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import nofrills.Main;
import nofrills.config.Config;
import nofrills.events.InteractBlockEvent;
import nofrills.events.InteractEntityEvent;
import nofrills.events.InteractItemEvent;
import nofrills.events.ScreenOpenEvent;
import nofrills.features.hunting.ShardTracker;
import nofrills.features.misc.UnfocusedTweaks;
import nofrills.features.tweaks.NoDropSwing;
import nofrills.features.tweaks.NoLoadingScreen;
import nofrills.mixin.SoundManagerAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public class_638 field_1687;

    @Shadow
    public abstract void method_1507(@Nullable class_437 var1);

    @Unique
    @Final
    class_1140 getSoundSystem() {
        if (Main.mc.method_1483() != null) {
            return ((SoundManagerAccessor)Main.mc.method_1483()).getSoundSystem();
        }
        return null;
    }

    @WrapWithCondition(method={"handleInputEvents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;swingHand(Lnet/minecraft/util/Hand;)V")})
    private boolean onDropSwing(class_746 instance, class_1268 hand) {
        return !NoDropSwing.active();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBeforeOpenScreen(class_437 screen, CallbackInfo ci) {
        if (NoLoadingScreen.instance.isActive() && screen instanceof class_434) {
            Main.mc.method_1507(null);
            ci.cancel();
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="TAIL")})
    private void onOpenScreen(class_437 screen, CallbackInfo ci) {
        if (this.field_1687 == null) {
            return;
        }
        if (screen != null) {
            Main.eventBus.post((Object)new ScreenOpenEvent(screen));
        } else if (ShardTracker.instance.isActive()) {
            ShardTracker.refreshDisplay();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;")}, cancellable=true)
    private void onInteractEntity(CallbackInfo ci, @Local class_1297 entity, @Local class_3966 entityHitResult) {
        if (((InteractEntityEvent)Main.eventBus.post((ICancellable)new InteractEntityEvent(entity, entityHitResult))).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;interactBlock(Lnet/minecraft/client/network/ClientPlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;")}, cancellable=true)
    private void onInteractBlock(CallbackInfo ci, @Local class_3965 blockHitResult) {
        if (((InteractBlockEvent)Main.eventBus.post((ICancellable)new InteractBlockEvent(blockHitResult))).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;interactItem(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;")}, cancellable=true)
    private void onInteractItem(CallbackInfo ci) {
        if (((InteractItemEvent)Main.eventBus.post((ICancellable)new InteractItemEvent())).isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    private void beforeStop(CallbackInfo ci) {
        Config.save();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V", args={"ldc=yield"})})
    private void beforeRender(CallbackInfo ci) {
        if (UnfocusedTweaks.active() && UnfocusedTweaks.fpsLimit.value() > 0) {
            RenderSystem.limitDisplayFPS((int)UnfocusedTweaks.fpsLimit.value());
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;skipGameRender:Z")})
    private boolean skipRender(boolean original) {
        if (Main.mc.field_1687 != null && UnfocusedTweaks.active() && UnfocusedTweaks.noWorldRender.value()) {
            return true;
        }
        return original;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/option/InactivityFpsLimiter;update()I")})
    private int skipLimiter(int original) {
        if (UnfocusedTweaks.instance.isActive() && UnfocusedTweaks.noVanilla.value()) {
            return (Integer)Main.mc.field_1690.method_42524().method_41753();
        }
        return original;
    }

    @Inject(method={"onWindowFocusChanged"}, at={@At(value="TAIL")})
    private void onFocusChanged(boolean focused, CallbackInfo ci) {
        if (this.getSoundSystem() != null && UnfocusedTweaks.instance.isActive() && UnfocusedTweaks.muteSounds.value()) {
            this.getSoundSystem().method_4844(class_3419.field_15250, !focused ? 0.0f : ((Double)Main.mc.field_1690.method_45578(class_3419.field_15250).method_41753()).floatValue());
        }
    }
}

