/*
 * Decompiled with CFR 0.152.
 */
package chadlymasterson.safepastures;

import chadlymasterson.safepastures.SafePastures;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7924;

public class ConfigLoader {
    private static final String CLASS_NAME = ConfigLoader.class.getSimpleName();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir();
    private static File CONFIG_FILE;
    public boolean preventPokemonDamageInPasture = true;
    public boolean useBlackList = false;
    public Map<String, Boolean> damageSourceBlackList = new HashMap<String, Boolean>();
    public static final Gson GSON;

    public ConfigLoader(String filename, class_3218 serverWorld) {
        CONFIG_FILE = new File(String.valueOf(CONFIG_PATH) + "/safepastures", filename);
        this.populateDefaultDamageSources(serverWorld);
        this.load();
    }

    public void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            ConfigLoader loaded = (ConfigLoader)GSON.fromJson((Reader)reader, ConfigLoader.class);
            this.preventPokemonDamageInPasture = loaded.preventPokemonDamageInPasture;
            this.useBlackList = loaded.useBlackList;
            this.damageSourceBlackList = loaded.damageSourceBlackList;
        }
        catch (IOException e) {
            SafePastures.LOGGER.error("Failed to load config: " + e.getMessage());
        }
    }

    public void save() {
        CONFIG_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            SafePastures.LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    public void populateDefaultDamageSources(class_3218 serverWorld) {
        class_2378 damageTypeRegistry = serverWorld.method_30349().method_30530(class_7924.field_42534);
        for (class_2960 id : damageTypeRegistry.method_10235()) {
            this.damageSourceBlackList.putIfAbsent(id.method_12832(), false);
        }
    }

    public String toJsonString() {
        return GSON.toJson((Object)this);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    }
}

